/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.HashMap;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxVerificationHelper;

public class SPDXChecksum {
    public static final HashMap<String, String> ALGORITHM_TO_URI = new HashMap();
    public static final HashMap<String, String> URI_TO_ALGORITHM = new HashMap();
    private String algorithm;
    private String value;
    private Model model;
    private Node checksumNode;
    private Resource checksumResource;

    protected static Resource convertToResource(Model cmodel, Node cnode) throws InvalidSPDXAnalysisException {
        if (cnode.isBlank()) {
            return cmodel.createResource(cnode.getBlankNodeId());
        }
        if (cnode.isURI()) {
            return cmodel.createResource(cnode.getURI());
        }
        throw new InvalidSPDXAnalysisException("Can not create a checksum from a literal");
    }

    protected static Resource findSpdxChecksum(Model model, SPDXChecksum checksum) throws InvalidSPDXAnalysisException {
        Node checksumValueProperty = model.getProperty("http://spdx.org/rdf/terms#", "checksumValue").asNode();
        Triple checksumValueMatch = Triple.createMatch(null, (Node)checksumValueProperty, (Node)Node.createLiteral((String)checksum.getValue()));
        ExtendedIterator checksumMatchIter = model.getGraph().find((TripleMatch)checksumValueMatch);
        while (checksumMatchIter.hasNext()) {
            Triple checksumMatchTriple = (Triple)checksumMatchIter.next();
            Node checksumNode = checksumMatchTriple.getSubject();
            Node algorithmProperty = model.getProperty("http://spdx.org/rdf/terms#", "algorithm").asNode();
            Triple algorithmMatch = Triple.createMatch((Node)checksumNode, (Node)algorithmProperty, null);
            ExtendedIterator algorithmMatchIterator = model.getGraph().find((TripleMatch)algorithmMatch);
            if (!algorithmMatchIterator.hasNext()) continue;
            String algorithm = "UNKNOWN";
            Triple algorithmMatchTriple = (Triple)algorithmMatchIterator.next();
            if (algorithmMatchTriple.getObject().isLiteral()) {
                algorithm = algorithmMatchTriple.getObject().toString(false);
            } else if (algorithmMatchTriple.getObject().isURI() && (algorithm = URI_TO_ALGORITHM.get(algorithmMatchTriple.getObject().getURI())) == null) {
                algorithm = "UNKNOWN";
            }
            if (!algorithm.equals(checksum.getAlgorithm())) continue;
            return SPDXChecksum.convertToResource(model, checksumNode);
        }
        return null;
    }

    public SPDXChecksum(String algorithm, String value) {
        this.algorithm = algorithm;
        this.value = value;
    }

    public SPDXChecksum(Model spdxModel, Node checksumNode) throws InvalidSPDXAnalysisException {
        Triple t;
        this.model = spdxModel;
        this.checksumNode = checksumNode;
        if (checksumNode.isBlank()) {
            this.checksumResource = this.model.createResource(checksumNode.getBlankNodeId());
        } else if (checksumNode.isURI()) {
            this.checksumResource = this.model.createResource(checksumNode.getURI());
        } else {
            throw new InvalidSPDXAnalysisException("Checksum node can not be a literal");
        }
        Node p = spdxModel.getProperty("http://spdx.org/rdf/terms#", "algorithm").asNode();
        Triple m = Triple.createMatch((Node)checksumNode, (Node)p, null);
        ExtendedIterator tripleIter = spdxModel.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            if (t.getObject().isLiteral()) {
                this.algorithm = t.getObject().toString(false);
                continue;
            }
            if (t.getObject().isURI()) {
                this.algorithm = URI_TO_ALGORITHM.get(t.getObject().getURI());
                if (this.algorithm != null) continue;
                this.algorithm = "UNKNOWN";
                continue;
            }
            throw new InvalidSPDXAnalysisException("Invalid checksum algorithm - must be one of the defined algorithms supported by SPDX.");
        }
        p = spdxModel.getProperty("http://spdx.org/rdf/terms#", "checksumValue").asNode();
        m = Triple.createMatch((Node)checksumNode, (Node)p, null);
        tripleIter = spdxModel.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.value = t.getObject().toString(false);
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) throws InvalidSPDXAnalysisException {
        this.algorithm = algorithm;
        if (this.model != null && this.checksumNode != null) {
            Resource algResource = SPDXChecksum.algorithmStringToResource(algorithm, this.model);
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "algorithm");
            this.model.removeAll(this.checksumResource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "algorithm");
            this.checksumResource.addProperty(p, (RDFNode)algResource);
        }
    }

    public static Resource algorithmStringToResource(String algorithm, Model model) throws InvalidSPDXAnalysisException {
        String resourceUri = ALGORITHM_TO_URI.get(algorithm);
        if (resourceUri == null) {
            throw new InvalidSPDXAnalysisException("Invalid algorithm: " + algorithm);
        }
        Resource retval = model.createResource(resourceUri);
        return retval;
    }

    public static String algorithmResourceToString(Resource algorithmResource) throws InvalidSPDXAnalysisException {
        String uri = algorithmResource.getURI();
        if (!algorithmResource.isURIResource()) {
            throw new InvalidSPDXAnalysisException("Algorithm resource must be a URI");
        }
        String retval = URI_TO_ALGORITHM.get(uri);
        if (retval == null) {
            throw new InvalidSPDXAnalysisException("Invalid algorithm resource.");
        }
        return retval;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        if (this.model != null && this.checksumNode != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "checksumValue");
            this.model.removeAll(this.checksumResource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "checksumValue");
            this.checksumResource.addProperty(p, value);
        }
    }

    public Resource createResource(Model model) {
        Resource r;
        this.model = model;
        Resource type = model.createResource("http://spdx.org/rdf/terms#Checksum");
        try {
            r = SPDXChecksum.findSpdxChecksum(model, this);
        }
        catch (InvalidSPDXAnalysisException e) {
            r = null;
        }
        if (r == null) {
            r = model.createResource(type);
        }
        if (this.algorithm != null) {
            Property algProperty = model.createProperty("http://spdx.org/rdf/terms#", "algorithm");
            Resource algResource = model.createResource(ALGORITHM_TO_URI.get(this.algorithm));
            r.addProperty(algProperty, (RDFNode)algResource);
        }
        if (this.value != null) {
            Property valueProperty = model.createProperty("http://spdx.org/rdf/terms#", "checksumValue");
            r.addProperty(valueProperty, this.value);
        }
        this.checksumNode = r.asNode();
        this.checksumResource = r;
        return r;
    }

    public ArrayList<String> verify() {
        ArrayList<String> retval = new ArrayList<String>();
        String algorithm = this.getAlgorithm();
        if (algorithm == null || algorithm.isEmpty()) {
            retval.add("Missing required algorithm");
        } else if (!ALGORITHM_TO_URI.containsKey(algorithm)) {
            retval.add("Unsupported checksum algorithm: " + algorithm);
        }
        String value = this.getValue();
        if (value == null || value.isEmpty()) {
            retval.add("Missing required checksum value");
        } else {
            String verify = SpdxVerificationHelper.verifyChecksumString(value);
            if (verify != null) {
                retval.add(verify);
            }
        }
        return retval;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SPDXChecksum)) {
            return false;
        }
        SPDXChecksum compare = (SPDXChecksum)o;
        if (!compare.getAlgorithm().equals(this.getAlgorithm())) {
            return false;
        }
        return compare.getValue().compareToIgnoreCase(this.getValue()) == 0;
    }

    public Resource getResource() {
        return this.checksumResource;
    }

    static {
        ALGORITHM_TO_URI.put("SHA1", "http://spdx.org/rdf/terms#checksumAlgorithm_sha1");
        URI_TO_ALGORITHM.put("http://spdx.org/rdf/terms#checksumAlgorithm_sha1", "SHA1");
    }
}

