/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Iterator;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXLicenseInfo;
import org.spdx.rdfparser.SPDXLicenseSet;

public class SPDXConjunctiveLicenseSet
extends SPDXLicenseSet {
    public SPDXConjunctiveLicenseSet(Model model, Node node) throws InvalidSPDXAnalysisException {
        super(model, node);
    }

    public SPDXConjunctiveLicenseSet(SPDXLicenseInfo[] conjunctiveLicenses) {
        super(conjunctiveLicenses);
    }

    @Override
    protected Resource _createResource(Model model) {
        Resource type = model.createResource("http://spdx.org/rdf/terms#ConjunctiveLicenseSet");
        return super._createResource(model, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        boolean moreThanOne = false;
        Iterator iter = this.licenseInfos.iterator();
        while (iter.hasNext()) {
            if (moreThanOne) {
                sb.append(" AND ");
            }
            moreThanOne = true;
            sb.append(((SPDXLicenseInfo)iter.next()).toString());
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int retval = 41;
        for (SPDXLicenseInfo li : this.licenseInfos) {
            retval ^= li.hashCode();
        }
        return retval;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SPDXConjunctiveLicenseSet)) {
            return false;
        }
        SPDXConjunctiveLicenseSet comp = (SPDXConjunctiveLicenseSet)o;
        SPDXLicenseInfo[] compInfos = comp.getSPDXLicenseInfos();
        if (compInfos.length != this.licenseInfos.size()) {
            return false;
        }
        for (SPDXLicenseInfo li : this.licenseInfos) {
            boolean found = false;
            for (int i = 0; i < compInfos.length; ++i) {
                if (!li.equals(compInfos[i])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

