/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXChecksum;
import org.spdx.rdfparser.SPDXCreatorInformation;
import org.spdx.rdfparser.SPDXFile;
import org.spdx.rdfparser.SPDXLicenseInfo;
import org.spdx.rdfparser.SPDXLicenseInfoFactory;
import org.spdx.rdfparser.SPDXNonStandardLicense;
import org.spdx.rdfparser.SPDXPackageInfo;
import org.spdx.rdfparser.SPDXReview;
import org.spdx.rdfparser.SPDXStandardLicense;
import org.spdx.rdfparser.SpdxPackageVerificationCode;
import org.spdx.rdfparser.SpdxRdfConstants;
import org.spdx.rdfparser.SpdxVerificationHelper;
import org.spdx.spdxspreadsheet.InvalidLicenseStringException;

public class SPDXDocument
implements SpdxRdfConstants {
    public static final String POINT_EIGHT_SPDX_VERSION = "SPDX-0.8";
    public static final String POINT_NINE_SPDX_VERSION = "SPDX-0.9";
    public static final String ONE_DOT_ZERO_SPDX_VERSION = "SPDX-1.0";
    public static final String ONE_DOT_ONE_SPDX_VERSION = "SPDX-1.1";
    public static final String CURRENT_SPDX_VERSION = "SPDX-1.2";
    public static final String CURRENT_IMPLEMENTATION_VERSION = "1.2.5";
    static HashSet<String> SUPPORTED_SPDX_VERSIONS = new HashSet();
    protected int nextLicenseRef = 1;
    Model model;
    SPDXPackage spdxPackage = null;

    public SPDXDocument(Model model) throws InvalidSPDXAnalysisException {
        this.model = model;
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode != null) {
            this.verify();
            this.initializeNextLicenseRef();
        }
    }

    private void initializeNextLicenseRef() throws InvalidSPDXAnalysisException {
        this.initializeNextLicenseRef(this.getExtractedLicenseInfos());
    }

    private void initializeNextLicenseRef(SPDXNonStandardLicense[] existingLicenses) throws InvalidSPDXAnalysisException {
        int highestNonStdLicense = 0;
        for (int i = 0; i < existingLicenses.length; ++i) {
            int idNum = this.getLicenseRefNum(existingLicenses[i].getId());
            if (idNum <= highestNonStdLicense) continue;
            highestNonStdLicense = idNum;
        }
        this.nextLicenseRef = highestNonStdLicense + 1;
    }

    public int getLicenseRefNum(String licenseID) throws InvalidSPDXAnalysisException {
        Matcher matcher = LICENSE_ID_PATTERN.matcher(licenseID);
        if (!matcher.matches()) {
            throw new InvalidSPDXAnalysisException("Invalid license ID found in the non-standard licenses: '" + licenseID + "'");
        }
        int numGroups = matcher.groupCount();
        if (numGroups != 1) {
            throw new InvalidSPDXAnalysisException("Invalid license ID found in the non-standard licenses: '" + licenseID + "'");
        }
        int idNum = Integer.decode(matcher.group(1));
        return idNum;
    }

    public static String formNonStandardLicenseID(int idNum) {
        return "LicenseRef-" + String.valueOf(idNum);
    }

    synchronized int getAndIncrementNextLicenseRef() {
        int retval = this.nextLicenseRef++;
        return retval;
    }

    public String verifySpdxVersion(String spdxVersion) {
        if (!spdxVersion.startsWith("SPDX-")) {
            return "Invalid spdx version - must start with 'SPDX-'";
        }
        Matcher docSpecVersionMatcher = SpdxRdfConstants.SPDX_VERSION_PATTERN.matcher(spdxVersion);
        if (!docSpecVersionMatcher.matches()) {
            return "Invalid spdx version format - must match 'SPDX-M.N'";
        }
        return null;
    }

    public ArrayList<String> verify() {
        ArrayList<String> retval = new ArrayList<String>();
        String docSpecVersion = "";
        try {
            docSpecVersion = this.getSpdxVersion();
            if (docSpecVersion == null || docSpecVersion.isEmpty()) {
                retval.add("Missing required SPDX version");
            } else {
                String verify = this.verifySpdxVersion(docSpecVersion);
                if (verify != null) {
                    retval.add(verify);
                } else if (!SUPPORTED_SPDX_VERSIONS.contains(docSpecVersion)) {
                    retval.add("Version " + docSpecVersion + " is not supported by this version of the rdf parser");
                }
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid spec version: " + e.getMessage());
        }
        try {
            SPDXCreatorInformation creator = this.getCreatorInfo();
            if (creator == null) {
                retval.add("Missing required Creator");
            } else {
                ArrayList<String> creatorVerification = creator.verify();
                retval.addAll(creatorVerification);
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid creator information: " + e.getMessage());
        }
        try {
            SPDXPackage sPkg = this.getSpdxPackage();
            if (sPkg == null) {
                retval.add("Missing required SPDX Package");
            } else {
                ArrayList<String> packageVerification = sPkg.verify();
                retval.addAll(packageVerification);
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid SPDX Package: " + e.getMessage());
        }
        try {
            SPDXReview[] reviews = this.getReviewers();
            if (reviews != null) {
                for (int i = 0; i < reviews.length; ++i) {
                    ArrayList<String> reviewerVerification = reviews[i].verify();
                    retval.addAll(reviewerVerification);
                }
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid reviewers: " + e.getMessage());
        }
        try {
            SPDXNonStandardLicense[] extractedLicInfos = this.getExtractedLicenseInfos();
            if (extractedLicInfos != null) {
                for (int i = 0; i < extractedLicInfos.length; ++i) {
                    ArrayList<String> extractedLicInfoVerification = extractedLicInfos[i].verify();
                    retval.addAll(extractedLicInfoVerification);
                }
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid extracted licensing info: " + e.getMessage());
        }
        if (!docSpecVersion.equals(POINT_EIGHT_SPDX_VERSION) && !docSpecVersion.equals(POINT_NINE_SPDX_VERSION)) {
            try {
                SPDXStandardLicense dataLicense = this.getDataLicense();
                if (dataLicense == null) {
                    retval.add("Missing required data license");
                }
                if (docSpecVersion.equals(ONE_DOT_ZERO_SPDX_VERSION)) {
                    if (!dataLicense.getId().equals("PDDL-1.0")) {
                        retval.add("Incorrect data license for SPDX version 1.0 document - found " + dataLicense.getId() + ", expected " + "PDDL-1.0");
                    }
                } else if (!dataLicense.getId().equals("CC0-1.0")) {
                    retval.add("Incorrect data license for SPDX document - found " + dataLicense.getId() + ", expected " + "CC0-1.0");
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add("Invalid data license: " + e.getMessage());
            }
        }
        try {
            String[] comments = this.findDocPropertieStringValues(this.getSpdxDocNode(), "http://www.w3.org/2000/01/rdf-schema#", "comment");
            if (comments.length > 1) {
                retval.add("More than one document comment exists for the SPDX Package");
            }
        }
        catch (Exception e) {
            retval.add("Invalid document comment: " + e.getMessage());
        }
        return retval;
    }

    private String[] findDocPropertieStringValues(Node subject, String propertyName) {
        return this.findDocPropertieStringValues(subject, "http://spdx.org/rdf/terms#", propertyName);
    }

    private String[] findDocPropertieStringValues(Node subject, String nameSpace, String propertyName) {
        if (subject == null || propertyName == null) {
            return null;
        }
        ArrayList<String> alResult = new ArrayList<String>();
        Node p = this.model.getProperty(nameSpace, propertyName).asNode();
        Triple m = Triple.createMatch((Node)subject, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            if (t.getObject().isURI()) {
                if (t.getObject().getURI().equals("http://spdx.org/rdf/terms#none")) {
                    alResult.add("NONE");
                    continue;
                }
                if (t.getObject().getURI().equals("http://spdx.org/rdf/terms#noassertion")) {
                    alResult.add("NOASSERTION");
                    continue;
                }
                alResult.add(t.getObject().toString(false));
                continue;
            }
            alResult.add(t.getObject().toString(false));
        }
        String[] retval = new String[alResult.size()];
        return alResult.toArray(retval);
    }

    private void removeProperties(Node subject, String propertyName) throws InvalidSPDXAnalysisException {
        this.removeProperties(subject, "http://spdx.org/rdf/terms#", propertyName);
    }

    private void removeProperties(Node subject, String nameSpace, String propertyName) throws InvalidSPDXAnalysisException {
        Property p = this.model.getProperty(nameSpace, propertyName);
        Resource s = this.getResource(subject);
        this.model.removeAll(s, p, null);
    }

    private Resource getResource(Node node) throws InvalidSPDXAnalysisException {
        Resource s;
        if (node.isURI()) {
            s = this.model.createResource(node.getURI());
        } else if (node.isBlank()) {
            s = this.model.createResource(node.getBlankNodeId());
        } else {
            throw new InvalidSPDXAnalysisException("Node can not be a literal");
        }
        return s;
    }

    private void addProperty(Node subject, String propertyName, String[] propertyValue) throws InvalidSPDXAnalysisException {
        this.addProperty(subject, "http://spdx.org/rdf/terms#", propertyName, propertyValue);
    }

    private void addProperty(Node subject, String nameSpace, String propertyName, String[] propertyValue) throws InvalidSPDXAnalysisException {
        Resource s = this.getResource(subject);
        for (int i = 0; i < propertyValue.length; ++i) {
            Resource r;
            Property p = this.model.createProperty(nameSpace, propertyName);
            if (propertyValue[i].equals("NONE")) {
                r = this.model.createResource("http://spdx.org/rdf/terms#none");
                s.addProperty(p, (RDFNode)r);
                continue;
            }
            if (propertyValue[i].equals("NOASSERTION")) {
                r = this.model.createResource("http://spdx.org/rdf/terms#noassertion");
                s.addProperty(p, (RDFNode)r);
                continue;
            }
            s.addProperty(p, propertyValue[i]);
        }
    }

    public String getSpdxVersion() throws InvalidSPDXAnalysisException {
        String[] versions = this.findDocPropertieStringValues(this.getSpdxDocNode(), "specVersion");
        if (versions == null || versions.length == 0) {
            return null;
        }
        if (versions.length > 1) {
            throw new InvalidSPDXAnalysisException("More than one version exists for the SPDX Document");
        }
        return versions[0];
    }

    public void setDocumentComment(String comment) throws InvalidSPDXAnalysisException {
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode == null) {
            throw new InvalidSPDXAnalysisException("Must create the SPDX document before setting spdxVersion");
        }
        this.removeProperties(spdxDocNode, "http://www.w3.org/2000/01/rdf-schema#", "comment");
        if (comment != null && !comment.isEmpty()) {
            this.addProperty(spdxDocNode, "http://www.w3.org/2000/01/rdf-schema#", "comment", new String[]{comment});
        }
    }

    public String getDocumentComment() throws InvalidSPDXAnalysisException {
        String[] comments = this.findDocPropertieStringValues(this.getSpdxDocNode(), "http://www.w3.org/2000/01/rdf-schema#", "comment");
        if (comments == null || comments.length == 0) {
            return null;
        }
        if (comments.length > 1) {
            throw new InvalidSPDXAnalysisException("More than one document comment exists for the SPDX Document");
        }
        return comments[0];
    }

    public void setSpdxVersion(String spdxVersion) throws InvalidSPDXAnalysisException {
        String versionVerify = this.verifySpdxVersion(spdxVersion);
        if (versionVerify != null && !versionVerify.isEmpty()) {
            throw new InvalidSPDXAnalysisException(versionVerify);
        }
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode == null) {
            throw new InvalidSPDXAnalysisException("Must create the SPDX document before setting spdxVersion");
        }
        this.removeProperties(spdxDocNode, "specVersion");
        this.addProperty(spdxDocNode, "specVersion", new String[]{spdxVersion});
    }

    public SPDXStandardLicense getDataLicense() throws InvalidSPDXAnalysisException {
        ArrayList<SPDXLicenseInfo> alLic = new ArrayList<SPDXLicenseInfo>();
        Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "dataLicense").asNode();
        Triple m = Triple.createMatch((Node)this.getSpdxDocNode(), (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            alLic.add(SPDXLicenseInfoFactory.getLicenseInfoFromModel(this.model, t.getObject()));
        }
        if (alLic.size() > 1) {
            throw new InvalidSPDXAnalysisException("Too many data licenses");
        }
        if (alLic.size() == 0) {
            return null;
        }
        if (!(alLic.get(0) instanceof SPDXStandardLicense)) {
            throw new InvalidSPDXAnalysisException("Incorrect license for datalicense - must be a standard SPDX license type");
        }
        return (SPDXStandardLicense)alLic.get(0);
    }

    public void setDataLicense(SPDXStandardLicense dataLicense) throws InvalidSPDXAnalysisException {
        String spdxVersion = this.getSpdxVersion();
        if (spdxVersion == null) {
            throw new InvalidSPDXAnalysisException("Can not set a data license - document does not contain a version.  Set the SPDX version property before setting the data license.");
        }
        if (spdxVersion.equals(ONE_DOT_ZERO_SPDX_VERSION)) {
            if (!dataLicense.getId().equals("PDDL-1.0")) {
                throw new InvalidSPDXAnalysisException("Invalid data license for version 1 SPDX document - license must have ID PDDL-1.0");
            }
        } else if (!dataLicense.getId().equals("CC0-1.0")) {
            throw new InvalidSPDXAnalysisException("Invalid data license for SPDX document - license must have ID CC0-1.0");
        }
        this.removeProperties(this.getSpdxDocNode(), "dataLicense");
        Resource s = this.getResource(this.getSpdxDocNode());
        Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "dataLicense");
        Resource lic = dataLicense.createResource(this.model);
        s.addProperty(p, (RDFNode)lic);
    }

    public SPDXFile[] getFileReferences() throws InvalidSPDXAnalysisException {
        ArrayList<SPDXFile> alFiles = new ArrayList<SPDXFile>();
        Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "referencesFile").asNode();
        Triple m = Triple.createMatch((Node)this.getSpdxDocNode(), (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            alFiles.add(new SPDXFile(this.model, t.getObject()));
        }
        SPDXFile[] retval = new SPDXFile[alFiles.size()];
        return alFiles.toArray(retval);
    }

    @Deprecated
    public String[] getCreators() throws InvalidSPDXAnalysisException {
        SPDXCreatorInformation creator = this.getCreatorInfo();
        if (creator != null && creator.getCreators() != null) {
            return creator.getCreators();
        }
        return null;
    }

    public SPDXCreatorInformation getCreatorInfo() throws InvalidSPDXAnalysisException {
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode == null) {
            throw new InvalidSPDXAnalysisException("No SPDX Document was found.  Can not access the creator information");
        }
        ArrayList<SPDXCreatorInformation> als = new ArrayList<SPDXCreatorInformation>();
        Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "creationInfo").asNode();
        Triple m = Triple.createMatch((Node)spdxDocNode, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            als.add(new SPDXCreatorInformation(this.model, t.getObject()));
        }
        if (als.size() > 1) {
            throw new InvalidSPDXAnalysisException("Too many creation information for document.  Only one is allowed.");
        }
        if (als.size() > 0) {
            return (SPDXCreatorInformation)als.get(0);
        }
        return null;
    }

    public void setCreationInfo(SPDXCreatorInformation creator) throws InvalidSPDXAnalysisException {
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode == null) {
            throw new InvalidSPDXAnalysisException("Must have an SPDX document to set creationInfo");
        }
        Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "creationInfo");
        Resource s = this.getResource(spdxDocNode);
        this.model.removeAll(s, p, null);
        p = this.model.createProperty("http://spdx.org/rdf/terms#", "creationInfo");
        s.addProperty(p, (RDFNode)creator.createResource(this.model));
    }

    @Deprecated
    public String getCreatorComment() throws InvalidSPDXAnalysisException {
        SPDXCreatorInformation creator = this.getCreatorInfo();
        if (creator != null) {
            return creator.getComment();
        }
        return null;
    }

    public SPDXReview[] getReviewers() throws InvalidSPDXAnalysisException {
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode == null) {
            throw new InvalidSPDXAnalysisException("Must have an SPDX document to get reviewers");
        }
        ArrayList<SPDXReview> als = new ArrayList<SPDXReview>();
        als.clear();
        Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "reviewed").asNode();
        Triple m = Triple.createMatch((Node)spdxDocNode, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            als.add(new SPDXReview(this.model, t.getObject()));
        }
        SPDXReview[] reviewers = new SPDXReview[als.size()];
        reviewers = als.toArray(reviewers);
        return reviewers;
    }

    public void setReviewers(SPDXReview[] reviewers) throws InvalidSPDXAnalysisException {
        Node spdxDocNode;
        if (reviewers.length > 0) {
            ArrayList<String> errors = new ArrayList<String>();
            for (int i = 0; i < reviewers.length; ++i) {
                errors.addAll(reviewers[i].verify());
            }
            if (errors.size() > 0) {
                StringBuilder sb = new StringBuilder("Invalid reviewers due to the following errors in validation:\n");
                for (int i = 0; i < errors.size(); ++i) {
                    sb.append((String)errors.get(i));
                    sb.append('\n');
                }
                throw new InvalidSPDXAnalysisException(sb.toString());
            }
        }
        if ((spdxDocNode = this.getSpdxDocNode()) == null) {
            throw new InvalidSPDXAnalysisException("Must have an SPDX document to set reviewers");
        }
        Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "reviewed");
        Resource s = this.getResource(spdxDocNode);
        this.model.removeAll(s, p, null);
        for (int i = 0; i < reviewers.length; ++i) {
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "reviewed");
            s.addProperty(p, (RDFNode)reviewers[i].createResource(this.model));
        }
    }

    @Deprecated
    public String getCreated() throws InvalidSPDXAnalysisException {
        SPDXCreatorInformation creator = this.getCreatorInfo();
        if (creator != null) {
            return creator.getCreated();
        }
        return null;
    }

    public SPDXPackage getSpdxPackage() throws InvalidSPDXAnalysisException {
        if (this.spdxPackage != null) {
            return this.spdxPackage;
        }
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode == null) {
            throw new InvalidSPDXAnalysisException("Must set an SPDX doc before getting an SPDX package");
        }
        Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "describesPackage").asNode();
        Triple m = Triple.createMatch((Node)spdxDocNode, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
        SPDXPackage newSpdxPackage = null;
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            newSpdxPackage = new SPDXPackage(t.getObject());
        }
        this.spdxPackage = newSpdxPackage;
        return newSpdxPackage;
    }

    public void createSpdxPackage(String uri) throws InvalidSPDXAnalysisException {
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode == null) {
            throw new InvalidSPDXAnalysisException("Must create the SPDX document before creating an SPDX Package");
        }
        Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "describesPackage");
        Resource s = this.getResource(this.getSpdxDocNode());
        this.model.removeAll(s, p, null);
        p = this.model.createProperty("http://spdx.org/rdf/terms#", "describesPackage");
        Resource pkgType = this.model.createResource("http://spdx.org/rdf/terms#Package");
        Resource spdxPkg = this.model.createResource(uri, pkgType);
        s.addProperty(p, (RDFNode)spdxPkg);
        this.spdxPackage = new SPDXPackage(spdxPkg.asNode());
    }

    public void createSpdxPackage() throws InvalidSPDXAnalysisException {
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode == null) {
            throw new InvalidSPDXAnalysisException("Must create the SPDX document before creating an SPDX Package");
        }
        this.createSpdxPackage(spdxDocNode.getURI() + "?package");
    }

    public SPDXNonStandardLicense[] getExtractedLicenseInfos() throws InvalidSPDXAnalysisException {
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode == null) {
            throw new InvalidSPDXAnalysisException("No SPDX Document - can not get the Non Standard Licenses");
        }
        ArrayList<SPDXNonStandardLicense> alLic = new ArrayList<SPDXNonStandardLicense>();
        Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "hasExtractedLicensingInfo").asNode();
        Triple m = Triple.createMatch((Node)spdxDocNode, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            alLic.add(new SPDXNonStandardLicense(this.model, t.getObject()));
        }
        SPDXNonStandardLicense[] nonStandardLicenses = new SPDXNonStandardLicense[alLic.size()];
        nonStandardLicenses = alLic.toArray(nonStandardLicenses);
        return nonStandardLicenses;
    }

    public void setExtractedLicenseInfos(SPDXNonStandardLicense[] nonStandardLicenses) throws InvalidSPDXAnalysisException {
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < nonStandardLicenses.length; ++i) {
            errors.addAll(nonStandardLicenses[i].verify());
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder("Invalid extracted license information due to the following verification failures:\n");
            for (int i = 0; i < errors.size(); ++i) {
                sb.append((String)errors.get(i));
                sb.append('\n');
            }
            throw new InvalidSPDXAnalysisException(sb.toString());
        }
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode == null) {
            throw new InvalidSPDXAnalysisException("Must create the SPDX document before setting Non-Standard Licenses");
        }
        this.initializeNextLicenseRef(nonStandardLicenses);
        Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "hasExtractedLicensingInfo");
        Resource s = this.getResource(this.getSpdxDocNode());
        this.model.removeAll(s, p, null);
        for (int i = 0; i < nonStandardLicenses.length; ++i) {
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "hasExtractedLicensingInfo");
            s.addProperty(p, (RDFNode)nonStandardLicenses[i].createResource(this.model));
        }
    }

    public SPDXNonStandardLicense addNewExtractedLicenseInfo(String licenseText) throws InvalidSPDXAnalysisException {
        String licenseID = this.getNextLicenseRef();
        SPDXNonStandardLicense retval = new SPDXNonStandardLicense(licenseID, licenseText);
        this.addNewExtractedLicenseInfo(retval);
        return retval;
    }

    public void addNewExtractedLicenseInfo(SPDXNonStandardLicense license) throws InvalidSPDXAnalysisException {
        if (this.extractedLicenseExists(license.getId())) {
            throw new InvalidSPDXAnalysisException("Can not add license - ID " + license.getId() + " already exists.");
        }
        Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "hasExtractedLicensingInfo");
        Resource s = this.getResource(this.getSpdxDocNode());
        s.addProperty(p, (RDFNode)license.createResource(this.model));
    }

    protected boolean extractedLicenseExists(String id) throws InvalidSPDXAnalysisException {
        Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseId").asNode();
        Node o = Node.createLiteral((String)id);
        Triple m = Triple.createMatch(null, (Node)p, (Node)o);
        ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
        return tripleIter.hasNext();
    }

    public synchronized String getNextLicenseRef() {
        int nextLicNum = this.getAndIncrementNextLicenseRef();
        return SPDXDocument.formNonStandardLicenseID(nextLicNum);
    }

    public String getSpdxDocUri() {
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode == null) {
            return null;
        }
        return spdxDocNode.toString(false);
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public void createSpdxAnalysis(String uri) throws InvalidSPDXAnalysisException {
        this.createSpdxAnalysis(uri, CURRENT_SPDX_VERSION);
    }

    public void createSpdxAnalysis(String uri, String spdxVersion) throws InvalidSPDXAnalysisException {
        String v = this.verifySpdxVersion(spdxVersion);
        if (v != null) {
            throw new InvalidSPDXAnalysisException("Invalid SPDX Version: " + v);
        }
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode != null) {
            this.model.removeAll();
        }
        this.model.setNsPrefix("spdx", "http://spdx.org/rdf/terms#");
        this.model.setNsPrefix("doap", "http://usefulinc.com/ns/doap#");
        this.model.setNsPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.model.setNsPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        Resource spdxAnalysisType = this.model.createResource("http://spdx.org/rdf/terms#SpdxDocument");
        this.model.createResource(uri, spdxAnalysisType);
        this.setSpdxVersion(spdxVersion);
        if (!spdxVersion.equals(POINT_EIGHT_SPDX_VERSION) && !spdxVersion.equals(POINT_NINE_SPDX_VERSION)) {
            try {
                SPDXStandardLicense dataLicense = spdxVersion.equals(ONE_DOT_ZERO_SPDX_VERSION) ? (SPDXStandardLicense)SPDXLicenseInfoFactory.parseSPDXLicenseString("PDDL-1.0") : (SPDXStandardLicense)SPDXLicenseInfoFactory.parseSPDXLicenseString("CC0-1.0");
                this.setDataLicense(dataLicense);
            }
            catch (InvalidLicenseStringException e) {
                throw new InvalidSPDXAnalysisException("Unable to create data license", e);
            }
        }
    }

    private Node getSpdxDocNode() {
        Node spdxDocNode = null;
        Node rdfTypePredicate = this.model.getProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type").asNode();
        Node spdxDocObject = this.model.getProperty("http://spdx.org/rdf/terms#", "SpdxDocument").asNode();
        Triple m = Triple.createMatch(null, (Node)rdfTypePredicate, (Node)spdxDocObject);
        ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            Triple docTriple = (Triple)tripleIter.next();
            spdxDocNode = docTriple.getSubject();
        }
        return spdxDocNode;
    }

    static {
        SUPPORTED_SPDX_VERSIONS.add(CURRENT_SPDX_VERSION);
        SUPPORTED_SPDX_VERSIONS.add(POINT_EIGHT_SPDX_VERSION);
        SUPPORTED_SPDX_VERSIONS.add(POINT_NINE_SPDX_VERSION);
        SUPPORTED_SPDX_VERSIONS.add(ONE_DOT_ZERO_SPDX_VERSION);
        SUPPORTED_SPDX_VERSIONS.add(ONE_DOT_ONE_SPDX_VERSION);
    }

    public class SPDXPackage {
        private Node node = null;

        public SPDXPackage(Node pkgNode) {
            this.node = pkgNode;
        }

        public String getDeclaredName() throws InvalidSPDXAnalysisException {
            String[] declaredNames = SPDXDocument.this.findDocPropertieStringValues(this.node, "name");
            if (declaredNames == null || declaredNames.length == 0) {
                return null;
            }
            if (declaredNames.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one declared name for a package");
            }
            return declaredNames[0];
        }

        public void setDeclaredName(String declaredName) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "name");
            SPDXDocument.this.addProperty(this.node, "name", new String[]{declaredName});
        }

        public String getFileName() throws InvalidSPDXAnalysisException {
            String[] fileNames = SPDXDocument.this.findDocPropertieStringValues(this.node, "packageFileName");
            if (fileNames == null || fileNames.length == 0) {
                return null;
            }
            if (fileNames.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one machine name for a package");
            }
            return fileNames[0];
        }

        public void setFileName(String fileName) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "packageFileName");
            SPDXDocument.this.addProperty(this.node, "packageFileName", new String[]{fileName});
        }

        public String getSha1() throws InvalidSPDXAnalysisException {
            String retval = null;
            Node p = SPDXDocument.this.model.getProperty("http://spdx.org/rdf/terms#", "checksum").asNode();
            Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
            ExtendedIterator tripleIter = SPDXDocument.this.model.getGraph().find((TripleMatch)m);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                SPDXChecksum cksum = new SPDXChecksum(SPDXDocument.this.model, t.getObject());
                if (!cksum.getAlgorithm().equals("SHA1")) continue;
                retval = cksum.getValue();
            }
            return retval;
        }

        public void setSha1(String sha1) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "checksum");
            SPDXChecksum cksum = new SPDXChecksum("SHA1", sha1);
            Resource cksumResource = cksum.createResource(SPDXDocument.this.model);
            Resource s = SPDXDocument.this.getResource(this.node);
            Property p = SPDXDocument.this.model.createProperty("http://spdx.org/rdf/terms#", "checksum");
            s.addProperty(p, (RDFNode)cksumResource);
        }

        public String getSourceInfo() throws InvalidSPDXAnalysisException {
            String[] sourceInfos = SPDXDocument.this.findDocPropertieStringValues(this.node, "sourceInfo");
            if (sourceInfos == null || sourceInfos.length == 0) {
                return null;
            }
            if (sourceInfos.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one source info for an SPDX package");
            }
            return sourceInfos[0];
        }

        public void setSourceInfo(String sourceInfo) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "sourceInfo");
            SPDXDocument.this.addProperty(this.node, "sourceInfo", new String[]{sourceInfo});
        }

        public String getVersionInfo() throws InvalidSPDXAnalysisException {
            String[] versionInfos = SPDXDocument.this.findDocPropertieStringValues(this.node, "versionInfo");
            if (versionInfos == null || versionInfos.length == 0) {
                return null;
            }
            if (versionInfos.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one version info for an SPDX package");
            }
            return versionInfos[0];
        }

        public void setVersionInfo(String versionInfo) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "versionInfo");
            SPDXDocument.this.addProperty(this.node, "versionInfo", new String[]{versionInfo});
        }

        public SPDXLicenseInfo getDeclaredLicense() throws InvalidSPDXAnalysisException {
            ArrayList<SPDXLicenseInfo> alLic = new ArrayList<SPDXLicenseInfo>();
            Node p = SPDXDocument.this.model.getProperty("http://spdx.org/rdf/terms#", "licenseDeclared").asNode();
            Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
            ExtendedIterator tripleIter = SPDXDocument.this.model.getGraph().find((TripleMatch)m);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                alLic.add(SPDXLicenseInfoFactory.getLicenseInfoFromModel(SPDXDocument.this.model, t.getObject()));
            }
            if (alLic.size() > 1) {
                throw new InvalidSPDXAnalysisException("Too many declared licenses");
            }
            if (alLic.size() == 0) {
                return null;
            }
            return (SPDXLicenseInfo)alLic.get(0);
        }

        public void setDeclaredLicense(SPDXLicenseInfo declaredLicense) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "licenseDeclared");
            Resource s = SPDXDocument.this.getResource(this.node);
            Property p = SPDXDocument.this.model.createProperty("http://spdx.org/rdf/terms#", "licenseDeclared");
            Resource lic = declaredLicense.createResource(SPDXDocument.this.model);
            s.addProperty(p, (RDFNode)lic);
        }

        public SPDXLicenseInfo getConcludedLicenses() throws InvalidSPDXAnalysisException {
            ArrayList<SPDXLicenseInfo> alLic = new ArrayList<SPDXLicenseInfo>();
            Node p = SPDXDocument.this.model.getProperty("http://spdx.org/rdf/terms#", "licenseConcluded").asNode();
            Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
            ExtendedIterator tripleIter = SPDXDocument.this.model.getGraph().find((TripleMatch)m);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                alLic.add(SPDXLicenseInfoFactory.getLicenseInfoFromModel(SPDXDocument.this.model, t.getObject()));
            }
            if (alLic.size() > 1) {
                throw new InvalidSPDXAnalysisException("Too many concluded licenses");
            }
            if (alLic.size() == 0) {
                return null;
            }
            return (SPDXLicenseInfo)alLic.get(0);
        }

        public void setConcludedLicenses(SPDXLicenseInfo detectedLicenses) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "licenseConcluded");
            Resource s = SPDXDocument.this.getResource(this.node);
            Property p = SPDXDocument.this.model.createProperty("http://spdx.org/rdf/terms#", "licenseConcluded");
            Resource lic = detectedLicenses.createResource(SPDXDocument.this.model);
            s.addProperty(p, (RDFNode)lic);
        }

        public String getLicenseComment() throws InvalidSPDXAnalysisException {
            String[] comments = SPDXDocument.this.findDocPropertieStringValues(this.node, "licenseComments");
            if (comments == null || comments.length == 0) {
                return null;
            }
            if (comments.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one license comment for a package");
            }
            return comments[0];
        }

        public void setLicenseComment(String comments) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "licenseComments");
            SPDXDocument.this.addProperty(this.node, "licenseComments", new String[]{comments});
        }

        public String getDeclaredCopyright() throws InvalidSPDXAnalysisException {
            String[] copyrights = SPDXDocument.this.findDocPropertieStringValues(this.node, "copyrightText");
            if (copyrights == null || copyrights.length == 0) {
                return null;
            }
            if (copyrights.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one declared copyright for a package");
            }
            return copyrights[0];
        }

        public void setDeclaredCopyright(String declaredCopyright) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "copyrightText");
            SPDXDocument.this.addProperty(this.node, "copyrightText", new String[]{declaredCopyright});
        }

        public String getShortDescription() throws InvalidSPDXAnalysisException {
            String[] shortDescs = SPDXDocument.this.findDocPropertieStringValues(this.node, "summary");
            if (shortDescs == null || shortDescs.length == 0) {
                return null;
            }
            if (shortDescs.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one short description for a package");
            }
            return shortDescs[0];
        }

        public void setShortDescription(String shortDescription) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "summary");
            SPDXDocument.this.addProperty(this.node, "summary", new String[]{shortDescription});
        }

        public String getDescription() throws InvalidSPDXAnalysisException {
            String[] desc = SPDXDocument.this.findDocPropertieStringValues(this.node, "description");
            if (desc == null || desc.length == 0) {
                return null;
            }
            if (desc.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one description for a package");
            }
            return desc[0];
        }

        public void setDescription(String description) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "description");
            SPDXDocument.this.addProperty(this.node, "description", new String[]{description});
        }

        public void setOriginator(String originator) throws InvalidSPDXAnalysisException {
            String error = SpdxVerificationHelper.verifyOriginator(originator);
            if (error != null && !error.isEmpty()) {
                throw new InvalidSPDXAnalysisException(error);
            }
            SPDXDocument.this.removeProperties(this.node, "originator");
            SPDXDocument.this.addProperty(this.node, "originator", new String[]{originator});
        }

        public void setSupplier(String supplier) throws InvalidSPDXAnalysisException {
            String error = SpdxVerificationHelper.verifySupplier(supplier);
            if (error != null && !error.isEmpty()) {
                throw new InvalidSPDXAnalysisException(error);
            }
            SPDXDocument.this.removeProperties(this.node, "supplier");
            SPDXDocument.this.addProperty(this.node, "supplier", new String[]{supplier});
        }

        public String getOriginator() throws InvalidSPDXAnalysisException {
            String[] originators = SPDXDocument.this.findDocPropertieStringValues(this.node, "originator");
            if (originators == null || originators.length == 0) {
                return null;
            }
            if (originators.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one originator for a package");
            }
            return originators[0];
        }

        public String getSupplier() throws InvalidSPDXAnalysisException {
            String[] suppliers = SPDXDocument.this.findDocPropertieStringValues(this.node, "supplier");
            if (suppliers == null || suppliers.length == 0) {
                return null;
            }
            if (suppliers.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one supplier for a package");
            }
            return suppliers[0];
        }

        public SPDXFile[] getFiles() throws InvalidSPDXAnalysisException {
            ArrayList<SPDXFile> alFiles = new ArrayList<SPDXFile>();
            Node p = SPDXDocument.this.model.getProperty("http://spdx.org/rdf/terms#", "hasFile").asNode();
            Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
            ExtendedIterator tripleIter = SPDXDocument.this.model.getGraph().find((TripleMatch)m);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                alFiles.add(new SPDXFile(SPDXDocument.this.model, t.getObject()));
            }
            SPDXFile[] retval = new SPDXFile[alFiles.size()];
            return alFiles.toArray(retval);
        }

        public void setFiles(SPDXFile[] files) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "hasFile");
            SPDXDocument.this.removeProperties(this.node, "referencesFile");
            Resource s = SPDXDocument.this.getResource(this.node);
            Property p = SPDXDocument.this.model.createProperty("http://spdx.org/rdf/terms#", "hasFile");
            Resource docResource = SPDXDocument.this.getResource(SPDXDocument.this.getSpdxDocNode());
            Property docP = SPDXDocument.this.model.createProperty("http://spdx.org/rdf/terms#", "referencesFile");
            for (int i = 0; i < files.length; ++i) {
                Resource file = files[i].createResource(SPDXDocument.this.model);
                s.addProperty(p, (RDFNode)file);
                docResource.addProperty(docP, (RDFNode)file);
            }
        }

        public void addFile(SPDXFile file) throws InvalidSPDXAnalysisException {
            Resource s = SPDXDocument.this.getResource(this.node);
            Property p = SPDXDocument.this.model.createProperty("http://spdx.org/rdf/terms#", "hasFile");
            Resource docResource = SPDXDocument.this.getResource(SPDXDocument.this.getSpdxDocNode());
            Property docP = SPDXDocument.this.model.createProperty("http://spdx.org/rdf/terms#", "referencesFile");
            Resource fileResource = file.createResource(SPDXDocument.this.model);
            s.addProperty(p, (RDFNode)fileResource);
            docResource.addProperty(docP, (RDFNode)fileResource);
        }

        public void removeFile(String fileName) throws InvalidSPDXAnalysisException {
            ArrayList<Node> filesToRemove = new ArrayList<Node>();
            Node fileNameProperty = SPDXDocument.this.model.getProperty("http://spdx.org/rdf/terms#", "fileName").asNode();
            Property docFileProperty = SPDXDocument.this.model.getProperty("http://spdx.org/rdf/terms#", "referencesFile");
            Property pkgFileProperty = SPDXDocument.this.model.createProperty("http://spdx.org/rdf/terms#", "hasFile");
            Resource docResource = SPDXDocument.this.getResource(SPDXDocument.this.getSpdxDocNode());
            Resource pkgResource = SPDXDocument.this.getResource(this.node);
            Triple m = Triple.createMatch((Node)SPDXDocument.this.getSpdxDocNode(), (Node)docFileProperty.asNode(), null);
            ExtendedIterator tripleIter = SPDXDocument.this.model.getGraph().find((TripleMatch)m);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                Node fileObject = t.getObject();
                Triple fileNameMatch = Triple.createMatch((Node)fileObject, (Node)fileNameProperty, null);
                ExtendedIterator fileNameIterator = SPDXDocument.this.model.getGraph().find((TripleMatch)fileNameMatch);
                while (fileNameIterator.hasNext()) {
                    Triple fileNameTriple = (Triple)fileNameIterator.next();
                    String searchFileName = fileNameTriple.getObject().toString(false);
                    if (!searchFileName.equals(fileName)) continue;
                    filesToRemove.add(fileObject);
                }
            }
            for (int i = 0; i < filesToRemove.size(); ++i) {
                RDFNode o = SPDXDocument.this.model.getRDFNode((Node)filesToRemove.get(i));
                SPDXDocument.this.model.removeAll(docResource, docFileProperty, o);
                SPDXDocument.this.model.removeAll(pkgResource, pkgFileProperty, o);
            }
        }

        public String getDownloadUrl() throws InvalidSPDXAnalysisException {
            String[] urls = SPDXDocument.this.findDocPropertieStringValues(this.node, "downloadLocation");
            if (urls == null || urls.length == 0) {
                return null;
            }
            if (urls.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one URL for a package");
            }
            return urls[0];
        }

        public void setDownloadUrl(String url) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "downloadLocation");
            SPDXDocument.this.addProperty(this.node, "downloadLocation", new String[]{url});
        }

        public String getHomePage() throws InvalidSPDXAnalysisException {
            String[] urls = SPDXDocument.this.findDocPropertieStringValues(this.node, "http://usefulinc.com/ns/doap#", "homepage");
            if (urls == null || urls.length == 0) {
                return null;
            }
            if (urls.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one home page for a package");
            }
            return urls[0];
        }

        public void setHomePage(String url) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "http://usefulinc.com/ns/doap#", "homepage");
            SPDXDocument.this.addProperty(this.node, "http://usefulinc.com/ns/doap#", "homepage", new String[]{url});
        }

        public SpdxPackageVerificationCode getVerificationCode() throws InvalidSPDXAnalysisException {
            SpdxPackageVerificationCode retval = null;
            Node p = SPDXDocument.this.model.getProperty("http://spdx.org/rdf/terms#", "packageVerificationCode").asNode();
            Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
            ExtendedIterator tripleIter = SPDXDocument.this.model.getGraph().find((TripleMatch)m);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                retval = new SpdxPackageVerificationCode(SPDXDocument.this.model, t.getObject());
            }
            return retval;
        }

        public void setVerificationCode(SpdxPackageVerificationCode verificationCode) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "packageVerificationCode");
            Resource verificationCodeResource = verificationCode.createResource(SPDXDocument.this.model);
            Resource s = SPDXDocument.this.getResource(this.node);
            Property p = SPDXDocument.this.model.createProperty("http://spdx.org/rdf/terms#", "packageVerificationCode");
            s.addProperty(p, (RDFNode)verificationCodeResource);
        }

        public SPDXPackageInfo getPackageInfo() throws InvalidSPDXAnalysisException {
            return new SPDXPackageInfo(this.getDeclaredName(), this.getVersionInfo(), this.getFileName(), this.getSha1(), this.getSourceInfo(), this.getDeclaredLicense(), this.getConcludedLicenses(), this.getLicenseInfoFromFiles(), this.getLicenseComment(), this.getDeclaredCopyright(), this.getShortDescription(), this.getDescription(), this.getDownloadUrl(), this.getVerificationCode(), this.getSupplier(), this.getOriginator(), this.getHomePage());
        }

        public void setLicenseInfoFromFiles(SPDXLicenseInfo[] licenseInfo) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "licenseInfoFromFiles");
            Resource s = SPDXDocument.this.getResource(this.node);
            Property p = SPDXDocument.this.model.createProperty("http://spdx.org/rdf/terms#", "licenseInfoFromFiles");
            for (int i = 0; i < licenseInfo.length; ++i) {
                Resource lic = licenseInfo[i].createResource(SPDXDocument.this.model);
                s.addProperty(p, (RDFNode)lic);
            }
        }

        public SPDXLicenseInfo[] getLicenseInfoFromFiles() throws InvalidSPDXAnalysisException {
            ArrayList<SPDXLicenseInfo> alLic = new ArrayList<SPDXLicenseInfo>();
            Node p = SPDXDocument.this.model.getProperty("http://spdx.org/rdf/terms#", "licenseInfoFromFiles").asNode();
            Triple m = Triple.createMatch((Node)this.node, (Node)p, null);
            ExtendedIterator tripleIter = SPDXDocument.this.model.getGraph().find((TripleMatch)m);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                alLic.add(SPDXLicenseInfoFactory.getLicenseInfoFromModel(SPDXDocument.this.model, t.getObject()));
            }
            SPDXLicenseInfo[] retval = new SPDXLicenseInfo[alLic.size()];
            retval = alLic.toArray(retval);
            return retval;
        }

        public ArrayList<String> verify() {
            ArrayList<String> retval = new ArrayList<String>();
            try {
                String name = this.getDeclaredName();
                if (name == null || name.isEmpty()) {
                    retval.add("Missing required name for package");
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add("Invalid name: " + e.getMessage());
            }
            try {
                String summary = this.getShortDescription();
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add("Invalid summary: " + e.getMessage());
            }
            try {
                String description = this.getDescription();
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add("Invalid description: " + e.getMessage());
            }
            try {
                String downloadLocation = this.getDownloadUrl();
                if (downloadLocation == null || downloadLocation.isEmpty()) {
                    retval.add("Missing required download location for package");
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add("Invalid download location: " + e.getMessage());
            }
            try {
                String verify;
                String checksum = this.getSha1();
                if (checksum != null && !checksum.isEmpty() && (verify = SpdxVerificationHelper.verifyChecksumString(checksum)) != null) {
                    retval.add("Package checksum error: " + verify);
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add("Invalid checksum: " + e.getMessage());
            }
            try {
                String sourceInfo = this.getSourceInfo();
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add("Invalid package source info: " + e.getMessage());
            }
            try {
                String copyrightText = this.getDeclaredCopyright();
                if (copyrightText == null || copyrightText.isEmpty()) {
                    retval.add("Missing required package copyright text");
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add("Invalid package copyright: " + e.getMessage());
            }
            try {
                String licenseComments = this.getLicenseComment();
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add("Invalid license comments: " + e.getMessage());
            }
            try {
                SPDXLicenseInfo declaredLicense = this.getDeclaredLicense();
                if (declaredLicense == null) {
                    retval.add("Missing required declared license");
                } else {
                    retval.addAll(declaredLicense.verify());
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add("Invalid package declared license: " + e.getMessage());
            }
            try {
                SPDXLicenseInfo concludedLicense = this.getConcludedLicenses();
                if (concludedLicense == null) {
                    retval.add("Missing required concluded license");
                } else {
                    retval.addAll(concludedLicense.verify());
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add("Invalid package concluded license: " + e.getMessage());
            }
            try {
                SPDXLicenseInfo[] licenseInfosFromFiles = this.getLicenseInfoFromFiles();
                if (licenseInfosFromFiles == null || licenseInfosFromFiles.length == 0) {
                    retval.add("Missing required license information from files");
                } else {
                    for (int i = 0; i < licenseInfosFromFiles.length; ++i) {
                        retval.addAll(licenseInfosFromFiles[i].verify());
                    }
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add("Invalid package license information from files: " + e.getMessage());
            }
            try {
                SPDXFile[] files = this.getFiles();
                if (files == null || files.length == 0) {
                    retval.add("Missing required package files");
                } else {
                    for (int i = 0; i < files.length; ++i) {
                        retval.addAll(files[i].verify());
                    }
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add("Invalid package files: " + e.getMessage());
            }
            SpdxPackageVerificationCode verificationCode = null;
            try {
                verificationCode = this.getVerificationCode();
                if (verificationCode == null) {
                    retval.add("Missing required package verification code.");
                } else {
                    retval.addAll(verificationCode.verify());
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add("Invalid package verification code: " + e.getMessage());
            }
            String supplier = null;
            try {
                String error;
                supplier = this.getSupplier();
                if (supplier != null && (error = SpdxVerificationHelper.verifySupplier(supplier)) != null && !error.isEmpty()) {
                    retval.add("Supplier error - " + error);
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add("Invalid supplier: " + e.getMessage());
            }
            String originator = null;
            try {
                String error;
                originator = this.getOriginator();
                if (originator != null && (error = SpdxVerificationHelper.verifyOriginator(originator)) != null && !error.isEmpty()) {
                    retval.add("Originator error - " + error);
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add("Invalid originator: " + e.getMessage());
            }
            return retval;
        }
    }
}

