/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.FileManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXDocument;

public class SPDXDocumentFactory {
    static final Logger logger = Logger.getLogger((String)SPDXDocumentFactory.class.getName());

    public static SPDXDocument createSpdxDocument(Model model) throws InvalidSPDXAnalysisException {
        return new SPDXDocument(model);
    }

    public static SPDXDocument creatSpdxDocument(String fileNameOrUrl) throws IOException, InvalidSPDXAnalysisException {
        try {
            Class.forName("net.rootdev.javardfa.jena.RDFaReader");
        }
        catch (ClassNotFoundException e) {
            logger.warn((Object)"Unable to load the RDFaReader Class");
        }
        InputStream spdxRdfInput = FileManager.get().open(fileNameOrUrl);
        if (spdxRdfInput == null) {
            throw new FileNotFoundException("Unable to open \"" + fileNameOrUrl + "\" for reading");
        }
        return SPDXDocumentFactory.createSpdxDocument(spdxRdfInput, SPDXDocumentFactory.figureBaseUri(fileNameOrUrl), SPDXDocumentFactory.fileType(fileNameOrUrl));
    }

    public static SPDXDocument createSpdxDocument(InputStream input, String baseUri, String fileType) throws InvalidSPDXAnalysisException {
        Model model = ModelFactory.createDefaultModel();
        model.read(input, baseUri, fileType);
        return new SPDXDocument(model);
    }

    private static String figureBaseUri(String src) {
        URI s = null;
        try {
            s = new URI(src);
        }
        catch (URISyntaxException e) {
            s = null;
        }
        if (s == null || s.getScheme() == null) {
            String filePath = "///" + new File(src).getAbsoluteFile().toString().replace('\\', '/');
            try {
                s = new URI("file", filePath, null);
            }
            catch (URISyntaxException e1) {
                logger.error((Object)("Invalid URI syntax for " + src));
                return null;
            }
        }
        return s.toString();
    }

    private static String fileType(String path) {
        if (Pattern.matches("(?i:.*\\.x?html?$)", path)) {
            return "HTML";
        }
        return "RDF/XML";
    }
}

