/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.spdx.rdfparser.DOAPProject;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXChecksum;
import org.spdx.rdfparser.SPDXLicenseInfo;
import org.spdx.rdfparser.SPDXLicenseInfoFactory;
import org.spdx.rdfparser.SpdxVerificationHelper;

public class SPDXFile
implements Comparable<SPDXFile> {
    static final Logger logger = Logger.getLogger((String)SPDXFile.class.getName());
    private Model model = null;
    private Resource resource = null;
    private String name;
    private SPDXLicenseInfo concludedLicenses;
    private SPDXChecksum sha1;
    private String type;
    private SPDXLicenseInfo[] seenLicenses;
    private String licenseComments;
    private String copyright;
    private DOAPProject[] artifactOf;
    private String comment = null;
    private SPDXFile[] fileDependencies;
    private String[] contributors;
    private String noticeText;
    public static HashMap<String, String> FILE_TYPE_TO_RESOURCE = new HashMap();
    public static HashMap<String, String> RESOURCE_TO_FILE_TYPE = new HashMap();

    protected static Resource convertToResource(Model cmodel, Node cnode) throws InvalidSPDXAnalysisException {
        if (cnode.isBlank()) {
            return cmodel.createResource(cnode.getBlankNodeId());
        }
        if (cnode.isURI()) {
            return cmodel.createResource(cnode.getURI());
        }
        throw new InvalidSPDXAnalysisException("Can not create a file from a literal");
    }

    public SPDXFile(Model model, Node fileNode) throws InvalidSPDXAnalysisException {
        Triple t;
        Triple t2;
        Triple t3;
        this.model = model;
        this.resource = SPDXFile.convertToResource(model, fileNode);
        Node p = model.getProperty("http://spdx.org/rdf/terms#", "fileName").asNode();
        Triple m = Triple.createMatch((Node)fileNode, (Node)p, null);
        ExtendedIterator tripleIter = model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            t3 = (Triple)tripleIter.next();
            this.name = t3.getObject().toString(false);
        }
        p = model.getProperty("http://spdx.org/rdf/terms#", "checksum").asNode();
        m = Triple.createMatch((Node)fileNode, (Node)p, null);
        tripleIter = model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            t3 = (Triple)tripleIter.next();
            this.sha1 = new SPDXChecksum(model, t3.getObject());
        }
        p = model.getProperty("http://spdx.org/rdf/terms#", "fileType").asNode();
        m = Triple.createMatch((Node)fileNode, (Node)p, null);
        tripleIter = model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            t3 = (Triple)tripleIter.next();
            if (t3.getObject().isLiteral()) {
                this.type = t3.getObject().toString(false);
                continue;
            }
            if (t3.getObject().isURI()) {
                this.type = RESOURCE_TO_FILE_TYPE.get(t3.getObject().getURI());
                if (this.type != null) continue;
                throw new InvalidSPDXAnalysisException("Invalid URI for file type resource - must be one of the individual file types in http://spdx.org/rdf/terms");
            }
            throw new InvalidSPDXAnalysisException("Invalid file type property - must be a URI type specified in http://spdx.org/rdf/terms");
        }
        ArrayList<SPDXLicenseInfo> alLic = new ArrayList<SPDXLicenseInfo>();
        p = model.getProperty("http://spdx.org/rdf/terms#", "licenseConcluded").asNode();
        m = Triple.createMatch((Node)fileNode, (Node)p, null);
        tripleIter = model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            t2 = (Triple)tripleIter.next();
            alLic.add(SPDXLicenseInfoFactory.getLicenseInfoFromModel(model, t2.getObject()));
        }
        if (alLic.size() > 1) {
            throw new InvalidSPDXAnalysisException("Too many concluded licenses for file");
        }
        if (alLic.size() == 0) {
            throw new InvalidSPDXAnalysisException("Missing required concluded license");
        }
        this.concludedLicenses = (SPDXLicenseInfo)alLic.get(0);
        alLic.clear();
        p = model.getProperty("http://spdx.org/rdf/terms#", "licenseInfoInFile").asNode();
        m = Triple.createMatch((Node)fileNode, (Node)p, null);
        tripleIter = model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            t2 = (Triple)tripleIter.next();
            alLic.add(SPDXLicenseInfoFactory.getLicenseInfoFromModel(model, t2.getObject()));
        }
        this.seenLicenses = alLic.toArray(new SPDXLicenseInfo[alLic.size()]);
        p = model.getProperty("http://spdx.org/rdf/terms#", "fileDependency").asNode();
        m = Triple.createMatch((Node)fileNode, (Node)p, null);
        ArrayList<SPDXFile> alDependencies = new ArrayList<SPDXFile>();
        tripleIter = model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            alDependencies.add(new SPDXFile(model, t.getObject()));
        }
        this.fileDependencies = alDependencies.toArray(new SPDXFile[alDependencies.size()]);
        p = model.getProperty("http://spdx.org/rdf/terms#", "licenseComments").asNode();
        m = Triple.createMatch((Node)fileNode, (Node)p, null);
        tripleIter = model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.licenseComments = t.getObject().toString(false);
        }
        p = model.getProperty("http://spdx.org/rdf/terms#", "copyrightText").asNode();
        m = Triple.createMatch((Node)fileNode, (Node)p, null);
        tripleIter = model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            if (t.getObject().isURI()) {
                if (t.getObject().getURI().equals("http://spdx.org/rdf/terms#noassertion")) {
                    this.copyright = "NOASSERTION";
                    continue;
                }
                if (t.getObject().getURI().equals("http://spdx.org/rdf/terms#none")) {
                    this.copyright = "NONE";
                    continue;
                }
                this.copyright = t.getObject().toString(false);
                continue;
            }
            this.copyright = t.getObject().toString(false);
        }
        p = model.getProperty("http://www.w3.org/2000/01/rdf-schema#", "comment").asNode();
        m = Triple.createMatch((Node)fileNode, (Node)p, null);
        tripleIter = model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            this.comment = ((Triple)tripleIter.next()).getObject().toString(false);
        }
        ArrayList<String> alContributors = new ArrayList<String>();
        p = model.getProperty("http://spdx.org/rdf/terms#", "fileContributor").asNode();
        m = Triple.createMatch((Node)fileNode, (Node)p, null);
        tripleIter = model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            Triple t4 = (Triple)tripleIter.next();
            alContributors.add(t4.getObject().toString(false));
        }
        this.contributors = alContributors.toArray(new String[alContributors.size()]);
        ArrayList<DOAPProject> alProjects = new ArrayList<DOAPProject>();
        p = model.getProperty("http://spdx.org/rdf/terms#", "artifactOf").asNode();
        m = Triple.createMatch((Node)fileNode, (Node)p, null);
        tripleIter = model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            Triple t5 = (Triple)tripleIter.next();
            alProjects.add(new DOAPProject(model, t5.getObject()));
        }
        this.artifactOf = alProjects.toArray(new DOAPProject[alProjects.size()]);
        p = model.getProperty("http://spdx.org/rdf/terms#", "noticeText").asNode();
        m = Triple.createMatch((Node)fileNode, (Node)p, null);
        tripleIter = model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            this.noticeText = ((Triple)tripleIter.next()).getObject().toString(false);
        }
    }

    public Resource createResource(Model model) throws InvalidSPDXAnalysisException {
        Resource type = model.createResource("http://spdx.org/rdf/terms#File");
        Resource retval = SPDXFile.findFileResource(model, this);
        if (retval == null) {
            retval = model.createResource(type);
        }
        this.populateModel(model, retval);
        this.resource = retval;
        return retval;
    }

    private void populateModel(Model model, Resource fileResource) throws InvalidSPDXAnalysisException {
        Property p = model.createProperty("http://spdx.org/rdf/terms#", "fileName");
        fileResource.addProperty(p, this.getName());
        p = model.createProperty("http://spdx.org/rdf/terms#", "checksum");
        model.removeAll(fileResource, p, null);
        if (this.sha1 != null) {
            Resource cksumResource = this.sha1.getResource();
            if (cksumResource == null) {
                cksumResource = this.sha1.createResource(model);
            }
            fileResource.addProperty(p, (RDFNode)cksumResource);
        }
        p = model.createProperty("http://spdx.org/rdf/terms#", "fileType");
        model.removeAll(fileResource, p, null);
        Resource fileTypeResource = SPDXFile.fileTypeStringToTypeResource(this.getType(), model);
        fileResource.addProperty(p, (RDFNode)fileTypeResource);
        p = model.createProperty("http://spdx.org/rdf/terms#", "licenseConcluded");
        model.removeAll(fileResource, p, null);
        if (this.concludedLicenses != null) {
            Resource lic = this.concludedLicenses.createResource(model);
            fileResource.addProperty(p, (RDFNode)lic);
        }
        p = model.createProperty("http://spdx.org/rdf/terms#", "licenseInfoInFile");
        model.removeAll(fileResource, p, null);
        if (this.seenLicenses != null && this.seenLicenses.length > 0) {
            for (int i = 0; i < this.seenLicenses.length; ++i) {
                Resource lic = this.seenLicenses[i].createResource(model);
                fileResource.addProperty(p, (RDFNode)lic);
            }
        }
        p = model.createProperty("http://spdx.org/rdf/terms#", "fileDependency");
        model.removeAll(fileResource, p, null);
        if (this.fileDependencies != null && this.fileDependencies.length > 0) {
            for (int i = 0; i < this.fileDependencies.length; ++i) {
                Resource dep = this.fileDependencies[i].getResource();
                if (dep == null && (dep = SPDXFile.findFileResource(model, this.fileDependencies[i])) == null) {
                    dep = this.fileDependencies[i].createResource(model);
                }
                fileResource.addProperty(p, (RDFNode)dep);
            }
        }
        p = model.createProperty("http://spdx.org/rdf/terms#", "licenseComments");
        model.removeAll(fileResource, p, null);
        if (this.licenseComments != null) {
            fileResource.addProperty(p, this.getLicenseComments());
        }
        p = model.createProperty("http://spdx.org/rdf/terms#", "copyrightText");
        model.removeAll(fileResource, p, null);
        if (this.copyright != null) {
            Resource r;
            if (this.copyright.equals("NONE")) {
                r = model.createResource("http://spdx.org/rdf/terms#none");
                fileResource.addProperty(p, (RDFNode)r);
            } else if (this.copyright.equals("NOASSERTION")) {
                r = model.createResource("http://spdx.org/rdf/terms#noassertion");
                fileResource.addProperty(p, (RDFNode)r);
            } else {
                fileResource.addProperty(p, this.getCopyright());
            }
        }
        p = model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "comment");
        model.removeAll(fileResource, p, null);
        if (this.comment != null) {
            fileResource.addProperty(p, this.comment);
        }
        p = model.createProperty("http://spdx.org/rdf/terms#", "artifactOf");
        model.removeAll(fileResource, p, null);
        if (this.artifactOf != null) {
            p = model.createProperty("http://spdx.org/rdf/terms#", "artifactOf");
            for (int i = 0; i < this.artifactOf.length; ++i) {
                Resource projectResource = this.artifactOf[i].createResource(model);
                fileResource.addProperty(p, (RDFNode)projectResource);
            }
        }
        p = model.createProperty("http://spdx.org/rdf/terms#", "fileContributor");
        model.removeAll(fileResource, p, null);
        if (this.contributors != null) {
            for (int i = 0; i < this.contributors.length; ++i) {
                fileResource.addProperty(p, this.contributors[i]);
            }
        }
        p = model.createProperty("http://spdx.org/rdf/terms#", "noticeText");
        model.removeAll(fileResource, p, null);
        if (this.noticeText != null) {
            fileResource.addProperty(p, this.getNoticeText());
        }
        this.model = model;
        this.resource = fileResource;
    }

    protected static Resource findFileResource(Model model, SPDXFile spdxFile) throws InvalidSPDXAnalysisException {
        Node fileNameProperty = model.getProperty("http://spdx.org/rdf/terms#", "fileName").asNode();
        Triple fileNameMatch = Triple.createMatch(null, (Node)fileNameProperty, (Node)Node.createLiteral((String)spdxFile.getName()));
        ExtendedIterator filenameMatchIter = model.getGraph().find((TripleMatch)fileNameMatch);
        if (filenameMatchIter.hasNext()) {
            Triple checksumMatchTriple;
            SPDXChecksum cksum;
            Triple fileMatchTriple = (Triple)filenameMatchIter.next();
            Node fileNode = fileMatchTriple.getSubject();
            Node checksumProperty = model.getProperty("http://spdx.org/rdf/terms#", "checksum").asNode();
            Triple checksumMatch = Triple.createMatch((Node)fileNode, (Node)checksumProperty, null);
            ExtendedIterator checksumMatchIterator = model.getGraph().find((TripleMatch)checksumMatch);
            if (checksumMatchIterator.hasNext() && (cksum = new SPDXChecksum(model, (checksumMatchTriple = (Triple)checksumMatchIterator.next()).getObject())).getValue().compareToIgnoreCase(spdxFile.getSha1()) == 0) {
                return SPDXFile.convertToResource(model, fileNode);
            }
        }
        return null;
    }

    public SPDXFile(String name, String type, String sha1, SPDXLicenseInfo concludedLicenses, SPDXLicenseInfo[] seenLicenses, String licenseComments, String copyright, DOAPProject[] artifactOf, String comment, SPDXFile[] fileDependencies, String[] contributors, String noticeText) {
        this.name = name;
        this.type = type;
        this.sha1 = new SPDXChecksum("SHA1", sha1);
        this.concludedLicenses = concludedLicenses;
        this.seenLicenses = seenLicenses;
        this.licenseComments = licenseComments;
        this.copyright = copyright;
        this.artifactOf = artifactOf;
        this.comment = comment;
        this.fileDependencies = fileDependencies == null ? new SPDXFile[0] : fileDependencies;
        this.contributors = contributors == null ? new String[0] : contributors;
        this.noticeText = noticeText;
    }

    public SPDXFile(String name, String type, String sha1, SPDXLicenseInfo concludedLicenses, SPDXLicenseInfo[] seenLicenses, String licenseComments, String copyright, DOAPProject[] artifactOf) {
        this(name, type, sha1, concludedLicenses, seenLicenses, licenseComments, copyright, artifactOf, null, null, null, null);
    }

    public SPDXFile(String name, String type, String sha1, SPDXLicenseInfo concludedLicenses, SPDXLicenseInfo[] seenLicenses, String licenseComments, String copyright, DOAPProject[] artifactOf, String comment) {
        this(name, type, sha1, concludedLicenses, seenLicenses, licenseComments, copyright, artifactOf, comment, null, null, null);
    }

    public SPDXLicenseInfo[] getSeenLicenses() {
        if (this.model != null && this.resource != null) {
            try {
                ArrayList<Node> alLicNode = new ArrayList<Node>();
                Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseInfoInFile").asNode();
                Triple m = Triple.createMatch((Node)this.resource.asNode(), (Node)p, null);
                ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
                while (tripleIter.hasNext()) {
                    Triple t = (Triple)tripleIter.next();
                    alLicNode.add(t.getObject());
                }
                boolean seenLicensesMatch = this.seenLicenses.length == alLicNode.size();
                int i = 0;
                while (seenLicensesMatch && i < this.seenLicenses.length) {
                    Resource licResource;
                    if ((licResource = this.seenLicenses[i++].getResource()) == null) {
                        seenLicensesMatch = false;
                        continue;
                    }
                    boolean found = false;
                    for (int j = 0; j < alLicNode.size(); ++j) {
                        if (!((Node)alLicNode.get(j)).equals((Object)licResource.asNode())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    seenLicensesMatch = false;
                }
                if (!seenLicensesMatch) {
                    this.seenLicenses = new SPDXLicenseInfo[alLicNode.size()];
                    int k = 0;
                    while (i < this.seenLicenses.length) {
                        this.seenLicenses[k] = SPDXLicenseInfoFactory.getLicenseInfoFromModel(this.model, (Node)alLicNode.get(k));
                        ++k;
                    }
                }
            }
            catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
                // empty catch block
            }
        }
        return this.seenLicenses;
    }

    public void setSeenLicenses(SPDXLicenseInfo[] seenLicenses) {
        this.seenLicenses = seenLicenses;
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseInfoInFile");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseInfoInFile");
            for (int i = 0; i < seenLicenses.length; ++i) {
                Resource lic = seenLicenses[i].createResource(this.model);
                this.resource.addProperty(p, (RDFNode)lic);
            }
        }
    }

    public String getLicenseComments() {
        if (this.model != null && this.resource != null) {
            Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseComments").asNode();
            Triple m = Triple.createMatch((Node)this.resource.asNode(), (Node)p, null);
            ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                this.licenseComments = t.getObject().toString(false);
            }
        }
        return this.licenseComments;
    }

    public void setLicenseComments(String licenseComments) {
        this.licenseComments = licenseComments;
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseComments");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseComments");
            this.resource.addProperty(p, this.getLicenseComments());
        }
    }

    public String getNoticeText() {
        if (this.model != null && this.resource != null) {
            Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "noticeText").asNode();
            Triple m = Triple.createMatch((Node)this.resource.asNode(), (Node)p, null);
            ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
            while (tripleIter.hasNext()) {
                this.noticeText = ((Triple)tripleIter.next()).getObject().toString(false);
            }
        }
        return this.noticeText;
    }

    public void setNoticeText(String noticeText) {
        this.noticeText = noticeText;
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "noticeText");
            this.model.removeAll(this.resource, p, null);
            if (this.noticeText != null) {
                p = this.model.createProperty("http://spdx.org/rdf/terms#", "noticeText");
                this.resource.addProperty(p, this.getNoticeText());
            }
        }
    }

    public String getComment() {
        if (this.model != null && this.resource != null) {
            Node p = this.model.getProperty("http://www.w3.org/2000/01/rdf-schema#", "comment").asNode();
            Triple m = Triple.createMatch((Node)this.resource.asNode(), (Node)p, null);
            ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
            while (tripleIter.hasNext()) {
                this.comment = ((Triple)tripleIter.next()).getObject().toString(false);
            }
        }
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "comment");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "comment");
            this.resource.addProperty(p, this.comment);
        }
    }

    public String getCopyright() {
        if (this.model != null && this.resource != null) {
            Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "copyrightText").asNode();
            Triple m = Triple.createMatch((Node)this.resource.asNode(), (Node)p, null);
            ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                if (t.getObject().isURI()) {
                    if (t.getObject().getURI().equals("http://spdx.org/rdf/terms#noassertion")) {
                        this.copyright = "NOASSERTION";
                        continue;
                    }
                    if (t.getObject().getURI().equals("http://spdx.org/rdf/terms#none")) {
                        this.copyright = "NONE";
                        continue;
                    }
                    this.copyright = t.getObject().toString(false);
                    continue;
                }
                this.copyright = t.getObject().toString(false);
            }
        }
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "copyrightText");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "copyrightText");
            if (copyright.equals("NONE")) {
                Resource r = this.model.createResource("http://spdx.org/rdf/terms#none");
                this.resource.addProperty(p, (RDFNode)r);
            } else if (copyright.equals("NOASSERTION")) {
                Resource r = this.model.createResource("http://spdx.org/rdf/terms#noassertion");
                this.resource.addProperty(p, (RDFNode)r);
            } else {
                this.resource.addProperty(p, this.getCopyright());
            }
        }
    }

    public String getName() {
        if (this.model != null && this.resource != null) {
            Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "fileName").asNode();
            Triple m = Triple.createMatch((Node)this.resource.asNode(), (Node)p, null);
            ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                this.name = t.getObject().toString(false);
            }
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "fileName");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "fileName");
            this.resource.addProperty(p, this.getName());
        }
    }

    public SPDXLicenseInfo getConcludedLicenses() {
        if (this.model != null && this.resource != null) {
            try {
                Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseConcluded").asNode();
                Triple m = Triple.createMatch((Node)this.resource.asNode(), (Node)p, null);
                ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
                Triple t = null;
                while (tripleIter.hasNext()) {
                    t = (Triple)tripleIter.next();
                    if (this.concludedLicenses == null || !t.getObject().equals((Object)this.concludedLicenses.getResource().asNode())) continue;
                }
                if (this.concludedLicenses == null || !t.getObject().equals((Object)this.concludedLicenses.getResource().asNode())) {
                    this.concludedLicenses = SPDXLicenseInfoFactory.getLicenseInfoFromModel(this.model, t.getObject());
                }
            }
            catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
                // empty catch block
            }
        }
        return this.concludedLicenses;
    }

    public void setConcludedLicenses(SPDXLicenseInfo fileLicenses) {
        this.concludedLicenses = fileLicenses;
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseConcluded");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseConcluded");
            Resource lic = fileLicenses.createResource(this.model);
            this.resource.addProperty(p, (RDFNode)lic);
        }
    }

    public String getSha1() {
        if (this.model != null && this.resource != null) {
            try {
                Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "checksum").asNode();
                Triple m = Triple.createMatch((Node)this.resource.asNode(), (Node)p, null);
                ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
                Triple t = null;
                while (tripleIter.hasNext()) {
                    t = (Triple)tripleIter.next();
                    if (this.sha1 == null || !this.nodesEquals(this.sha1.getResource().asNode(), t.getObject())) continue;
                }
                if (this.sha1 == null || !this.nodesEquals(this.sha1.getResource().asNode(), t.getObject())) {
                    this.sha1 = new SPDXChecksum(this.model, t.getObject());
                }
            }
            catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
                // empty catch block
            }
        }
        return this.sha1.getValue();
    }

    private boolean nodesEquals(Node n1, Node n2) {
        return n1.equals((Object)n2);
    }

    public void setSha1(String sha1) {
        this.sha1 = new SPDXChecksum("SHA1", sha1);
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "checksum");
            this.model.removeAll(this.resource, p, null);
            Resource cksumResource = this.sha1.createResource(this.model);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "checksum");
            this.resource.addProperty(p, (RDFNode)cksumResource);
        }
    }

    public String getType() {
        if (this.model != null && this.resource != null) {
            try {
                Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "fileType").asNode();
                Triple m = Triple.createMatch((Node)this.resource.asNode(), (Node)p, null);
                ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
                while (tripleIter.hasNext()) {
                    Triple t = (Triple)tripleIter.next();
                    if (t.getObject().isLiteral()) {
                        this.type = t.getObject().toString(false);
                        continue;
                    }
                    if (t.getObject().isURI()) {
                        this.type = RESOURCE_TO_FILE_TYPE.get(t.getObject().getURI());
                        if (this.type != null) continue;
                        throw new InvalidSPDXAnalysisException("Invalid URI for file type resource - must be one of the individual file types in http://spdx.org/rdf/terms");
                    }
                    throw new InvalidSPDXAnalysisException("Invalid file type property - must be a URI type specified in http://spdx.org/rdf/terms");
                }
            }
            catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
                // empty catch block
            }
        }
        return this.type;
    }

    public void setType(String type) throws InvalidSPDXAnalysisException {
        this.type = type;
        if (this.model != null && this.resource != null) {
            Resource typeResource = SPDXFile.fileTypeStringToTypeResource(type, this.model);
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "fileType");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "fileType");
            this.resource.addProperty(p, (RDFNode)typeResource);
        }
    }

    public static Resource fileTypeStringToTypeResource(String fileType, Model model) throws InvalidSPDXAnalysisException {
        String resourceUri = FILE_TYPE_TO_RESOURCE.get(fileType);
        if (resourceUri == null) {
            throw new InvalidSPDXAnalysisException("Invalid file type: " + fileType);
        }
        Resource retval = model.createResource(resourceUri);
        return retval;
    }

    public static String fileTypeResourceToString(Resource fileTypeResource) throws InvalidSPDXAnalysisException {
        if (!fileTypeResource.isURIResource()) {
            throw new InvalidSPDXAnalysisException("File type resource must be a URI.");
        }
        String retval = fileTypeResource.getURI();
        if (retval == null) {
            throw new InvalidSPDXAnalysisException("Not a recognized file type for an SPDX docuement.");
        }
        return retval;
    }

    public DOAPProject[] getArtifactOf() {
        if (this.model != null && this.resource != null) {
            try {
                int i;
                ArrayList<Node> alProjectNodes = new ArrayList<Node>();
                Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "artifactOf").asNode();
                Triple m = Triple.createMatch((Node)this.resource.asNode(), (Node)p, null);
                ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
                while (tripleIter.hasNext()) {
                    Triple t = (Triple)tripleIter.next();
                    alProjectNodes.add(t.getObject());
                }
                ArrayList<DOAPProject> alProjects = new ArrayList<DOAPProject>();
                boolean projectsDifferent = this.artifactOf.length != alProjectNodes.size();
                for (i = 0; i < this.artifactOf.length; ++i) {
                    Resource projectResource = this.artifactOf[i].getResource();
                    if (projectResource == null) {
                        projectsDifferent = true;
                        continue;
                    }
                    boolean found = false;
                    for (int j = 0; j < alProjectNodes.size(); ++j) {
                        if (!((Node)alProjectNodes.get(j)).equals((Object)projectResource.asNode())) continue;
                        found = true;
                        alProjects.add(this.artifactOf[i]);
                        alProjectNodes.remove(j);
                        break;
                    }
                    if (found) continue;
                    projectsDifferent = true;
                }
                if (projectsDifferent) {
                    for (i = 0; i < alProjectNodes.size(); ++i) {
                        alProjects.add(new DOAPProject(this.model, (Node)alProjectNodes.get(i)));
                    }
                    this.artifactOf = alProjects.toArray(new DOAPProject[alProjects.size()]);
                }
            }
            catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
                // empty catch block
            }
        }
        return this.artifactOf;
    }

    public void setArtifactOf(DOAPProject[] artifactOf) {
        this.artifactOf = artifactOf;
        if (this.model != null && this.resource != null && this.name != null) {
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "artifactOf");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "artifactOf");
            for (int i = 0; i < artifactOf.length; ++i) {
                Resource projectResource = null;
                String uri = artifactOf[i].getProjectUri();
                projectResource = uri != null && !uri.isEmpty() && !uri.equals("UNKNOWN") ? this.model.createResource(uri) : artifactOf[i].createResource(this.model);
                this.resource.addProperty(p, (RDFNode)projectResource);
            }
        }
    }

    public ArrayList<String> verify() {
        int count;
        ExtendedIterator tripleIter;
        Triple m;
        String checksum;
        int i;
        String fileType;
        ArrayList<String> retval = new ArrayList<String>();
        String fileName = this.getName();
        if (fileName == null || fileName.isEmpty()) {
            retval.add("Missing required name for file");
            fileName = "UNKNOWN";
        }
        if ((fileType = this.getType()) == null || fileType.isEmpty()) {
            retval.add("Missing required file type");
        } else {
            String verifyFileType = SpdxVerificationHelper.verifyFileType(fileType);
            if (verifyFileType != null) {
                retval.add(verifyFileType + "; File - " + fileName);
            }
        }
        String copyrightText = this.getCopyright();
        if (copyrightText == null || copyrightText.isEmpty()) {
            retval.add("Missing required copyright text for file " + fileName);
        }
        String comments = this.getLicenseComments();
        SPDXLicenseInfo concludedLicense = this.getConcludedLicenses();
        if (concludedLicense == null) {
            retval.add("Missing required concluded license for file " + fileName);
        } else {
            retval.addAll(concludedLicense.verify());
        }
        SPDXLicenseInfo[] licenseInfosInFile = this.getSeenLicenses();
        if (licenseInfosInFile == null || licenseInfosInFile.length == 0) {
            retval.add("Missing required license information in file for file " + fileName);
        } else {
            for (i = 0; i < licenseInfosInFile.length; ++i) {
                retval.addAll(licenseInfosInFile[i].verify());
            }
        }
        if (this.fileDependencies != null) {
            for (i = 0; i < this.fileDependencies.length; ++i) {
                ArrayList<String> verifyFileDependency = this.fileDependencies[i].verify();
                for (int j = 0; j < verifyFileDependency.size(); ++j) {
                    retval.add("Invalid file dependency for file named " + this.fileDependencies[i].getName() + ": " + verifyFileDependency.get(j));
                }
            }
        }
        if ((checksum = this.getSha1()) == null || checksum.isEmpty()) {
            retval.add("Missing required checksum for file " + fileName);
        } else {
            String verify = SpdxVerificationHelper.verifyChecksumString(checksum);
            if (verify != null) {
                retval.add(verify + "; file " + fileName);
            }
        }
        DOAPProject[] projects = this.getArtifactOf();
        if (projects != null) {
            for (int i2 = 0; i2 < projects.length; ++i2) {
                retval.addAll(projects[i2].verify());
            }
        }
        if (this.model != null && this.resource != null) {
            Node p = this.model.getProperty("http://www.w3.org/2000/01/rdf-schema#", "comment").asNode();
            m = Triple.createMatch((Node)this.resource.asNode(), (Node)p, null);
            tripleIter = this.model.getGraph().find((TripleMatch)m);
            count = 0;
            while (tripleIter.hasNext()) {
                tripleIter.next();
                ++count;
            }
            if (count > 1) {
                retval.add("More than one file comment for file " + this.name);
            }
        }
        if (this.model != null && this.resource != null) {
            Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "noticeText").asNode();
            m = Triple.createMatch((Node)this.resource.asNode(), (Node)p, null);
            tripleIter = this.model.getGraph().find((TripleMatch)m);
            count = 0;
            while (tripleIter.hasNext()) {
                tripleIter.next();
                ++count;
            }
            if (count > 1) {
                retval.add("More than one file notice for file " + this.name);
            }
        }
        return retval;
    }

    public SPDXFile[] getFileDependencies() {
        if (this.model != null && this.resource != null) {
            try {
                Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "fileDependency").asNode();
                Triple m = Triple.createMatch((Node)this.resource.asNode(), (Node)p, null);
                ArrayList<Node> alDependencyNodes = new ArrayList<Node>();
                ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
                while (tripleIter.hasNext()) {
                    Triple t = (Triple)tripleIter.next();
                    alDependencyNodes.add(t.getObject());
                }
                boolean fileDependenciesMatch = this.fileDependencies.length == alDependencyNodes.size();
                int i = 0;
                while (i < this.fileDependencies.length && fileDependenciesMatch) {
                    Resource fileDependencyResource;
                    if ((fileDependencyResource = this.fileDependencies[i++].getResource()) == null) {
                        fileDependenciesMatch = false;
                        continue;
                    }
                    Node fileDependancyNode = fileDependencyResource.asNode();
                    boolean found = false;
                    for (int j = 0; j < alDependencyNodes.size(); ++j) {
                        if (!((Node)alDependencyNodes.get(j)).equals((Object)fileDependancyNode)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    fileDependenciesMatch = false;
                }
                if (!fileDependenciesMatch) {
                    this.fileDependencies = new SPDXFile[alDependencyNodes.size()];
                    for (int k = 0; k < this.fileDependencies.length; ++k) {
                        this.fileDependencies[k] = new SPDXFile(this.model, (Node)alDependencyNodes.get(k));
                    }
                }
            }
            catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
                // empty catch block
            }
        }
        return this.fileDependencies;
    }

    public void setFileDependencies(SPDXFile[] fileDependencies) throws InvalidSPDXAnalysisException {
        this.fileDependencies = fileDependencies == null ? new SPDXFile[0] : fileDependencies;
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "fileDependency");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "fileDependency");
            for (int i = 0; i < this.fileDependencies.length; ++i) {
                Resource dep = this.fileDependencies[i].getResource();
                if (dep == null) {
                    dep = this.fileDependencies[i].createResource(this.model);
                }
                this.resource.addProperty(p, (RDFNode)dep);
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof SPDXFile)) {
            return false;
        }
        SPDXFile compareFile = (SPDXFile)o;
        if (this.model != null && this.resource != null) {
            Resource compareFileResource = compareFile.getResource();
            return this.resourcesEqual(this.resource, compareFileResource);
        }
        Resource compareFileResource = compareFile.getResource();
        if (compareFileResource != null) {
            return false;
        }
        return super.equals(o);
    }

    private boolean resourcesEqual(Resource r1, Resource r2) {
        if (r2 == null) {
            return false;
        }
        if (r1.isAnon()) {
            if (!r2.isAnon()) {
                return false;
            }
            return r1.getId().equals((Object)r2.getId());
        }
        if (!r2.isURIResource()) {
            return false;
        }
        return r1.getURI().equals(r2.getURI());
    }

    protected Resource getResource() {
        if (this.model == null) {
            return null;
        }
        return this.resource;
    }

    public String[] getContributors() {
        if (this.model != null && this.resource != null) {
            ArrayList<String> alContributors = new ArrayList<String>();
            Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "fileContributor").asNode();
            Triple m = Triple.createMatch((Node)this.resource.asNode(), (Node)p, null);
            ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                alContributors.add(t.getObject().toString(false));
            }
            this.contributors = alContributors.toArray(new String[alContributors.size()]);
        }
        return this.contributors;
    }

    public void setContributors(String[] contributors) {
        this.contributors = contributors == null ? new String[0] : contributors;
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "fileContributor");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "fileContributor");
            for (int i = 0; i < this.contributors.length; ++i) {
                this.resource.addProperty(p, this.contributors[i]);
            }
        }
    }

    @Override
    public int compareTo(SPDXFile file) {
        return this.getName().compareTo(file.getName());
    }

    static {
        FILE_TYPE_TO_RESOURCE.put("SOURCE", "http://spdx.org/rdf/terms#fileType_source");
        RESOURCE_TO_FILE_TYPE.put("http://spdx.org/rdf/terms#fileType_source", "SOURCE");
        FILE_TYPE_TO_RESOURCE.put("BINARY", "http://spdx.org/rdf/terms#fileType_binary");
        RESOURCE_TO_FILE_TYPE.put("http://spdx.org/rdf/terms#fileType_binary", "BINARY");
        FILE_TYPE_TO_RESOURCE.put("ARCHIVE", "http://spdx.org/rdf/terms#fileType_archive");
        RESOURCE_TO_FILE_TYPE.put("http://spdx.org/rdf/terms#fileType_archive", "ARCHIVE");
        FILE_TYPE_TO_RESOURCE.put("OTHER", "http://spdx.org/rdf/terms#fileType_other");
        RESOURCE_TO_FILE_TYPE.put("http://spdx.org/rdf/terms#fileType_other", "OTHER");
    }
}

