/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXLicenseInfo;

public abstract class SPDXLicense
extends SPDXLicenseInfo {
    protected String id;

    SPDXLicense(Model model, Node licenseInfoNode) throws InvalidSPDXAnalysisException {
        super(model, licenseInfoNode);
        Node p = model.getProperty("http://spdx.org/rdf/terms#", "licenseId").asNode();
        Triple m = Triple.createMatch((Node)licenseInfoNode, (Node)p, null);
        ExtendedIterator tripleIter = model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            this.id = t.getObject().toString(false);
        }
    }

    SPDXLicense(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        if (this.licenseInfoNode != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseId");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseId");
            this.resource.addProperty(p, id);
        }
    }

    protected Resource _createResource(Model model, Resource type, String uri) {
        Property idProperty;
        Resource r = null;
        if (this.id != null) {
            idProperty = model.createProperty("http://spdx.org/rdf/terms#", "licenseId");
            Property typeProperty = this.model.getProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type");
            Triple m = Triple.createMatch(null, (Node)idProperty.asNode(), null);
            ExtendedIterator tripleIter = model.getGraph().find((TripleMatch)m);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                if (!t.getObject().toString(false).equals(this.id)) continue;
                Triple typeMatch = Triple.createMatch((Node)t.getSubject(), (Node)typeProperty.asNode(), (Node)type.asNode());
                ExtendedIterator typeTripleIter = model.getGraph().find((TripleMatch)typeMatch);
                if (!typeTripleIter.hasNext()) continue;
                if (t.getSubject().isURI()) {
                    r = model.createResource(t.getSubject().getURI());
                    continue;
                }
                if (!t.getSubject().isBlank()) continue;
                r = model.createResource(t.getSubject().getBlankNodeId());
            }
        }
        if (r == null) {
            r = uri == null || uri.isEmpty() ? model.createResource(type) : model.createResource(uri, type);
            if (this.id != null) {
                idProperty = model.createProperty("http://spdx.org/rdf/terms#", "licenseId");
                r.addProperty(idProperty, this.id);
            }
        }
        return r;
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return 0;
        }
        return this.getId().hashCode();
    }

    @Override
    public boolean equals(Object comp) {
        if (comp == this) {
            return true;
        }
        if (!(comp instanceof SPDXLicense)) {
            return false;
        }
        SPDXLicense compl = (SPDXLicense)comp;
        return compl.getId().equals(this.getId());
    }

    public Resource _createResource(Model model, Resource type) {
        return this._createResource(model, type, null);
    }
}

