/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.ArrayList;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;

public abstract class SPDXLicenseInfo {
    Model model = null;
    Node licenseInfoNode = null;
    Resource resource = null;

    SPDXLicenseInfo(Model model, Node licenseInfoNode) throws InvalidSPDXAnalysisException {
        this.model = model;
        this.licenseInfoNode = licenseInfoNode;
        this.resource = this.convertToResource(model, licenseInfoNode);
    }

    private Resource convertToResource(Model cmodel, Node cnode) throws InvalidSPDXAnalysisException {
        if (cnode.isBlank()) {
            return cmodel.createResource(cnode.getBlankNodeId());
        }
        if (cnode.isURI()) {
            return cmodel.createResource(cnode.getURI());
        }
        throw new InvalidSPDXAnalysisException("Can not create a license from a literal");
    }

    SPDXLicenseInfo() {
        this.model = null;
        this.licenseInfoNode = null;
        this.resource = null;
    }

    public Resource createResource(Model model) {
        if (this.model != null && (this.model.equals((Object)model) || this.licenseInfoNode.isURI()) && this.licenseInfoNode != null && this.resource != null) {
            return this.resource;
        }
        this.model = model;
        Resource retval = this._createResource(model);
        this.licenseInfoNode = retval.asNode();
        this.resource = retval;
        return retval;
    }

    protected abstract Resource _createResource(Model var1);

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract ArrayList<String> verify();

    public Resource getResource() {
        return this.resource;
    }
}

