/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.NoStandardLicenseRdfModel;
import org.spdx.rdfparser.SPDXConjunctiveLicenseSet;
import org.spdx.rdfparser.SPDXDisjunctiveLicenseSet;
import org.spdx.rdfparser.SPDXLicenseInfo;
import org.spdx.rdfparser.SPDXNonStandardLicense;
import org.spdx.rdfparser.SPDXNoneLicense;
import org.spdx.rdfparser.SPDXStandardLicense;
import org.spdx.rdfparser.SpdxNoAssertionLicense;
import org.spdx.spdxspreadsheet.InvalidLicenseStringException;

public class SPDXLicenseInfoFactory {
    static final String[] STANDARD_LICENSE_IDS = new String[]{"AFL-1.1", "AFL-1.2", "AFL-2.0", "AFL-2.1", "AFL-3.0", "APL-1.0", "Aladdin", "ANTLR-PD", "Apache-1.0", "Apache-1.1", "Apache-2.0", "APSL-1.0", "APSL-1.1", "APSL-1.2", "APSL-2.0", "Artistic-1.0", "Artistic-1.0-cl8", "Artistic-1.0-Perl", "Artistic-2.0", "AAL", "BitTorrent-1.0", "BitTorrent-1.1", "BSL-1.0", "BSD-2-Clause", "BSD-2-Clause-FreeBSD", "BSD-2-Clause-NetBSD", "BSD-3-Clause", "BSD-3-Clause-Clear", "BSD-4-Clause", "BSD-4-Clause-UC", "CECILL-1.0", "CECILL-1.1", "CECILL-2.0", "CECILL-B", "CECILL-C", "ClArtistic", "CNRI-Python", "CNRI-Python-GPL-Compatible", "CPOL-1.02", "CDDL-1.0", "CDDL-1.1", "CPAL-1.0", "CPL-1.0", "CATOSL-1.1", "Condor-1.1", "CC-BY-1.0", "CC-BY-2.0", "CC-BY-2.5", "CC-BY-3.0", "CC-BY-ND-1.0", "CC-BY-ND-2.0", "CC-BY-ND-2.5", "CC-BY-ND-3.0", "CC-BY-NC-1.0", "CC-BY-NC-2.0", "CC-BY-NC-2.5", "CC-BY-NC-3.0", "CC-BY-NC-ND-1.0", "CC-BY-NC-ND-2.0", "CC-BY-NC-ND-2.5", "CC-BY-NC-ND-3.0", "CC-BY-NC-SA-1.0", "CC-BY-NC-SA-2.0", "CC-BY-NC-SA-2.5", "CC-BY-NC-SA-3.0", "CC-BY-SA-1.0", "CC-BY-SA-2.0", "CC-BY-SA-2.5", "CC-BY-SA-3.0", "CC0-1.0", "CUA-OPL-1.0", "D-FSL-1.0", "WTFPL", "EPL-1.0", "eCos-2.0", "ECL-1.0", "ECL-2.0", "EFL-1.0", "EFL-2.0", "Entessa", "ErlPL-1.1", "EUDatagrid", "EUPL-1.0", "EUPL-1.1", "Fair", "Frameworx-1.0", "FTL", "AGPL-1.0", "AGPL-3.0", "GFDL-1.1", "GFDL-1.2", "GFDL-1.3", "GPL-1.0", "GPL-1.0+", "GPL-2.0", "GPL-2.0+", "GPL-2.0-with-autoconf-exception", "GPL-2.0-with-bison-exception", "GPL-2.0-with-classpath-exception", "GPL-2.0-with-font-exception", "GPL-2.0-with-GCC-exception", "GPL-3.0", "GPL-3.0+", "GPL-3.0-with-autoconf-exception", "GPL-3.0-with-GCC-exception", "LGPL-2.1", "LGPL-2.1+", "LGPL-3.0", "LGPL-3.0+", "LGPL-2.0", "LGPL-2.0+", "gSOAP-1.3b", "HPND", "IBM-pibs", "IPL-1.0", "Imlib2", "IJG", "Intel", "IPA", "ISC", "JSON", "LPPL-1.3a", "LPPL-1.0", "LPPL-1.1", "LPPL-1.2", "LPPL-1.3c", "Libpng", "LPL-1.02", "LPL-1.0", "MS-PL", "MS-RL", "MirOS", "MIT", "Motosoto", "MPL-1.0", "MPL-1.1", "MPL-2.0", "MPL-2.0-no-copyleft-exception", "Multics", "NASA-1.3", "Naumen", "NBPL-1.0", "NGPL", "NOSL", "NPL-1.0", "NPL-1.1", "Nokia", "NPOSL-3.0", "NTP", "OCLC-2.0", "ODbL-1.0", "PDDL-1.0", "OGTSL", "OLDAP-2.2.2", "OLDAP-1.1", "OLDAP-1.2", "OLDAP-1.3", "OLDAP-1.4", "OLDAP-2.0", "OLDAP-2.0.1", "OLDAP-2.1", "OLDAP-2.2", "OLDAP-2.2.1", "OLDAP-2.3", "OLDAP-2.4", "OLDAP-2.5", "OLDAP-2.6", "OLDAP-2.7", "OPL-1.0", "OSL-1.0", "OSL-2.0", "OSL-2.1", "OSL-3.0", "OLDAP-2.8", "OpenSSL", "PHP-3.0", "PHP-3.01", "PostgreSQL", "Python-2.0", "QPL-1.0", "RPSL-1.0", "RPL-1.1", "RPL-1.5", "RHeCos-1.1", "RSCPL", "Ruby", "SAX-PD", "SGI-B-1.0", "SGI-B-1.1", "SGI-B-2.0", "OFL-1.0", "OFL-1.1", "SimPL-2.0", "Sleepycat", "SMLNJ", "SugarCRM-1.1.3", "SISSL", "SISSL-1.2", "SPL-1.0", "Watcom-1.0", "NCSA", "VSL-1.0", "W3C", "WXwindows", "Xnet", "X11", "XFree86-1.1", "YPL-1.0", "YPL-1.1", "Zimbra-1.3", "Zlib", "ZPL-1.1", "ZPL-2.0", "ZPL-2.1", "Unlicense"};
    public static final String DEFAULT_LICENSE_LIST_VERSION = "1.19";
    static final Logger logger = Logger.getLogger((String)SPDXLicenseInfoFactory.class.getName());
    static final String STANDARD_LICENSE_ID_URL = "http://spdx.org/licenses/";
    public static final String NOASSERTION_LICENSE_NAME = "NOASSERTION";
    public static final String NONE_LICENSE_NAME = "NONE";
    public static final String STANDARD_LICENSE_URI_PREFIX = "http://spdx.org/licenses/";
    private static final String STANDARD_LICENSE_RDF_LOCAL_DIR = "resources/stdlicenses";
    private static final String STANDARD_LICENSE_RDF_LOCAL_FILENAME = "resources/stdlicenses/index.html";
    private static final String STANDARD_LICENSE_PROPERTIES_FILENAME = "resources/stdlicenses/licenses.properties";
    private static Model standardLicenseModel = null;
    static final HashSet<String> STANDARD_LICENSE_ID_SET = new HashSet();
    static HashMap<String, SPDXStandardLicense> STANDARD_LICENSES = null;
    private static final Properties licenseProperties = SPDXLicenseInfoFactory.loadLicenseProperties();
    private static final boolean onlyUseLocalLicenses = Boolean.parseBoolean(System.getProperty("SPDXParser.OnlyUseLocalLicenses", licenseProperties.getProperty("OnlyUseLocalLicenses", "false")));
    static String LICENSE_LIST_VERSION = "1.19";
    static final HashSet<String> STANDARD_LICENSE_ID_URLS_SET;

    public static SPDXLicenseInfo getLicenseInfoFromModel(Model model, Node node) throws InvalidSPDXAnalysisException {
        if (!node.isURI() && !node.isBlank()) {
            throw new InvalidSPDXAnalysisException("Can not create a LicenseInfo from a literal node");
        }
        SPDXLicenseInfo retval = null;
        if (node.isURI()) {
            retval = SPDXLicenseInfoFactory.getLicenseInfoByUri(model, node);
        }
        if (retval == null) {
            retval = SPDXLicenseInfoFactory.getLicenseInfoByType(model, node);
        }
        if (retval == null) {
            retval = SPDXLicenseInfoFactory.getLicenseInfoById(model, node);
        }
        if (retval == null) {
            logger.error((Object)"Could not determine the type for a license");
            throw new InvalidSPDXAnalysisException("Could not determine the type for a license");
        }
        return retval;
    }

    private static SPDXLicenseInfo getLicenseInfoByUri(Model model, Node node) throws InvalidSPDXAnalysisException {
        if (!node.isURI()) {
            return null;
        }
        if (node.getURI().equals("http://spdx.org/rdf/terms#none")) {
            return new SPDXNoneLicense(model, node);
        }
        if (node.getURI().equals("http://spdx.org/rdf/terms#noassertion")) {
            return new SpdxNoAssertionLicense(model, node);
        }
        if (node.getURI().startsWith("http://spdx.org/licenses/")) {
            try {
                return SPDXLicenseInfoFactory.getLicenseFromStdLicModel(node.getURI());
            }
            catch (Exception ex) {
                logger.warn((Object)("Unable to get license from standard model for " + node.getURI()));
                return null;
            }
        }
        return null;
    }

    public static SPDXStandardLicense getStandardLicenseById(String licenseId) throws InvalidSPDXAnalysisException {
        return SPDXLicenseInfoFactory.getLicenseFromStdLicModel("http://spdx.org/licenses/" + licenseId);
    }

    protected static SPDXStandardLicense getLicenseFromStdLicModel(String uri) throws InvalidSPDXAnalysisException {
        URL licenseUrl = null;
        try {
            licenseUrl = new URL(uri);
        }
        catch (MalformedURLException e) {
            throw new InvalidSPDXAnalysisException("Invalid standard license URL: " + e.getMessage());
        }
        String[] pathParts = licenseUrl.getFile().split("/");
        String id = pathParts[pathParts.length - 1];
        if (STANDARD_LICENSES.containsKey(id)) {
            return STANDARD_LICENSES.get(id);
        }
        String base = "http://spdx.org/licenses/" + id;
        Model licenseModel = SPDXLicenseInfoFactory.getLicenseModel(uri, base);
        if (licenseModel == null) {
            throw new InvalidSPDXAnalysisException("No standard license was found at " + uri);
        }
        Resource licResource = licenseModel.getResource(base);
        if (licResource == null || !licenseModel.containsResource(licenseModel.asRDFNode(licResource.asNode()))) {
            throw new InvalidSPDXAnalysisException("No standard license was found at " + uri);
        }
        SPDXStandardLicense retval = new SPDXStandardLicense(licenseModel, licResource.asNode());
        STANDARD_LICENSES.put(id, retval);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Model getLicenseModel(String uri, String base) throws NoStandardLicenseRdfModel {
        try {
            Class.forName("net.rootdev.javardfa.jena.RDFaReader");
        }
        catch (ClassNotFoundException e) {
            throw new NoStandardLicenseRdfModel("Could not load the RDFa reader for licenses.  This could be caused by an installation problem - missing java-rdfa jar file");
        }
        Model retval = ModelFactory.createDefaultModel();
        InputStream in = null;
        try {
            block21: {
                try {
                    if (onlyUseLocalLicenses) break block21;
                    in = FileManager.get().open(uri);
                    try {
                        retval.read(in, base, "HTML");
                        Property p = retval.getProperty("http://spdx.org/rdf/terms#", "licenseId");
                        if (!retval.isEmpty() && retval.contains(null, p)) break block21;
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            logger.warn((Object)"Error closing standard license input");
                        }
                        in = null;
                    }
                    catch (Exception ex) {
                        if (in != null) {
                            in.close();
                            in = null;
                        }
                    }
                }
                catch (Exception ex) {
                    in = null;
                    logger.warn((Object)"Unable to open SPDX standard license model.  Using local file copy for standard licenses");
                }
            }
            if (in == null) {
                String id = uri.substring("http://spdx.org/licenses/".length());
                String fileName = "resources/stdlicenses/" + id;
                in = SPDXLicenseInfoFactory.class.getResourceAsStream("/" + fileName);
                if (in == null) {
                    throw new NoStandardLicenseRdfModel("Standard license " + uri + " could not be read.");
                }
                try {
                    retval.read(in, base, "HTML");
                }
                catch (Exception ex) {
                    throw new NoStandardLicenseRdfModel("Error reading the standard licenses: " + ex.getMessage(), ex);
                }
            }
            Model model = retval;
            return model;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.warn((Object)"Unable to close model input stream");
                }
            }
        }
    }

    private static Model getStandardLicenseModel() throws InvalidSPDXAnalysisException {
        if (standardLicenseModel == null) {
            SPDXLicenseInfoFactory.loadStandardLicenseModel();
        }
        return standardLicenseModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadStandardLicenseModel() throws InvalidSPDXAnalysisException {
        InputStream licRdfInput;
        String base;
        String fileType;
        Model myStdLicModel;
        block23: {
            try {
                Class.forName("net.rootdev.javardfa.jena.RDFaReader");
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)"Unable to load Java RDFa reader");
            }
            myStdLicModel = ModelFactory.createDefaultModel();
            fileType = "HTML";
            base = "http://spdx.org/licenses/index.html";
            if (onlyUseLocalLicenses) {
                licRdfInput = null;
            } else {
                licRdfInput = FileManager.get().open("http://spdx.org/licenses/index.html");
                try {
                    myStdLicModel.read(licRdfInput, base, fileType);
                    Property p = myStdLicModel.getProperty("http://spdx.org/rdf/terms#", "licenseId");
                    if (!myStdLicModel.isEmpty() && myStdLicModel.contains(null, p)) break block23;
                    try {
                        licRdfInput.close();
                    }
                    catch (IOException e) {
                        logger.warn((Object)"Error closing standard license input");
                    }
                    licRdfInput = null;
                }
                catch (Exception ex) {
                    logger.warn((Object)"Unable to access the SPDX standard licenses at http://www.spdx.org/licenses.  Using local file copy of standard licenses");
                    if (licRdfInput == null) break block23;
                    try {
                        licRdfInput.close();
                    }
                    catch (IOException e) {
                        logger.warn((Object)"Error closing standard license input");
                    }
                    licRdfInput = null;
                }
            }
        }
        try {
            if (licRdfInput == null) {
                base = "file://resources/stdlicenses/index.html";
                licRdfInput = FileManager.get().open(STANDARD_LICENSE_RDF_LOCAL_FILENAME);
                if (licRdfInput == null) {
                    licRdfInput = SPDXLicenseInfoFactory.class.getResourceAsStream("/resources/stdlicenses/index.html");
                }
                if (licRdfInput == null) {
                    throw new NoStandardLicenseRdfModel("Unable to open standard license from website or from local file");
                }
                try {
                    myStdLicModel.read(licRdfInput, base, fileType);
                }
                catch (Exception ex) {
                    throw new NoStandardLicenseRdfModel("Unable to read the standard license model", ex);
                }
            }
            standardLicenseModel = myStdLicModel;
        }
        finally {
            if (licRdfInput != null) {
                try {
                    licRdfInput.close();
                }
                catch (IOException e) {
                    logger.warn((Object)"Unable to close license RDF Input Stream");
                }
            }
        }
    }

    static void loadStdLicenseIDs() {
        block4: {
            STANDARD_LICENSES = new HashMap();
            try {
                Triple t;
                Model stdLicenseModel = SPDXLicenseInfoFactory.getStandardLicenseModel();
                Node p = stdLicenseModel.getProperty("http://spdx.org/rdf/terms#", "licenseId").asNode();
                Triple m = Triple.createMatch(null, (Node)p, null);
                ExtendedIterator tripleIter = stdLicenseModel.getGraph().find((TripleMatch)m);
                while (tripleIter.hasNext()) {
                    t = (Triple)tripleIter.next();
                    STANDARD_LICENSE_ID_SET.add(t.getObject().toString(false));
                }
                p = stdLicenseModel.getProperty("http://spdx.org/rdf/terms#", "licenseListVersion").asNode();
                m = Triple.createMatch(null, (Node)p, null);
                tripleIter = stdLicenseModel.getGraph().find((TripleMatch)m);
                if (!tripleIter.hasNext()) break block4;
                t = (Triple)tripleIter.next();
                LICENSE_LIST_VERSION = t.getObject().toString(false);
            }
            catch (Exception ex) {
                logger.warn((Object)"Error loading standard license ID's from model.  Using static standard license ID's");
                for (int i = 0; i < STANDARD_LICENSE_IDS.length; ++i) {
                    STANDARD_LICENSE_ID_SET.add(STANDARD_LICENSE_IDS[i]);
                }
            }
        }
    }

    private static SPDXLicenseInfo getLicenseInfoById(Model model, Node node) throws InvalidSPDXAnalysisException {
        Node licenseIdPredicate = model.getProperty("http://spdx.org/rdf/terms#", "licenseId").asNode();
        Triple m = Triple.createMatch((Node)node, (Node)licenseIdPredicate, null);
        ExtendedIterator tripleIter = model.getGraph().find((TripleMatch)m);
        if (tripleIter.hasNext()) {
            Triple triple = (Triple)tripleIter.next();
            String id = triple.getObject().toString(false);
            if (tripleIter.hasNext()) {
                throw new InvalidSPDXAnalysisException("More than one ID associated with license " + id);
            }
            if (SPDXLicenseInfoFactory.isStandardLicenseID(id)) {
                return new SPDXStandardLicense(model, node);
            }
            if (id.startsWith("LicenseRef-")) {
                return new SPDXNonStandardLicense(model, node);
            }
            return null;
        }
        throw new InvalidSPDXAnalysisException("No ID associated with a license");
    }

    private static SPDXLicenseInfo getLicenseInfoByType(Model model, Node node) throws InvalidSPDXAnalysisException {
        Node rdfTypePredicate = model.getProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type").asNode();
        Triple m = Triple.createMatch((Node)node, (Node)rdfTypePredicate, null);
        ExtendedIterator tripleIter = model.getGraph().find((TripleMatch)m);
        if (tripleIter.hasNext()) {
            Triple triple = (Triple)tripleIter.next();
            if (tripleIter.hasNext()) {
                throw new InvalidSPDXAnalysisException("More than one type associated with a licenseInfo");
            }
            Node typeNode = triple.getObject();
            if (!typeNode.isURI()) {
                throw new InvalidSPDXAnalysisException("Invalid type for licenseInfo - not a URI");
            }
            String typeUri = typeNode.getURI();
            if (!typeUri.startsWith("http://spdx.org/rdf/terms#")) {
                throw new InvalidSPDXAnalysisException("Invalid type for licenseInfo - not an SPDX type");
            }
            String type = typeUri.substring("http://spdx.org/rdf/terms#".length());
            if (type.equals("ConjunctiveLicenseSet")) {
                return new SPDXConjunctiveLicenseSet(model, node);
            }
            if (type.equals("DisjunctiveLicenseSet")) {
                return new SPDXDisjunctiveLicenseSet(model, node);
            }
            if (type.equals("ExtractedLicensingInfo")) {
                return new SPDXNonStandardLicense(model, node);
            }
            if (type.equals("License")) {
                return new SPDXStandardLicense(model, node);
            }
            throw new InvalidSPDXAnalysisException("Invalid type for licenseInfo '" + type + "'");
        }
        return null;
    }

    public static SPDXLicenseInfo parseSPDXLicenseString(String licenseString) throws InvalidLicenseStringException {
        int endOfIDPos;
        String parseString = licenseString.trim();
        if (parseString.isEmpty()) {
            throw new InvalidLicenseStringException("Empty license string");
        }
        if (parseString.charAt(0) == '(') {
            if (!parseString.endsWith(")")) {
                throw new InvalidLicenseStringException("Missing end ')'");
            }
            parseString = parseString.substring(1, parseString.length() - 1).trim();
            return SPDXLicenseInfoFactory.parseLicenseSet(parseString);
        }
        int startOfIDPos = SPDXLicenseInfoFactory.skipWhiteSpace(parseString, 0);
        String licenseID = parseString.substring(startOfIDPos, endOfIDPos = SPDXLicenseInfoFactory.skipNonWhiteSpace(parseString, startOfIDPos));
        if (licenseID.equals(NONE_LICENSE_NAME)) {
            return new SPDXNoneLicense();
        }
        if (licenseID.equals(NOASSERTION_LICENSE_NAME)) {
            return new SpdxNoAssertionLicense();
        }
        if (SPDXLicenseInfoFactory.isStandardLicenseID(licenseID)) {
            try {
                return SPDXLicenseInfoFactory.getStandardLicenseById(licenseID);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new InvalidLicenseStringException(e.getMessage());
            }
        }
        return new SPDXNonStandardLicense(licenseID, null);
    }

    private static SPDXLicenseInfo parseLicenseSet(String parseString) throws InvalidLicenseStringException {
        boolean isConjunctive = false;
        boolean isDisjunctive = false;
        ArrayList<SPDXLicenseInfo> licenseInfoList = new ArrayList<SPDXLicenseInfo>();
        int pos = 0;
        while (pos < parseString.length() && (pos = SPDXLicenseInfoFactory.skipWhiteSpace(parseString, pos)) < parseString.length()) {
            if (parseString.charAt(pos) == '(') {
                int startOfSet = pos + 1;
                if ((pos = SPDXLicenseInfoFactory.findEndOfSet(parseString, pos)) > parseString.length() || parseString.charAt(pos) != ')') {
                    throw new InvalidLicenseStringException("Missing end ')'");
                }
                licenseInfoList.add(SPDXLicenseInfoFactory.parseLicenseSet(parseString.substring(startOfSet, pos)));
                ++pos;
            } else {
                int startOfID = pos;
                String licenseID = parseString.substring(startOfID, pos = SPDXLicenseInfoFactory.skipNonWhiteSpace(parseString, pos));
                if (licenseID.equals(NONE_LICENSE_NAME)) {
                    licenseInfoList.add(new SPDXNoneLicense());
                } else if (licenseID.equals(NOASSERTION_LICENSE_NAME)) {
                    licenseInfoList.add(new SpdxNoAssertionLicense());
                }
                if (SPDXLicenseInfoFactory.isStandardLicenseID(licenseID)) {
                    try {
                        licenseInfoList.add(SPDXLicenseInfoFactory.getStandardLicenseById(licenseID));
                    }
                    catch (InvalidSPDXAnalysisException e) {
                        throw new InvalidLicenseStringException(e.getMessage());
                    }
                } else {
                    licenseInfoList.add(new SPDXNonStandardLicense(licenseID, null));
                }
            }
            if (pos >= parseString.length()) break;
            if (parseString.charAt(pos = SPDXLicenseInfoFactory.skipWhiteSpace(parseString, pos)) == 'A' || parseString.charAt(pos) == 'a') {
                if (pos + 4 >= parseString.length() || !parseString.substring(pos, pos + 4).toUpperCase().equals("AND ")) {
                    throw new InvalidLicenseStringException("Expecting an AND");
                }
                isConjunctive = true;
                pos += 4;
                continue;
            }
            if (parseString.charAt(pos) == 'O' || parseString.charAt(pos) == 'o') {
                if (pos + 3 >= parseString.length() || !parseString.substring(pos, pos + 3).toUpperCase().equals("OR ")) {
                    throw new InvalidLicenseStringException("Expecting an OR");
                }
                isDisjunctive = true;
                pos += 3;
                continue;
            }
            throw new InvalidLicenseStringException("Expecting an AND or an OR");
        }
        if (isConjunctive && isDisjunctive) {
            throw new InvalidLicenseStringException("Can not have both AND's and OR's inside the same set of parenthesis");
        }
        SPDXLicenseInfo[] licenseInfos = new SPDXLicenseInfo[licenseInfoList.size()];
        licenseInfos = licenseInfoList.toArray(licenseInfos);
        if (isConjunctive) {
            return new SPDXConjunctiveLicenseSet(licenseInfos);
        }
        if (isDisjunctive) {
            return new SPDXDisjunctiveLicenseSet(licenseInfos);
        }
        throw new InvalidLicenseStringException("Missing AND or OR inside parenthesis");
    }

    private static int findEndOfSet(String parseString, int pos) throws InvalidLicenseStringException {
        if (parseString.charAt(pos) != '(') {
            throw new InvalidLicenseStringException("Expecting '('");
        }
        int retval = pos;
        ++retval;
        while (retval < parseString.length() && parseString.charAt(retval) != ')') {
            if (parseString.charAt(retval) == '(') {
                retval = SPDXLicenseInfoFactory.findEndOfSet(parseString, retval) + 1;
                continue;
            }
            ++retval;
        }
        return retval;
    }

    private static int skipWhiteSpace(String parseString, int pos) {
        int retval = pos;
        char c = parseString.charAt(retval);
        while (retval < parseString.length() && (c == ' ' || c == '\t' || c == '\r' || c == '\n')) {
            if (++retval >= parseString.length()) continue;
            c = parseString.charAt(retval);
        }
        return retval;
    }

    private static int skipNonWhiteSpace(String parseString, int pos) {
        int retval = pos;
        char c = parseString.charAt(retval);
        while (retval < parseString.length() && c != ' ' && c != '\t' && c != '\r' && c != '\n') {
            if (++retval >= parseString.length()) continue;
            c = parseString.charAt(retval);
        }
        return retval;
    }

    public static boolean isStandardLicenseID(String licenseID) {
        return STANDARD_LICENSE_ID_SET.contains(licenseID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadLicenseProperties() {
        Properties licenseProperties = new Properties();
        InputStream in = null;
        try {
            in = SPDXLicenseInfoFactory.class.getResourceAsStream("/resources/stdlicenses/licenses.properties");
            licenseProperties.load(in);
        }
        catch (IOException e) {
            logger.warn((Object)("IO Exception reading standard license properties file: " + e.getMessage()));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.warn((Object)("Unable to close standard license properties file: " + e.getMessage()));
                }
            }
        }
        return licenseProperties;
    }

    public static String[] getStandardLicenseIds() {
        return STANDARD_LICENSE_ID_SET.toArray(new String[STANDARD_LICENSE_ID_SET.size()]);
    }

    public static String getLicenseListVersion() {
        return LICENSE_LIST_VERSION;
    }

    static {
        SPDXLicenseInfoFactory.loadStdLicenseIDs();
        STANDARD_LICENSE_ID_URLS_SET = new HashSet();
        for (int i = 0; i < STANDARD_LICENSE_IDS.length; ++i) {
            STANDARD_LICENSE_ID_URLS_SET.add("http://spdx.org/licenses/" + STANDARD_LICENSE_IDS[i]);
        }
    }
}

