/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXLicenseInfo;
import org.spdx.rdfparser.SPDXLicenseInfoFactory;

public abstract class SPDXLicenseSet
extends SPDXLicenseInfo {
    protected HashSet<SPDXLicenseInfo> licenseInfos = new HashSet();

    public SPDXLicenseSet(Model model, Node licenseInfoNode) throws InvalidSPDXAnalysisException {
        super(model, licenseInfoNode);
        Node p = model.getProperty("http://spdx.org/rdf/terms#", "member").asNode();
        Triple m = Triple.createMatch((Node)licenseInfoNode, (Node)p, null);
        ExtendedIterator tripleIter = model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            this.licenseInfos.add(SPDXLicenseInfoFactory.getLicenseInfoFromModel(model, t.getObject()));
        }
    }

    public SPDXLicenseSet(SPDXLicenseInfo[] licenseInfos) {
        if (licenseInfos != null) {
            for (int i = 0; i < licenseInfos.length; ++i) {
                this.licenseInfos.add(licenseInfos[i]);
            }
        }
    }

    protected Resource _createResource(Model model, Resource type) {
        Resource r = model.createResource(type);
        Property licProperty = model.createProperty("http://spdx.org/rdf/terms#", "member");
        Iterator<SPDXLicenseInfo> iter = this.licenseInfos.iterator();
        while (iter.hasNext()) {
            Resource licResource = iter.next().createResource(model);
            r.addProperty(licProperty, (RDFNode)licResource);
        }
        return r;
    }

    public void setSPDXLicenseInfos(SPDXLicenseInfo[] licenseInfos) {
        this.licenseInfos.clear();
        if (licenseInfos != null) {
            for (int i = 0; i < licenseInfos.length; ++i) {
                this.licenseInfos.add(licenseInfos[i]);
            }
        }
        if (this.model != null && this.licenseInfoNode != null) {
            Property licProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "member");
            this.model.removeAll(this.resource, licProperty, null);
            licProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "member");
            for (int i = 0; i < licenseInfos.length; ++i) {
                Resource licResource = licenseInfos[i].createResource(this.model);
                this.resource.addProperty(licProperty, (RDFNode)licResource);
            }
        }
    }

    public SPDXLicenseInfo[] getSPDXLicenseInfos() {
        SPDXLicenseInfo[] retval = new SPDXLicenseInfo[this.licenseInfos.size()];
        retval = this.licenseInfos.toArray(retval);
        return retval;
    }

    @Override
    public ArrayList<String> verify() {
        ArrayList<String> retval = new ArrayList<String>();
        Iterator<SPDXLicenseInfo> iter = this.licenseInfos.iterator();
        while (iter.hasNext()) {
            retval.addAll(iter.next().verify());
        }
        return retval;
    }
}

