/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXLicense;
import org.spdx.rdfparser.SpdxVerificationHelper;

public class SPDXNonStandardLicense
extends SPDXLicense {
    private String text;
    private String comment = null;
    private String licenseName = null;
    private String[] sourceUrls = null;

    public SPDXNonStandardLicense(Model model, Node licenseInfoNode) throws InvalidSPDXAnalysisException {
        super(model, licenseInfoNode);
        Triple t;
        Node p = model.getProperty("http://spdx.org/rdf/terms#", "extractedText").asNode();
        Triple m = Triple.createMatch((Node)licenseInfoNode, (Node)p, null);
        ExtendedIterator tripleIter = model.getGraph().find((TripleMatch)m);
        if (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.text = t.getObject().toString(false);
        }
        p = model.getProperty("http://www.w3.org/2000/01/rdf-schema#", "comment").asNode();
        m = Triple.createMatch((Node)licenseInfoNode, (Node)p, null);
        tripleIter = model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.comment = t.getObject().toString(false);
        }
        p = model.getProperty("http://spdx.org/rdf/terms#", "licenseName").asNode();
        m = Triple.createMatch((Node)licenseInfoNode, (Node)p, null);
        tripleIter = model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.licenseName = t.getObject().toString(false);
        }
        p = model.getProperty("http://www.w3.org/2000/01/rdf-schema#", "seeAlso").asNode();
        m = Triple.createMatch((Node)licenseInfoNode, (Node)p, null);
        tripleIter = model.getGraph().find((TripleMatch)m);
        if (tripleIter.hasNext()) {
            ArrayList<String> alLicenseUrls = new ArrayList<String>();
            while (tripleIter.hasNext()) {
                Triple t2 = (Triple)tripleIter.next();
                alLicenseUrls.add(t2.getObject().toString(false));
            }
            this.sourceUrls = alLicenseUrls.toArray(new String[alLicenseUrls.size()]);
        }
    }

    public SPDXNonStandardLicense(String id, String text, String licenseName, String[] crossReferenceUrls, String comment) {
        super(id);
        this.text = text;
        this.licenseName = licenseName;
        this.sourceUrls = crossReferenceUrls;
        this.comment = comment;
    }

    public SPDXNonStandardLicense(String licenseID, String licenseText) {
        this(licenseID, licenseText, null, null, null);
    }

    @Override
    protected Resource _createResource(Model model) {
        Resource type = model.createResource("http://spdx.org/rdf/terms#ExtractedLicensingInfo");
        Resource r = super._createResource(model, type);
        if (this.text != null) {
            Property textProperty = model.createProperty("http://spdx.org/rdf/terms#", "extractedText");
            model.removeAll(r, textProperty, null);
            r.addProperty(textProperty, this.text);
        }
        if (this.comment != null && !this.comment.isEmpty()) {
            Property commentProperty = model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "comment");
            model.removeAll(r, commentProperty, null);
            r.addProperty(commentProperty, this.comment);
        }
        if (this.licenseName != null && !this.licenseName.isEmpty()) {
            Property nameProperty = model.createProperty("http://spdx.org/rdf/terms#", "licenseName");
            model.removeAll(r, nameProperty, null);
            r.addProperty(nameProperty, this.licenseName);
        }
        if (this.sourceUrls != null && this.sourceUrls.length > 0) {
            Property licenseUrlProperty = model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "seeAlso");
            model.removeAll(r, licenseUrlProperty, null);
            for (int i = 0; i < this.sourceUrls.length; ++i) {
                r.addProperty(licenseUrlProperty, this.sourceUrls[i]);
            }
        }
        return r;
    }

    @Override
    public String toString() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        if (this.licenseInfoNode != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "extractedText");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "extractedText");
            this.resource.addProperty(p, text);
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
        if (this.licenseInfoNode != null) {
            Property p = this.model.getProperty("http://www.w3.org/2000/01/rdf-schema#", "comment");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "comment");
            this.resource.addProperty(p, comment);
        }
    }

    public void setSourceUrls(String[] urls) {
        this.sourceUrls = urls;
        if (this.licenseInfoNode != null) {
            Property p = this.model.getProperty("http://www.w3.org/2000/01/rdf-schema#", "seeAlso");
            this.model.removeAll(this.resource, p, null);
            for (int i = 0; i < urls.length; ++i) {
                this.resource.addProperty(p, urls[i]);
            }
        }
    }

    public void setLicenseName(String name) {
        this.licenseName = name;
        if (this.licenseInfoNode != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseName");
            this.model.removeAll(this.resource, p, null);
            this.resource.addProperty(p, name);
        }
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return 0;
        }
        return this.getId().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SPDXNonStandardLicense)) {
            return false;
        }
        SPDXNonStandardLicense comp = (SPDXNonStandardLicense)o;
        if (this.id == null) {
            return comp.getId() == null;
        }
        return this.id.equals(comp.getId());
    }

    @Override
    public ArrayList<String> verify() {
        ArrayList<String> retval = new ArrayList<String>();
        String id = this.getId();
        if (id == null || id.isEmpty()) {
            retval.add("Missing required license ID");
        } else {
            String idError = SpdxVerificationHelper.verifyNonStdLicenseid(id);
            if (idError != null && !idError.isEmpty()) {
                retval.add(idError);
            }
        }
        String licenseText = this.getText();
        if (licenseText == null || licenseText.isEmpty()) {
            retval.add("Missing required license text for " + id);
        }
        try {
            if (this.licenseInfoNode != null) {
                Node p = this.model.getProperty("http://www.w3.org/2000/01/rdf-schema#", "comment").asNode();
                Triple m = Triple.createMatch((Node)this.licenseInfoNode, (Node)p, null);
                ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
                int count = 0;
                while (tripleIter.hasNext()) {
                    ++count;
                    tripleIter.next();
                }
                if (count > 1) {
                    retval.add("More than one comment on Extracted License Info id " + id.toString());
                }
            }
        }
        catch (Exception e) {
            retval.add("Error getting license comments: " + e.getMessage());
        }
        return retval;
    }

    public String getLicenseName() {
        return this.licenseName;
    }

    public String[] getSourceUrls() {
        return this.sourceUrls;
    }
}

