/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import org.apache.commons.lang3.StringEscapeUtils;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXLicense;

public class SPDXStandardLicense
extends SPDXLicense {
    static final String XML_LITERAL = "^^http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral";
    private boolean textInHtml = true;
    private boolean templateInHtml = true;
    private String name;
    private String[] sourceUrl;
    private String comments;
    private String standardLicenseHeader;
    private String template;
    private String text;
    private boolean osiApproved;

    public SPDXStandardLicense(String name, String id, String text, String[] sourceUrl, String notes, String standardLicenseNotice, String template, boolean osiApproved) throws InvalidSPDXAnalysisException {
        super(id);
        this.name = name;
        this.sourceUrl = sourceUrl;
        this.comments = notes;
        this.standardLicenseHeader = standardLicenseNotice;
        this.template = template;
        this.osiApproved = osiApproved;
        this.text = text;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SPDXStandardLicense(Model spdxModel, Node licenseNode) throws InvalidSPDXAnalysisException {
        super(spdxModel, licenseNode);
        Triple t;
        Triple t2;
        this.name = null;
        Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "name").asNode();
        Triple m = Triple.createMatch((Node)licenseNode, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find((TripleMatch)m);
        if (tripleIter.hasNext()) {
            t2 = (Triple)tripleIter.next();
            this.name = t2.getObject().toString(false);
        } else {
            p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseName").asNode();
            m = Triple.createMatch((Node)licenseNode, (Node)p, null);
            tripleIter = this.model.getGraph().find((TripleMatch)m);
            if (tripleIter.hasNext()) {
                t2 = (Triple)tripleIter.next();
                this.name = t2.getObject().toString(false);
            } else {
                this.name = this.id;
            }
        }
        p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseText").asNode();
        m = Triple.createMatch((Node)this.licenseInfoNode, (Node)p, null);
        tripleIter = this.model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            t2 = (Triple)tripleIter.next();
            this.text = t2.getObject().toString(false);
            if (this.text.endsWith(XML_LITERAL)) {
                this.text = this.text.substring(0, this.text.length() - XML_LITERAL.length());
            }
            if (!this.textInHtml) continue;
            this.text = SpdxLicenseTemplateHelper.HtmlToText(this.text);
        }
        ArrayList<String> alsourceUrls = new ArrayList<String>();
        p = this.model.getProperty("http://www.w3.org/2000/01/rdf-schema#", "seeAlso").asNode();
        m = Triple.createMatch((Node)licenseNode, (Node)p, null);
        tripleIter = this.model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            alsourceUrls.add(t.getObject().toString(false));
        }
        p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseSourceUrl").asNode();
        m = Triple.createMatch((Node)licenseNode, (Node)p, null);
        tripleIter = this.model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            alsourceUrls.add(t.getObject().toString(false));
        }
        p = this.model.getProperty("http://www.w3.org/2002/07/owl#", "sameAs").asNode();
        m = Triple.createMatch((Node)licenseNode, (Node)p, null);
        tripleIter = this.model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            alsourceUrls.add(t.getObject().toString(false));
        }
        this.sourceUrl = alsourceUrls.toArray(new String[alsourceUrls.size()]);
        p = this.model.getProperty("http://www.w3.org/2000/01/rdf-schema#", "comment").asNode();
        m = Triple.createMatch((Node)licenseNode, (Node)p, null);
        tripleIter = this.model.getGraph().find((TripleMatch)m);
        if (!tripleIter.hasNext()) {
            p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseNotes").asNode();
            m = Triple.createMatch((Node)licenseNode, (Node)p, null);
            tripleIter = this.model.getGraph().find((TripleMatch)m);
        }
        if (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.comments = t.getObject().toString(false);
        } else {
            this.comments = null;
        }
        p = this.model.getProperty("http://spdx.org/rdf/terms#", "standardLicenseHeader").asNode();
        m = Triple.createMatch((Node)licenseNode, (Node)p, null);
        tripleIter = this.model.getGraph().find((TripleMatch)m);
        if (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.standardLicenseHeader = t.getObject().toString(false);
        } else {
            p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseHeader").asNode();
            m = Triple.createMatch((Node)licenseNode, (Node)p, null);
            tripleIter = this.model.getGraph().find((TripleMatch)m);
            if (tripleIter.hasNext()) {
                t = (Triple)tripleIter.next();
                this.standardLicenseHeader = t.getObject().toString(false);
            } else {
                this.standardLicenseHeader = null;
            }
        }
        if (this.standardLicenseHeader != null) {
            this.standardLicenseHeader = StringEscapeUtils.unescapeHtml4((String)this.standardLicenseHeader);
        }
        p = this.model.getProperty("http://spdx.org/rdf/terms#", "standardLicenseTemplate").asNode();
        m = Triple.createMatch((Node)licenseNode, (Node)p, null);
        tripleIter = this.model.getGraph().find((TripleMatch)m);
        if (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.template = t.getObject().toString(false);
            if (this.template.endsWith(XML_LITERAL)) {
                this.template = this.template.substring(0, this.template.length() - XML_LITERAL.length());
            }
            if (this.templateInHtml) {
                this.template = SpdxLicenseTemplateHelper.HtmlToText(this.template);
            }
        } else {
            p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseTemplate").asNode();
            m = Triple.createMatch((Node)licenseNode, (Node)p, null);
            tripleIter = this.model.getGraph().find((TripleMatch)m);
            if (tripleIter.hasNext()) {
                t = (Triple)tripleIter.next();
                this.template = t.getObject().toString(false);
                if (this.template.endsWith(XML_LITERAL)) {
                    this.template = this.template.substring(0, this.template.length() - XML_LITERAL.length());
                }
                if (this.templateInHtml) {
                    this.template = SpdxLicenseTemplateHelper.HtmlToText(this.template);
                }
            } else {
                this.template = null;
            }
        }
        p = this.model.getProperty("http://spdx.org/rdf/terms#", "isOsiApproved").asNode();
        m = Triple.createMatch((Node)licenseNode, (Node)p, null);
        tripleIter = this.model.getGraph().find((TripleMatch)m);
        if (!tripleIter.hasNext()) {
            p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseOsiApproved").asNode();
            m = Triple.createMatch((Node)licenseNode, (Node)p, null);
            tripleIter = this.model.getGraph().find((TripleMatch)m);
        }
        if (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            String osiTextValue = t.getObject().toString(false);
            if (osiTextValue.equals("true") || osiTextValue.equals("1")) {
                this.osiApproved = true;
                return;
            } else {
                if (!osiTextValue.equals("false") && !osiTextValue.equals("0")) throw new InvalidSPDXAnalysisException("Invalid value for OSI Approved - must be {true, false, 0, 1}");
                this.osiApproved = false;
            }
            return;
        } else {
            this.osiApproved = false;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.licenseInfoNode != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "name");
            this.model.removeAll(this.resource, p, null);
            p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseName");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "name");
            this.resource.addProperty(p, this.name);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        if (this.licenseInfoNode != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseText");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseText");
            this.resource.addProperty(p, text);
            this.textInHtml = false;
        }
    }

    public String[] getSourceUrl() {
        return this.sourceUrl;
    }

    public void setSourceUrl(String[] sourceUrl) {
        this.sourceUrl = sourceUrl;
        if (this.licenseInfoNode != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseSourceUrl");
            this.model.removeAll(this.resource, p, null);
            p = this.model.getProperty("http://www.w3.org/2000/01/rdf-schema#", "seeAlso");
            this.model.removeAll(this.resource, p, null);
            p = this.model.getProperty("http://www.w3.org/2000/01/rdf-schema#", "seeAlso");
            for (int i = 0; i < sourceUrl.length; ++i) {
                this.resource.addProperty(p, this.sourceUrl[i]);
            }
        }
    }

    public String getComment() {
        return this.comments;
    }

    @Deprecated
    public String getNotes() {
        return this.getComment();
    }

    @Deprecated
    public void setNotes(String notes) {
        this.setComment(notes);
    }

    public void setComment(String comment) {
        this.comments = comment;
        if (this.licenseInfoNode != null) {
            Property p = this.model.getProperty("http://www.w3.org/2000/01/rdf-schema#", "comment");
            this.model.removeAll(this.resource, p, null);
            p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseNotes");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "comment");
            this.resource.addProperty(p, this.comments);
        }
    }

    public String getStandardLicenseHeader() {
        return this.standardLicenseHeader;
    }

    public void setStandardLicenseHeader(String standardLicenseHeader) {
        this.standardLicenseHeader = standardLicenseHeader;
        if (this.licenseInfoNode != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "standardLicenseHeader");
            this.model.removeAll(this.resource, p, null);
            p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseHeader");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "standardLicenseHeader");
            this.resource.addProperty(p, this.standardLicenseHeader);
        }
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
        if (this.licenseInfoNode != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseTemplate");
            this.model.removeAll(this.resource, p, null);
            p = this.model.getProperty("http://spdx.org/rdf/terms#", "standardLicenseTemplate");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "standardLicenseTemplate");
            this.resource.addProperty(p, this.template);
            this.templateInHtml = false;
        }
    }

    @Override
    public String toString() {
        return this.id;
    }

    @Override
    protected Resource _createResource(Model model) {
        Resource type = model.createResource("http://spdx.org/rdf/terms#License");
        String uri = this.createStdLicenseUri(this.id);
        Resource r = super._createResource(model, type, uri);
        if (this.text != null) {
            Property textProperty = model.createProperty("http://spdx.org/rdf/terms#", "licenseText");
            model.removeAll(r, textProperty, null);
            r.addProperty(textProperty, this.text);
        }
        if (this.name != null) {
            Property namePropery = model.createProperty("http://spdx.org/rdf/terms#", "name");
            r.addProperty(namePropery, this.name);
        }
        if (this.comments != null) {
            Property notesPropery = model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "comment");
            r.addProperty(notesPropery, this.comments);
        }
        if (this.sourceUrl != null && this.sourceUrl.length > 0) {
            Property sourceUrlPropery = model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "seeAlso");
            for (int i = 0; i < this.sourceUrl.length; ++i) {
                r.addProperty(sourceUrlPropery, this.sourceUrl[i]);
            }
        }
        if (this.standardLicenseHeader != null) {
            Property standardLicenseHeaderPropery = model.createProperty("http://spdx.org/rdf/terms#", "standardLicenseHeader");
            r.addProperty(standardLicenseHeaderPropery, this.standardLicenseHeader);
        }
        if (this.template != null) {
            Property templatePropery = model.createProperty("http://spdx.org/rdf/terms#", "standardLicenseTemplate");
            r.addProperty(templatePropery, this.template);
        }
        if (this.osiApproved) {
            Property osiApprovedPropery = model.createProperty("http://spdx.org/rdf/terms#", "isOsiApproved");
            r.addProperty(osiApprovedPropery, String.valueOf(this.osiApproved));
        }
        return r;
    }

    private String createStdLicenseUri(String id) {
        return "http://spdx.org/licenses/" + id;
    }

    @Override
    public int hashCode() {
        if (this.getId() != null) {
            return this.getId().hashCode();
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SPDXStandardLicense)) {
            return false;
        }
        SPDXStandardLicense comp = (SPDXStandardLicense)o;
        if (this.id == null) {
            return comp.getId() == null;
        }
        return this.id.equals(comp.getId());
    }

    @Override
    public ArrayList<String> verify() {
        String name;
        ArrayList<String> retval = new ArrayList<String>();
        String id = this.getId();
        if (id == null || id.isEmpty()) {
            retval.add("Missing required license ID");
        }
        if ((name = this.getName()) == null || name.isEmpty()) {
            retval.add("Missing required license name");
        }
        this.getComment();
        this.getSourceUrl();
        this.getStandardLicenseHeader();
        this.getTemplate();
        String licenseText = this.getText();
        if (licenseText == null || licenseText.isEmpty()) {
            retval.add("Missing required license text for " + id);
        }
        return retval;
    }

    public boolean isOsiApproved() {
        return this.osiApproved;
    }

    public void setOsiApproved(boolean osiApproved) {
        this.osiApproved = osiApproved;
        if (this.licenseInfoNode != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "isOsiApproved");
            this.model.removeAll(this.resource, p, null);
            p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseOsiApproved");
            this.model.removeAll(this.resource, p, null);
            if (this.osiApproved) {
                p = this.model.createProperty("http://spdx.org/rdf/terms#", "isOsiApproved");
                this.resource.addProperty(p, String.valueOf(this.osiApproved));
            }
        }
    }
}

