/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.spdx.rdfparser.IStandardLicenseProvider;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.LicenseCsvException;
import org.spdx.rdfparser.SPDXStandardLicense;

public class SpdxLicenseCsv
implements IStandardLicenseProvider {
    static final Logger logger = Logger.getLogger((String)SpdxLicenseCsv.class.getName());
    public static final int LICENSE_NAME_COL = 0;
    public static final int LICENSE_ID_COL = 1;
    public static final int LICENSE_NOTES_COL = 3;
    public static final int LICENSE_TEXT_COL = 6;
    public static final int LICENSE_URL_COL = 2;
    public static final int LICENSE_TEMPLATE_COL = 7;
    public static final int LICENSE_HEADER_COL = 5;
    public static final int IS_OSI_APPROVED_COL = 4;
    static final char DELIM = ',';
    static final char STRING_DELIM = '\"';
    static final String[] HEADER_ROW = new String[]{"Full name of License", "License Identifier", "Source/url", "Notes", "OSI Approved", "Standard License Header", "Text", "Template"};
    private static final int NUM_COLS = HEADER_ROW.length;
    private File csvFile = null;
    private CSVReader reader = null;
    private ArrayList<CsvLicenseIterator> openIterators = new ArrayList();

    public SpdxLicenseCsv(File csvFile) throws IOException, LicenseCsvException {
        this.csvFile = csvFile;
        this.reader = new CSVReader((Reader)new FileReader(csvFile), ',', '\"');
        String[] header = this.reader.readNext();
        if (header.length != NUM_COLS) {
            throw new LicenseCsvException("Incorrect number of columns for License CSV file.  Expected " + String.valueOf(NUM_COLS) + ", found " + String.valueOf(header.length));
        }
        for (int i = 0; i < header.length; ++i) {
            if (header[i].equals(HEADER_ROW[i])) continue;
            throw new LicenseCsvException("Invalid row header at column " + String.valueOf(i) + ", expected " + HEADER_ROW[i] + ", found " + header[i]);
        }
    }

    @Override
    public Iterator<SPDXStandardLicense> getIterator() throws LicenseCsvException {
        CsvLicenseIterator retval;
        try {
            retval = new CsvLicenseIterator(this.csvFile);
        }
        catch (IOException e) {
            logger.error((Object)("IO Exception getting license iterator: " + e.getMessage()));
            throw new LicenseCsvException("IO Exception getting license iterator: " + e.getMessage());
        }
        catch (LicenseCsvException e) {
            logger.error((Object)("License csv file format error: " + e.getMessage()));
            throw e;
        }
        this.openIterators.add(retval);
        return retval;
    }

    public void close() throws IOException {
        for (int i = 0; i < this.openIterators.size(); ++i) {
            this.openIterators.get(i).close();
        }
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    class CsvLicenseIterator
    implements Iterator<SPDXStandardLicense> {
        private CSVReader iterReader = null;
        SPDXStandardLicense nextStandardLicense = null;

        public CsvLicenseIterator(File csvFile) throws IOException, LicenseCsvException {
            this.iterReader = new CSVReader((Reader)new FileReader(csvFile), ',', '\"');
            String[] tempHeaderRecord = this.iterReader.readNext();
            this.readNextStandardLicense();
        }

        private void readNextStandardLicense() throws IOException, LicenseCsvException {
            String[] nextRow = this.iterReader.readNext();
            if (nextRow == null) {
                this.nextStandardLicense = null;
                return;
            }
            if (nextRow.length != HEADER_ROW.length) {
                this.nextStandardLicense = null;
                throw new LicenseCsvException("Invalid number of columns.  Expected " + String.valueOf(HEADER_ROW.length) + ", found " + String.valueOf(nextRow.length));
            }
            try {
                String licenseUrlsString = nextRow[2];
                String[] licenseUrls = licenseUrlsString.split("\\s");
                for (int i = 0; i < licenseUrls.length; ++i) {
                    licenseUrls[i] = licenseUrls[i].trim();
                }
                this.nextStandardLicense = new SPDXStandardLicense(nextRow[0], nextRow[1], nextRow[6], licenseUrls, nextRow[3], nextRow[5], nextRow[7], this.isTrue(nextRow[4]));
            }
            catch (InvalidSPDXAnalysisException e) {
                this.nextStandardLicense = null;
                throw new LicenseCsvException("Error creating standard license: " + e.getMessage(), e);
            }
        }

        private boolean isTrue(String string) {
            if (string == null || string.isEmpty()) {
                return false;
            }
            return string.toUpperCase().equals("Y") || string.toUpperCase().equals("YES");
        }

        @Override
        public boolean hasNext() {
            return this.nextStandardLicense != null;
        }

        @Override
        public SPDXStandardLicense next() {
            SPDXStandardLicense retval = this.nextStandardLicense;
            if (retval != null) {
                try {
                    this.readNextStandardLicense();
                }
                catch (IOException e) {
                    logger.error((Object)("IO Exception getting next record: " + e.getMessage()));
                }
                catch (LicenseCsvException e) {
                    logger.error((Object)("License csv file format error getting next record: " + e.getMessage()));
                }
            }
            return retval;
        }

        @Override
        public void remove() {
        }

        public void close() {
            if (this.iterReader != null) {
                try {
                    this.iterReader.close();
                    this.iterReader = null;
                }
                catch (IOException e) {
                    logger.error((Object)("IO error closing CSV reader: " + e.getMessage()));
                }
            }
        }
    }
}

