/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxVerificationHelper;

public class SpdxPackageVerificationCode {
    private String value;
    private ArrayList<String> excludedFileNames = new ArrayList();
    private Model model;
    private Node verificationCodeNode;
    private Resource verificationCodeResource;

    public SpdxPackageVerificationCode(String value, String[] excludedFileNames) {
        this.value = value;
        for (int i = 0; i < excludedFileNames.length; ++i) {
            this.excludedFileNames.add(excludedFileNames[i]);
        }
        this.model = null;
        this.verificationCodeNode = null;
        this.verificationCodeResource = null;
    }

    public SpdxPackageVerificationCode(Model model, Node verificationCodeNode) throws InvalidSPDXAnalysisException {
        Triple t;
        this.model = model;
        this.verificationCodeNode = verificationCodeNode;
        if (verificationCodeNode.isBlank()) {
            this.verificationCodeResource = model.createResource(verificationCodeNode.getBlankNodeId());
        } else if (verificationCodeNode.isURI()) {
            this.verificationCodeResource = model.createResource(verificationCodeNode.getURI());
        } else {
            throw new InvalidSPDXAnalysisException("Verification code node can not be a literal");
        }
        Node p = model.getProperty("http://spdx.org/rdf/terms#", "packageVerificationCodeExcludedFile").asNode();
        Triple m = Triple.createMatch((Node)verificationCodeNode, (Node)p, null);
        ExtendedIterator tripleIter = model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.excludedFileNames.add(t.getObject().toString(false));
        }
        p = model.getProperty("http://spdx.org/rdf/terms#", "packageVerificationCodeValue").asNode();
        m = Triple.createMatch((Node)verificationCodeNode, (Node)p, null);
        tripleIter = model.getGraph().find((TripleMatch)m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.value = t.getObject().toString(false);
        }
    }

    public Resource createResource(Model model) {
        this.model = model;
        Resource type = model.createResource("http://spdx.org/rdf/terms#PackageVerificationCode");
        Resource r = model.createResource(type);
        if (this.excludedFileNames.size() > 0) {
            Property excludedFileProp = model.createProperty("http://spdx.org/rdf/terms#", "packageVerificationCodeExcludedFile");
            for (int i = 0; i < this.excludedFileNames.size(); ++i) {
                r.addProperty(excludedFileProp, this.excludedFileNames.get(i));
            }
        }
        if (this.value != null && !this.value.isEmpty()) {
            Property valueProperty = model.createProperty("http://spdx.org/rdf/terms#", "packageVerificationCodeValue");
            r.addProperty(valueProperty, this.value);
        }
        this.verificationCodeNode = r.asNode();
        this.verificationCodeResource = r;
        return r;
    }

    public String[] getExcludedFileNames() {
        String[] retval = this.excludedFileNames.toArray(new String[this.excludedFileNames.size()]);
        return retval;
    }

    public void setExcludedFileNames(String[] excludedFileNames) {
        this.excludedFileNames.clear();
        if (this.verificationCodeNode != null && this.model != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "packageVerificationCodeExcludedFile");
            this.model.removeAll(this.verificationCodeResource, p, null);
        }
        for (int i = 0; i < excludedFileNames.length; ++i) {
            this.addExcludedFileName(excludedFileNames[i]);
        }
    }

    public void addExcludedFileName(String excludedFileName) {
        this.excludedFileNames.add(excludedFileName);
        if (this.verificationCodeNode != null && this.model != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "packageVerificationCodeExcludedFile");
            this.verificationCodeResource.addProperty(p, excludedFileName);
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        if (this.model != null && this.verificationCodeNode != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "packageVerificationCodeValue");
            this.model.removeAll(this.verificationCodeResource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "packageVerificationCodeValue");
            this.verificationCodeResource.addProperty(p, value);
        }
    }

    public ArrayList<String> verify() {
        ArrayList<String> retval = new ArrayList<String>();
        String value = this.getValue();
        if (value == null || value.isEmpty()) {
            retval.add("Missing required verification code value");
        } else {
            String verify = SpdxVerificationHelper.verifyChecksumString(value);
            if (verify != null) {
                retval.add(verify);
            }
        }
        return retval;
    }
}

