/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import com.hp.hpl.jena.iri.IRIFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.regex.Pattern;
import org.spdx.rdfparser.SPDXFile;

public class SpdxVerificationHelper {
    static IRIFactory iriFactory = IRIFactory.semanticWebImplementation();
    static final String[] VALID_CREATOR_PREFIXES = new String[]{"Person:", "Organization:", "Tool:"};
    static final String[] VALID_ORIGINATOR_SUPPLIER_PREFIXES = new String[]{"NOASSERTION", "Person:", "Organization:"};
    static final Pattern NON_STANDARD_LICENSE_PATTERN = Pattern.compile("LicenseRef-[-+_.a-zA-Z0-9]+");

    public static String verifyNonStdLicenseid(String licenseId) {
        if (NON_STANDARD_LICENSE_PATTERN.matcher(licenseId).matches()) {
            return null;
        }
        return "Invalid license id '" + licenseId + "'.  Must start with 'LicenseRef-' " + "and made up of the characters from the set 'a'-'z', 'A'-'Z', '0'-'9', '+', '_', '.', and '-'.";
    }

    static String verifyChecksumString(String checksum) {
        if (checksum.length() != 40) {
            return "Invalid number of characters for checksum";
        }
        for (int i = 0; i < checksum.length(); ++i) {
            char c = checksum.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return "Invalid checksum string character at position " + String.valueOf(i);
        }
        return null;
    }

    public static String verifyFileType(String fileType) {
        if (!SPDXFile.FILE_TYPE_TO_RESOURCE.containsKey(fileType)) {
            return "Unrecognized file type";
        }
        return null;
    }

    public static String verifyCreator(String creator) {
        boolean ok = false;
        for (int i = 0; i < VALID_CREATOR_PREFIXES.length; ++i) {
            if (!creator.startsWith(VALID_CREATOR_PREFIXES[i])) continue;
            ok = true;
            break;
        }
        if (!ok) {
            StringBuilder sb = new StringBuilder("Creator does not start with one of ");
            sb.append(VALID_CREATOR_PREFIXES[0]);
            for (int i = 1; i < VALID_CREATOR_PREFIXES.length; ++i) {
                sb.append(", ");
                sb.append(VALID_CREATOR_PREFIXES[i]);
            }
            return sb.toString();
        }
        return null;
    }

    public static String verifyOriginator(String originator) {
        return SpdxVerificationHelper.verifyOriginatorOrSupplier(originator);
    }

    public static String verifySupplier(String supplier) {
        return SpdxVerificationHelper.verifyOriginatorOrSupplier(supplier);
    }

    private static String verifyOriginatorOrSupplier(String originatorOrSupplier) {
        boolean ok = false;
        for (int i = 0; i < VALID_ORIGINATOR_SUPPLIER_PREFIXES.length; ++i) {
            if (!originatorOrSupplier.startsWith(VALID_ORIGINATOR_SUPPLIER_PREFIXES[i])) continue;
            ok = true;
            break;
        }
        if (!ok) {
            StringBuilder sb = new StringBuilder("Value must start with one of ");
            sb.append(VALID_ORIGINATOR_SUPPLIER_PREFIXES[0]);
            for (int i = 1; i < VALID_ORIGINATOR_SUPPLIER_PREFIXES.length; ++i) {
                sb.append(", ");
                sb.append(VALID_ORIGINATOR_SUPPLIER_PREFIXES[i]);
            }
            return sb.toString();
        }
        return null;
    }

    public static String verifyDate(String creationDate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        try {
            format.parse(creationDate);
        }
        catch (ParseException e) {
            return "Invalid date format: " + e.getMessage();
        }
        return null;
    }

    public static String verifyReviewer(String reviewer) {
        if (!(reviewer.startsWith("Person:") || reviewer.startsWith("Tool:") || reviewer.startsWith("Organization:"))) {
            return "Reviewer does not start with Person:, Organization:, or Tool:";
        }
        return null;
    }

    public static boolean isValidUri(String uri) {
        return !iriFactory.create(uri).hasViolation(false);
    }
}

