/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class AbstractSheet {
    static final String FONT_NAME = "Arial";
    protected static final short FONT_SIZE = 200;
    static final String CHECKBOX_FONT_NAME = "Wingdings 2";
    static final String CHECKBOX = "P";
    private static final short MAX_ROW_LINES = 10;
    protected CellStyle checkboxStyle;
    protected CellStyle dateStyle;
    protected CellStyle greenWrapped;
    protected CellStyle redWrapped;
    protected CellStyle yellowWrapped;
    protected Sheet sheet;
    protected int lastRowNum;
    protected int firstCellNum;
    protected int firstRowNum;

    public AbstractSheet(Workbook workbook, String sheetName) {
        this.sheet = workbook.getSheet(sheetName);
        if (this.sheet != null) {
            this.firstRowNum = this.sheet.getFirstRowNum();
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            this.firstCellNum = firstRow == null ? 1 : (int)firstRow.getFirstCellNum();
            this.findLastRow();
        } else {
            this.firstRowNum = 0;
            this.lastRowNum = 0;
            this.firstCellNum = 0;
        }
        this.createStyles(workbook);
    }

    private void createStyles(Workbook wb) {
        this.checkboxStyle = wb.createCellStyle();
        this.checkboxStyle.setAlignment((short)2);
        this.checkboxStyle.setVerticalAlignment((short)1);
        this.checkboxStyle.setBorderBottom((short)1);
        this.checkboxStyle.setBorderLeft((short)1);
        this.checkboxStyle.setBorderRight((short)1);
        this.checkboxStyle.setBorderTop((short)1);
        org.apache.poi.ss.usermodel.Font checkboxFont = wb.createFont();
        checkboxFont.setFontHeight((short)200);
        checkboxFont.setFontName(CHECKBOX_FONT_NAME);
        this.checkboxStyle.setFont(checkboxFont);
        this.dateStyle = wb.createCellStyle();
        DataFormat df = wb.createDataFormat();
        this.dateStyle.setDataFormat(df.getFormat("m/d/yy h:mm"));
        this.greenWrapped = AbstractSheet.createLeftWrapStyle(wb);
        this.greenWrapped.setFillForegroundColor((short)42);
        this.greenWrapped.setFillPattern((short)1);
        this.greenWrapped.setFillPattern((short)1);
        this.yellowWrapped = AbstractSheet.createLeftWrapStyle(wb);
        this.yellowWrapped.setFillForegroundColor((short)43);
        this.yellowWrapped.setFillPattern((short)1);
        this.redWrapped = AbstractSheet.createLeftWrapStyle(wb);
        this.redWrapped.setFillForegroundColor((short)10);
        this.redWrapped.setFillPattern((short)1);
    }

    private void findLastRow() {
        boolean done = false;
        this.lastRowNum = this.firstRowNum + 1;
        try {
            while (!done) {
                Row row = this.sheet.getRow(this.lastRowNum);
                if (row == null || row.getCell(this.firstCellNum) == null || row.getCell(this.firstCellNum).getStringCellValue() == null || row.getCell(this.firstCellNum).getStringCellValue().isEmpty()) {
                    --this.lastRowNum;
                    done = true;
                    continue;
                }
                ++this.lastRowNum;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Row addRow() {
        ++this.lastRowNum;
        Row row = this.sheet.createRow(this.lastRowNum);
        return row;
    }

    public void clear() {
        for (int i = this.lastRowNum; i > this.firstRowNum; --i) {
            Row row = this.sheet.getRow(i);
            this.sheet.removeRow(row);
        }
        this.lastRowNum = this.firstRowNum;
    }

    public int getFirstDataRow() {
        return this.firstRowNum + 1;
    }

    public int getNumDataRows() {
        return this.lastRowNum - this.firstRowNum;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public abstract String verify();

    public static CellStyle createHeaderStyle(Workbook wb) {
        CellStyle headerStyle = wb.createCellStyle();
        headerStyle.setFillForegroundColor((short)22);
        headerStyle.setFillPattern((short)1);
        org.apache.poi.ss.usermodel.Font headerFont = wb.createFont();
        headerFont.setFontName(FONT_NAME);
        headerFont.setFontHeight((short)200);
        headerFont.setBoldweight((short)700);
        headerStyle.setFont(headerFont);
        headerStyle.setAlignment((short)2);
        headerStyle.setVerticalAlignment((short)1);
        headerStyle.setWrapText(true);
        return headerStyle;
    }

    public static CellStyle createLeftWrapStyle(Workbook wb) {
        CellStyle wrapStyle = wb.createCellStyle();
        wrapStyle.setWrapText(true);
        wrapStyle.setAlignment((short)1);
        wrapStyle.setVerticalAlignment((short)1);
        return wrapStyle;
    }

    public static CellStyle createCenterStyle(Workbook wb) {
        CellStyle centerStyle = wb.createCellStyle();
        centerStyle.setWrapText(false);
        centerStyle.setAlignment((short)2);
        return centerStyle;
    }

    public void resizeRows() {
        int lastRow = this.getNumDataRows() + this.getFirstDataRow() - 1;
        for (int i = 0; i <= lastRow; ++i) {
            Row row = this.sheet.getRow(i);
            int lastCell = row.getLastCellNum();
            int maxNumLines = 1;
            for (int j = 0; j < lastCell; ++j) {
                int cellLines;
                Cell cell = row.getCell(j);
                if (cell == null || (cellLines = this.getNumWrappedLines(cell)) <= maxNumLines) continue;
                maxNumLines = cellLines;
            }
            if (maxNumLines > 10) {
                maxNumLines = 10;
            }
            if (maxNumLines <= 1) continue;
            row.setHeight((short)(this.sheet.getDefaultRowHeight() * maxNumLines));
        }
    }

    private int getNumWrappedLines(Cell cell) {
        String val = cell.getStringCellValue();
        if (val == null || val.isEmpty()) {
            return 1;
        }
        CellStyle style = cell.getCellStyle();
        if (style == null || !style.getWrapText()) {
            return 1;
        }
        org.apache.poi.ss.usermodel.Font font = this.sheet.getWorkbook().getFontAt(style.getFontIndex());
        AttributedString astr = new AttributedString(val);
        Font awtFont = new Font(font.getFontName(), 0, font.getFontHeightInPoints());
        float cellWidth = (float)(this.sheet.getColumnWidth(cell.getColumnIndex()) / 256) * 5.5f;
        astr.addAttribute(TextAttribute.FONT, awtFont);
        FontRenderContext context = new FontRenderContext(null, true, true);
        LineBreakMeasurer measurer = new LineBreakMeasurer(astr.getIterator(), context);
        int pos = 0;
        int numLines = 0;
        while (measurer.getPosition() < val.length()) {
            pos = measurer.nextOffset(cellWidth);
            ++numLines;
            measurer.setPosition(pos);
        }
        return numLines;
    }
}

