/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public abstract class AbstractSpreadsheet {
    protected static final Logger logger = Logger.getLogger((String)AbstractSpreadsheet.class.getName());
    protected File saveFile;
    protected Workbook workbook;
    private boolean readonly;

    public AbstractSpreadsheet(File spreadsheetFile, boolean create, boolean readonly) throws SpreadsheetException {
        this.readonly = readonly;
        if (readonly && create) {
            throw new SpreadsheetException("Can not create a readonly spreadsheet");
        }
        if (!spreadsheetFile.exists()) {
            if (!create) {
                throw new SpreadsheetException("File " + spreadsheetFile.getName() + " does not exist");
            }
            try {
                this.create(spreadsheetFile);
            }
            catch (IOException ex) {
                logger.error((Object)("IO error creating spreadsheet: " + ex.getMessage()));
                throw new SpreadsheetException("I/O error creating spreadsheet");
            }
        }
        this.saveFile = spreadsheetFile;
        FileInputStream input = null;
        try {
            input = new FileInputStream(spreadsheetFile);
            this.workbook = WorkbookFactory.create((InputStream)input);
        }
        catch (FileNotFoundException ex) {
            logger.error((Object)("Can not open Excel file.  File " + spreadsheetFile.getName() + " does not exist"));
            throw new SpreadsheetException("Can not open Excel file.  File " + spreadsheetFile.getName() + " does not exist");
        }
        catch (InvalidFormatException ex) {
            logger.error((Object)("Unable to open workbook.  Invalid format: " + ex.getMessage()));
            throw new SpreadsheetException("Unable to open workbook.  Invalid format");
        }
        catch (IOException ex) {
            logger.error((Object)("IO Exception opening excel workbook: " + ex.getMessage()));
            throw new SpreadsheetException("IO Exception opening excel workbook.  See log for more detail.");
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException ex) {
                    logger.warn((Object)("IO Error closing excel file: " + ex.getMessage()));
                }
            }
        }
    }

    public abstract void create(File var1) throws IOException, SpreadsheetException;

    public abstract void clear();

    public abstract String verifyWorkbook();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File file) throws IOException {
        if (this.readonly) {
            return;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            this.workbook.write((OutputStream)out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public void close() throws SpreadsheetException {
        try {
            this.writeToFile(this.saveFile);
        }
        catch (IOException ex) {
            logger.error((Object)("Error writing excel sheet to file: " + ex.getMessage()));
            throw new SpreadsheetException("Error writing excel workbook to file, see log for details.");
        }
    }
}

