/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFHyperlink;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.licenseTemplate.LicenseTemplateRuleException;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXStandardLicense;
import org.spdx.spdxspreadsheet.AbstractSheet;

public class LicenseSheet
extends AbstractSheet {
    static final Logger logger = Logger.getLogger((String)LicenseSheet.class.getName());
    static final int NUM_COLS = 9;
    static final int COL_NAME = 0;
    static final int COL_ID = 1;
    static final int COL_SOURCE_URL = 2;
    static final int COL_NOTES = 3;
    static final int COL_OSI_APPROVED = 4;
    static final int COL_STANDARD_LICENSE_HEADER = 5;
    static final int COL_TEMPLATE = 6;
    static final int COL_VERSION = 7;
    static final int COL_RELEASE_DATE = 8;
    static final SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy");
    static final boolean[] REQUIRED = new boolean[]{true, true, false, false, false, false, true, false, false, false};
    static final String[] HEADER_TITLES = new String[]{"Full name of License", "License Identifier", "Source/url", "Notes", "OSI Approved", "Standard License Header", "Template", "License List Version", "License List Release Date"};
    static final String TEXT_EXTENSION = ".txt";
    static final String ENCODING = "UTF-8";
    String workbookPath;
    String version = null;
    String releaseDate = null;

    public LicenseSheet(Workbook workbook, String sheetName, File workbookFile) {
        super(workbook, sheetName);
        this.workbookPath = workbookFile.getParent();
        Row firstDataRow = this.sheet.getRow(this.firstRowNum + 1);
        if (firstDataRow != null) {
            Cell releaseDateCell;
            Cell versionCell = firstDataRow.getCell(7);
            if (versionCell != null) {
                if (versionCell.getCellType() == 1) {
                    this.version = versionCell.getStringCellValue();
                } else if (versionCell.getCellType() == 0) {
                    this.version = String.valueOf(versionCell.getNumericCellValue());
                }
            }
            if ((releaseDateCell = firstDataRow.getCell(8)) != null) {
                if (releaseDateCell.getCellType() == 1) {
                    this.releaseDate = releaseDateCell.getStringCellValue();
                } else if (releaseDateCell.getCellType() == 0) {
                    this.releaseDate = dateFormat.format(releaseDateCell.getDateCellValue());
                }
            }
        }
    }

    public static void create(Workbook wb, String sheetName, String version, String releaseDate) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        Row row = sheet.createRow(0);
        for (int i = 0; i < HEADER_TITLES.length; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(HEADER_TITLES[i]);
        }
        Row firstDataRow = sheet.createRow(1);
        Cell versionCell = firstDataRow.createCell(7);
        versionCell.setCellValue(version);
        Cell releaseDateCell = firstDataRow.createCell(8);
        releaseDateCell.setCellValue(releaseDate);
    }

    public String getVersion() {
        return this.version;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public void add(SPDXStandardLicense license) {
        Row row = this.addRow();
        Cell nameCell = row.createCell(0);
        nameCell.setCellValue(license.getName());
        Cell idCell = row.createCell(1);
        idCell.setCellValue(license.getId());
        if (license.getSourceUrl() != null && license.getSourceUrl().length > 0) {
            Cell sourceUrlCell = row.createCell(2);
            StringBuilder sb = new StringBuilder();
            sb.append(license.getSourceUrl()[0]);
            for (int i = 1; i < license.getSourceUrl().length; ++i) {
                sb.append(' ');
                sb.append(license.getSourceUrl()[i]);
            }
            sourceUrlCell.setCellValue(sb.toString());
        }
        if (license.getComment() != null) {
            Cell notesCell = row.createCell(3);
            notesCell.setCellValue(license.getComment());
        }
        if (license.getStandardLicenseHeader() != null) {
            Cell standardLicenseHeaderCell = row.createCell(5);
            standardLicenseHeaderCell.setCellValue(license.getStandardLicenseHeader());
        }
        Cell templateCell = row.createCell(6);
        String templateText = license.getTemplate();
        if (templateText == null || templateText.trim().isEmpty()) {
            templateText = license.getText();
        }
        this.setTemplateText(templateCell, license.getTemplate(), license.getId());
        if (license.isOsiApproved()) {
            Cell osiApprovedCell = row.createCell(4);
            osiApprovedCell.setCellValue("YES");
        }
        if (row.getRowNum() == this.firstRowNum + 1) {
            Cell versionCell = row.createCell(7);
            versionCell.setCellValue(this.version);
            Cell releaseDateCell = row.createCell(8);
            releaseDateCell.setCellValue(this.releaseDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTemplateText(Cell textCell, String text, String licenseId) {
        String licenseFileName = licenseId + TEXT_EXTENSION;
        File licenseTextFile = new File(this.workbookPath + File.separator + licenseFileName);
        try {
            if (!licenseTextFile.createNewFile()) {
                logger.warn((Object)("Unable to create license text file " + licenseTextFile.getName()));
                textCell.setCellValue(text);
                return;
            }
        }
        catch (IOException e) {
            logger.warn((Object)("IO Error creating license text file: " + e.getMessage()));
            textCell.setCellValue(text);
            return;
        }
        if (!licenseTextFile.canWrite()) {
            logger.warn((Object)("Can not write to text file " + licenseTextFile.getName()));
            textCell.setCellValue(text);
            return;
        }
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(licenseTextFile), ENCODING);
            try {
                out.write(text);
                textCell.setCellValue(licenseFileName);
                HSSFHyperlink hyperlink = new HSSFHyperlink(4);
                hyperlink.setAddress(licenseFileName);
                textCell.setHyperlink((Hyperlink)hyperlink);
            }
            finally {
                ((Writer)out).close();
            }
        }
        catch (IOException e) {
            logger.warn((Object)("Unable to open text file for output: " + e.getMessage()));
            textCell.setCellValue(text);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLicenseTemplateText(Cell textCell) {
        String localFileName = null;
        File licenseTemplateTextFile = null;
        Hyperlink cellHyperlink = textCell.getHyperlink();
        if (cellHyperlink != null && cellHyperlink.getAddress() != null) {
            localFileName = cellHyperlink.getAddress();
            licenseTemplateTextFile = new File(this.workbookPath + File.separator + localFileName);
            if (!licenseTemplateTextFile.exists()) {
                licenseTemplateTextFile = new File(localFileName);
            }
            if (!licenseTemplateTextFile.exists()) {
                licenseTemplateTextFile = null;
            }
        }
        if (licenseTemplateTextFile == null && textCell.getStringCellValue() != null && textCell.getStringCellValue().toUpperCase().endsWith(".TXT")) {
            localFileName = textCell.getStringCellValue();
            licenseTemplateTextFile = new File(this.workbookPath + File.separator + localFileName);
        }
        if (localFileName != null) {
            String string;
            if (!licenseTemplateTextFile.exists()) {
                logger.warn((Object)("Can not find linked license text file " + licenseTemplateTextFile.getName()));
                return "WARNING: Could not find license text file " + licenseTemplateTextFile.getName();
            }
            if (!licenseTemplateTextFile.canRead()) {
                logger.warn((Object)("Can not read linked license text file " + licenseTemplateTextFile.getName()));
                return "WARNING: Could not read license text file " + licenseTemplateTextFile.getName();
            }
            FileInputStream in = new FileInputStream(licenseTemplateTextFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, ENCODING));
            try {
                StringBuilder sb = new StringBuilder();
                String line = null;
                String newLine = System.getProperty("line.separator");
                line = reader.readLine();
                if (line != null) {
                    sb.append(line);
                }
                while ((line = reader.readLine()) != null) {
                    sb.append(newLine);
                    sb.append(line);
                }
                string = sb.toString();
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e) {
                    logger.warn((Object)("Error reading linked license template text file " + licenseTemplateTextFile.getName() + ": " + e.getMessage()));
                    return "WARNING: Error reading license template text file " + licenseTemplateTextFile.getName();
                }
            }
            reader.close();
            return string;
        }
        return textCell.getStringCellValue();
    }

    public SPDXStandardLicense getLicense(int rowNum) throws InvalidSPDXAnalysisException {
        String osiApprovedStr;
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        String id = null;
        Cell idCell = row.getCell(1);
        if (idCell != null) {
            id = idCell.getStringCellValue();
        }
        String name = null;
        Cell nameCell = row.getCell(0);
        if (nameCell != null) {
            name = nameCell.getStringCellValue();
        }
        String notes = null;
        Cell notesCell = row.getCell(3);
        if (notesCell != null) {
            notes = notesCell.getStringCellValue();
        }
        String[] sourceURL = null;
        Cell sourceURLCell = row.getCell(2);
        if (sourceURLCell != null) {
            try {
                String stSourceURL = sourceURLCell.getStringCellValue();
                sourceURL = stSourceURL.split("\\s");
                for (int i = 0; i < sourceURL.length; ++i) {
                    sourceURL[i] = sourceURL[i].trim();
                }
            }
            catch (Exception ex) {
                sourceURL = new String[]{"Exception getting URL: " + ex.getMessage()};
            }
        }
        String stdLicHeader = null;
        Cell stdLicHeaderCell = row.getCell(5);
        if (stdLicHeaderCell != null) {
            stdLicHeader = stdLicHeaderCell.getStringCellValue();
        }
        String template = null;
        String text = null;
        Cell templateCell = row.getCell(6);
        if (templateCell != null) {
            template = this.getLicenseTemplateText(templateCell);
            try {
                text = this.convertTemplateToText(template);
            }
            catch (LicenseTemplateRuleException e) {
                throw new InvalidSPDXAnalysisException("Invalid template for " + id + ": " + e.getMessage(), e);
            }
        }
        boolean osiApproved = false;
        Cell osiApprovedCell = row.getCell(4);
        if (osiApprovedCell != null && (osiApprovedStr = osiApprovedCell.getStringCellValue()) != null && !osiApprovedStr.isEmpty() && osiApprovedStr.toUpperCase().trim().charAt(0) == 'Y') {
            osiApproved = true;
        }
        return new SPDXStandardLicense(name, id, text, sourceURL, notes, stdLicHeader, template, osiApproved);
    }

    private String convertTemplateToText(String template) throws LicenseTemplateRuleException {
        return SpdxLicenseTemplateHelper.templateToText(template);
    }

    @Override
    public String verify() {
        try {
            if (this.sheet == null) {
                return "Worksheet for SPDX Licenses does not exist";
            }
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            for (int i = 0; i < 9; ++i) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell != null && cell.getStringCellValue() != null && cell.getStringCellValue().equals(HEADER_TITLES[i])) continue;
                return "Column " + HEADER_TITLES[i] + " missing for SPDX Licenses worksheet";
            }
            Row firstDataRow = this.sheet.getRow(this.firstRowNum + 1);
            Cell versionCell = firstDataRow.getCell(7);
            if (versionCell == null) {
                return "No version";
            }
            Cell releaseDateCell = firstDataRow.getCell(8);
            if (releaseDateCell == null) {
                return "No release date";
            }
            boolean done = false;
            int rowNum = this.firstRowNum + 1;
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(this.firstCellNum) == null) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying SPDX License work sheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        for (int i = 0; i < 9; ++i) {
            Cell cell = row.getCell(i);
            if (cell != null || !REQUIRED[i]) continue;
            return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum());
        }
        return null;
    }
}

