/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.spdxspreadsheet.AbstractSheet;
import org.spdx.spdxspreadsheet.OriginsSheet;
import org.spdx.spdxspreadsheet.SPDXSpreadsheet;

public class OriginsSheetV0d9d4
extends OriginsSheet {
    static final int NUM_COLS = 6;
    static final int SPREADSHEET_VERSION_COL = 0;
    static final int SPDX_VERSION_COL = 1;
    static final int CREATED_BY_COL = 2;
    static final int CREATED_COL = 3;
    static final int DATA_LICENSE_COL = 4;
    static final int AUTHOR_COMMENTS_COL = 5;
    static final int DATA_ROW_NUM = 1;
    static final boolean[] REQUIRED = new boolean[]{true, true, true, true, true, true, false, false};
    static final String[] HEADER_TITLES = new String[]{"Spreadsheet Version", "SPDX Version", "Creator", "Created", "Data License", "Creator Comment"};
    static final int[] COLUMN_WIDTHS = new int[]{20, 20, 30, 16, 40, 70};
    static final boolean[] LEFT_WRAP = new boolean[]{false, false, true, false, true, true};
    static final boolean[] CENTER_NOWRAP = new boolean[]{true, true, false, true, false, false};

    public OriginsSheetV0d9d4(Workbook workbook, String sheetName, String version) {
        super(workbook, sheetName, version);
    }

    @Override
    public String verify() {
        try {
            if (this.sheet == null) {
                return "Worksheet for SPDX Origins does not exist";
            }
            this.version = this.getDataCellStringValue(0);
            if (this.version == null) {
                return "Invalid origins spreadsheet - no spreadsheet version found";
            }
            if (!SPDXSpreadsheet.verifyVersion(this.version)) {
                return "Spreadsheet version " + this.version + " not supported.";
            }
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            for (int i = 0; i < 6; ++i) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell != null && cell.getStringCellValue() != null && cell.getStringCellValue().equals(HEADER_TITLES[i])) continue;
                return "Column " + HEADER_TITLES[i] + " missing for SPDX Origins worksheet";
            }
            boolean done = false;
            int rowNum = this.firstRowNum + 1;
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(1) == null) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying SPDX Origins work sheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        for (int i = 0; i < 6; ++i) {
            Cell cell = row.getCell(i);
            if (cell == null) {
                if (!REQUIRED[i]) continue;
                return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum() + " in Origins Spreadsheet");
            }
            if (i != 3 || cell.getCellType() == 0) continue;
            return "Created column in origin spreadsheet is not of type Date";
        }
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle centerStyle = AbstractSheet.createCenterStyle(wb);
        CellStyle wrapStyle = AbstractSheet.createLeftWrapStyle(wb);
        Sheet sheet = wb.createSheet(sheetName);
        Row row = sheet.createRow(0);
        for (int i = 0; i < HEADER_TITLES.length; ++i) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            if (LEFT_WRAP[i]) {
                sheet.setDefaultColumnStyle(i, wrapStyle);
            } else if (CENTER_NOWRAP[i]) {
                sheet.setDefaultColumnStyle(i, centerStyle);
            }
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
        }
        Row dataRow = sheet.createRow(1);
        Cell ssVersionCell = dataRow.createCell(0);
        ssVersionCell.setCellValue("1.2.0");
    }

    @Override
    public void setAuthorComments(String comments) {
        this.setDataCellStringValue(5, comments);
    }

    public void setCreatedBy(String createdBy) {
        this.setDataCellStringValue(2, createdBy);
    }

    @Override
    public void setDataLicense(String dataLicense) {
        this.setDataCellStringValue(4, dataLicense);
    }

    @Override
    public void setSPDXVersion(String version) {
        this.setDataCellStringValue(1, version);
    }

    public void setSpreadsheetVersion(String version) {
        this.setDataCellStringValue(0, version);
    }

    @Override
    public String getAuthorComments() {
        return this.getDataCellStringValue(5);
    }

    @Override
    public Date getCreated() {
        return this.getDataCellDateValue(3);
    }

    @Override
    public String getDataLicense() {
        return this.getDataCellStringValue(4);
    }

    @Override
    public String getSPDXVersion() {
        return this.getDataCellStringValue(1);
    }

    public String getSpreadsheetVersion() {
        return this.getDataCellStringValue(0);
    }

    @Override
    public void setCreatedBy(String[] createdBy) {
        if (createdBy == null || createdBy.length < 1) {
            this.setDataCellStringValue(2, "");
            int i = this.firstRowNum + 1 + 1;
            Row nextRow = this.sheet.getRow(i);
            while (nextRow != null) {
                Cell createdByCell = nextRow.getCell(2);
                if (createdByCell != null) {
                    createdByCell.setCellValue("");
                }
                nextRow = this.sheet.getRow(++i);
            }
            return;
        }
        this.setDataCellStringValue(2, createdBy[0]);
        for (int i = 1; i < createdBy.length; ++i) {
            Cell cell;
            Row row = this.sheet.getRow(this.firstRowNum + 1 + i);
            if (row == null) {
                row = this.sheet.createRow(this.firstRowNum + 1 + i);
            }
            if ((cell = row.getCell(2)) == null) {
                cell = row.createCell(2);
            }
            cell.setCellValue(createdBy[i]);
        }
    }

    @Override
    public String[] getCreatedBy() {
        int numRows = 0;
        while (this.sheet.getRow(this.firstRowNum + 1 + numRows) != null && this.sheet.getRow(this.firstRowNum + 1 + numRows).getCell(2) != null && !this.sheet.getRow(this.firstRowNum + 1 + numRows).getCell(2).getStringCellValue().isEmpty()) {
            ++numRows;
        }
        String[] retval = new String[numRows];
        for (int i = 0; i < numRows; ++i) {
            retval[i] = this.sheet.getRow(this.firstRowNum + 1 + i).getCell(2).getStringCellValue();
        }
        return retval;
    }

    @Override
    public void setCreated(Date created) {
        this.setDataCellDateValue(3, created);
    }

    @Override
    public String getDocumentComment() {
        return null;
    }

    @Override
    public void setDocumentComment(String docComment) {
    }

    @Override
    public String getLicenseListVersion() {
        return null;
    }

    @Override
    public void setLicenseListVersion(String licenseVersion) {
    }
}

