/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.rdfparser.SPDXLicenseInfo;
import org.spdx.rdfparser.SPDXPackageInfo;
import org.spdx.spdxspreadsheet.AbstractSheet;
import org.spdx.spdxspreadsheet.PackageInfoSheetV09d2;
import org.spdx.spdxspreadsheet.PackageInfoSheetV09d3;
import org.spdx.spdxspreadsheet.PackageInfoSheetV1d2;
import org.spdx.spdxspreadsheet.PackageInfoSheetV9d1;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public abstract class PackageInfoSheet
extends AbstractSheet {
    protected String version;

    public PackageInfoSheet(Workbook workbook, String sheetName, String version) {
        super(workbook, sheetName);
        this.version = version;
    }

    public abstract void add(SPDXPackageInfo var1);

    public abstract SPDXPackageInfo getPackageInfo(int var1) throws SpreadsheetException;

    public static String licensesToString(SPDXLicenseInfo[] licenses) {
        if (licenses == null || licenses.length == 0) {
            return "";
        }
        if (licenses.length == 1) {
            return licenses[0].toString();
        }
        StringBuilder sb = new StringBuilder(licenses[0].toString());
        for (int i = 1; i < licenses.length; ++i) {
            sb.append(", ");
            sb.append(licenses[i].toString());
        }
        return sb.toString();
    }

    public static void create(Workbook wb, String sheetName) {
        PackageInfoSheetV1d2.create(wb, sheetName);
    }

    public static PackageInfoSheet openVersion(Workbook workbook, String packageInfoSheetName, String version) {
        if (version.compareTo("0.9.1") <= 0) {
            return new PackageInfoSheetV9d1(workbook, packageInfoSheetName, version);
        }
        if (version.compareTo("0.9.2") <= 0) {
            return new PackageInfoSheetV09d2(workbook, packageInfoSheetName, version);
        }
        if (version.compareTo("1.1.0") <= 0) {
            return new PackageInfoSheetV09d3(workbook, packageInfoSheetName, version);
        }
        return new PackageInfoSheetV1d2(workbook, packageInfoSheetName, version);
    }
}

