/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.rdfparser.SPDXFile;
import org.spdx.spdxspreadsheet.AbstractSheet;
import org.spdx.spdxspreadsheet.PerFileSheetV09d3;
import org.spdx.spdxspreadsheet.PerFileSheetV1d1;
import org.spdx.spdxspreadsheet.PerFileSheetV1d2;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public abstract class PerFileSheet
extends AbstractSheet {
    static final char CSV_SEPARATOR_CHAR = ',';
    static final char CSV_QUOTING_CHAR = '\"';
    protected String version;

    public PerFileSheet(Workbook workbook, String sheetName, String version) {
        super(workbook, sheetName);
        this.version = version;
    }

    public static PerFileSheet openVersion(Workbook workbook, String perFileSheetName, String version) {
        if (version.compareToIgnoreCase("0.9.4") <= 0) {
            return new PerFileSheetV09d3(workbook, perFileSheetName, version);
        }
        if (version.compareToIgnoreCase("1.1.0") <= 0) {
            return new PerFileSheetV1d1(workbook, perFileSheetName, version);
        }
        return new PerFileSheetV1d2(workbook, perFileSheetName, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stringsToCsv(String[] strings) {
        StringWriter writer = new StringWriter();
        CSVWriter csvWriter = new CSVWriter((Writer)writer, ',', '\"');
        try {
            String retval;
            csvWriter.writeNext(strings);
            csvWriter.flush();
            String string = retval = writer.toString().trim();
            return string;
        }
        catch (Exception e) {
            String string = "ERROR PARSING CONTRIBUTORS FROM SPX FILE";
            return string;
        }
        finally {
            try {
                csvWriter.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] csvToStrings(String csv) {
        StringReader reader = new StringReader(csv);
        CSVReader csvReader = new CSVReader((Reader)reader, ',', '\"');
        try {
            String[] stringArray = csvReader.readNext();
            return stringArray;
        }
        catch (IOException e) {
            String[] stringArray = new String[]{"ERROR PARSING CSV String"};
            return stringArray;
        }
        finally {
            try {
                csvReader.close();
            }
            catch (IOException e) {}
        }
    }

    public abstract void add(SPDXFile var1);

    public abstract SPDXFile getFileInfo(int var1) throws SpreadsheetException;

    public static void create(Workbook wb, String perFileSheetName) {
        PerFileSheetV1d2.create(wb, perFileSheetName);
    }
}

