/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.rdfparser.DOAPProject;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXFile;
import org.spdx.rdfparser.SPDXLicenseInfo;
import org.spdx.rdfparser.SPDXLicenseInfoFactory;
import org.spdx.spdxspreadsheet.AbstractSheet;
import org.spdx.spdxspreadsheet.PackageInfoSheet;
import org.spdx.spdxspreadsheet.PerFileSheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public class PerFileSheetV1d1
extends PerFileSheet {
    static final int NUM_COLS = 12;
    static final int FILE_NAME_COL = 0;
    static final int FILE_TYPE_COL = 1;
    static final int SHA1_COL = 2;
    static final int CONCLUDED_LIC_COL = 3;
    static final int LIC_INFO_IN_FILE_COL = 4;
    static final int LIC_COMMENTS_COL = 5;
    static final int SEEN_COPYRIGHT_COL = 6;
    static final int ARTIFACT_OF_PROJECT_COL = 7;
    static final int ARTIFACT_OF_HOMEPAGE_COL = 8;
    static final int ARTIFACT_OF_PROJECT_URL_COL = 9;
    static final int COMMENT_COL = 10;
    static final int USER_DEFINED_COL = 11;
    static final boolean[] REQUIRED = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false};
    static final String[] HEADER_TITLES = new String[]{"File Name", "File Type", "File Checksum", "License Concluded", "License Info in File", "License Comments", "File Copyright Text", "Artifact of Project", "Artifact of Homepage", "Artifact of URL", "File Comment", "User Defined Columns..."};
    static final int[] COLUMN_WIDTHS = new int[]{60, 10, 25, 30, 30, 40, 40, 25, 60, 60, 60, 60};
    static final boolean[] LEFT_WRAP = new boolean[]{true, false, true, true, true, true, true, true, true, true, true, true};
    static final boolean[] CENTER_NOWRAP = new boolean[]{false, true, false, false, false, false, false, false, false, false, false, false};

    public PerFileSheetV1d1(Workbook workbook, String sheetName, String version) {
        super(workbook, sheetName, version);
    }

    @Override
    public void add(SPDXFile fileInfo) {
        Row row = this.addRow();
        if (fileInfo.getArtifactOf() != null && fileInfo.getArtifactOf().length > 0) {
            DOAPProject project = fileInfo.getArtifactOf()[0];
            row.createCell(7).setCellValue(project.getName());
            row.createCell(8).setCellValue(project.getHomePage());
            row.createCell(9).setCellValue(project.getProjectUri());
        }
        if (fileInfo.getConcludedLicenses() != null) {
            row.createCell(3).setCellValue(fileInfo.getConcludedLicenses().toString());
        }
        row.createCell(0).setCellValue(fileInfo.getName());
        if (fileInfo.getSha1() != null && !fileInfo.getSha1().isEmpty()) {
            row.createCell(2).setCellValue(fileInfo.getSha1());
        }
        row.createCell(1).setCellValue(fileInfo.getType());
        if (fileInfo.getLicenseComments() != null && !fileInfo.getLicenseComments().isEmpty()) {
            row.createCell(5).setCellValue(fileInfo.getLicenseComments());
        }
        if (fileInfo.getCopyright() != null && !fileInfo.getCopyright().isEmpty()) {
            row.createCell(6).setCellValue(fileInfo.getCopyright());
        }
        if (fileInfo.getSeenLicenses() != null && fileInfo.getSeenLicenses().length > 0) {
            row.createCell(4).setCellValue(PackageInfoSheet.licensesToString(fileInfo.getSeenLicenses()));
        }
        if (fileInfo.getComment() != null && !fileInfo.getComment().isEmpty()) {
            row.createCell(10).setCellValue(fileInfo.getComment());
        }
    }

    @Override
    public SPDXFile getFileInfo(int rowNum) throws SpreadsheetException {
        DOAPProject[] artifactOf;
        Cell licCommentCell;
        SPDXLicenseInfo[] seenLicenses;
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        String ver = this.validateRow(row);
        if (ver != null && !ver.isEmpty()) {
            throw new SpreadsheetException(ver);
        }
        String name = row.getCell(0).getStringCellValue();
        String type = row.getCell(1).getStringCellValue();
        Cell sha1cell = row.getCell(2);
        String sha1 = sha1cell != null ? sha1cell.getStringCellValue() : "";
        Cell assertedLicenseCell = row.getCell(3);
        SPDXLicenseInfo fileLicenses = assertedLicenseCell != null && !assertedLicenseCell.getStringCellValue().isEmpty() ? SPDXLicenseInfoFactory.parseSPDXLicenseString(assertedLicenseCell.getStringCellValue()) : null;
        Cell seenLicenseCell = row.getCell(4);
        if (seenLicenseCell != null && !seenLicenseCell.getStringCellValue().isEmpty()) {
            String[] licenseStrings = seenLicenseCell.getStringCellValue().split(",");
            seenLicenses = new SPDXLicenseInfo[licenseStrings.length];
            for (int i = 0; i < licenseStrings.length; ++i) {
                seenLicenses[i] = SPDXLicenseInfoFactory.parseSPDXLicenseString(licenseStrings[i].trim());
            }
        } else {
            seenLicenses = null;
        }
        String licenseComments = (licCommentCell = row.getCell(5)) != null ? licCommentCell.getStringCellValue() : "";
        Cell copyrightCell = row.getCell(6);
        String copyright = copyrightCell != null ? copyrightCell.getStringCellValue() : "";
        Cell artifactOfCell = row.getCell(7);
        if (artifactOfCell != null && !artifactOfCell.getStringCellValue().isEmpty()) {
            String projectName = artifactOfCell.getStringCellValue();
            String homePage = "";
            Cell homePageCell = row.getCell(8);
            if (homePageCell != null) {
                homePage = homePageCell.getStringCellValue();
            }
            Cell uriCell = row.getCell(9);
            String uri = "";
            if (uriCell != null) {
                uri = uriCell.getStringCellValue();
            }
            DOAPProject project = new DOAPProject(projectName, homePage);
            if (uri != null && !uri.isEmpty()) {
                try {
                    project.setUri(uri);
                }
                catch (InvalidSPDXAnalysisException e) {
                    throw new SpreadsheetException("Error setting the URI for the artifact of");
                }
            }
            artifactOf = new DOAPProject[]{project};
        } else {
            artifactOf = new DOAPProject[]{};
        }
        String comment = null;
        Cell commentCell = row.getCell(10);
        if (commentCell != null) {
            comment = commentCell.getStringCellValue();
        }
        return new SPDXFile(name, type, sha1, fileLicenses, seenLicenses, licenseComments, copyright, artifactOf, comment);
    }

    @Override
    public String verify() {
        try {
            if (this.sheet == null) {
                return "Worksheet for SPDX File does not exist";
            }
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            for (int i = 0; i < 12; ++i) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell != null && cell.getStringCellValue() != null && cell.getStringCellValue().equals(HEADER_TITLES[i])) continue;
                return "Column " + HEADER_TITLES[i] + " missing for SPDX File worksheet";
            }
            boolean done = false;
            int rowNum = this.firstRowNum + 1;
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(this.firstCellNum) == null) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying SPDX File work sheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        for (int i = 0; i < 12; ++i) {
            Cell cell = row.getCell(i);
            if (cell == null) {
                if (!REQUIRED[i]) continue;
                return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum());
            }
            if (i != 3 && i != 4) continue;
            try {
                SPDXLicenseInfoFactory.parseSPDXLicenseString(cell.getStringCellValue());
                continue;
            }
            catch (SpreadsheetException ex) {
                if (i == 3) {
                    return "Invalid asserted license string in row " + String.valueOf(row.getRowNum()) + " details: " + ex.getMessage();
                }
                return "Invalid seen license string in row " + String.valueOf(row.getRowNum()) + " details: " + ex.getMessage();
            }
        }
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle centerStyle = AbstractSheet.createCenterStyle(wb);
        CellStyle wrapStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        for (int i = 0; i < HEADER_TITLES.length; ++i) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            if (LEFT_WRAP[i]) {
                sheet.setDefaultColumnStyle(i, wrapStyle);
            } else if (CENTER_NOWRAP[i]) {
                sheet.setDefaultColumnStyle(i, centerStyle);
            }
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
        }
    }
}

