/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.rdfparser.IStandardLicenseProvider;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXStandardLicense;
import org.spdx.spdxspreadsheet.AbstractSpreadsheet;
import org.spdx.spdxspreadsheet.LicenseSheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public class SPDXLicenseSpreadsheet
extends AbstractSpreadsheet
implements IStandardLicenseProvider {
    static final String LICENSE_SHEET_NAME = "Licenses";
    private LicenseSheet licenseSheet;

    public SPDXLicenseSpreadsheet(File spreadsheetFile, boolean create, boolean readonly) throws SpreadsheetException {
        super(spreadsheetFile, create, readonly);
        this.licenseSheet = new LicenseSheet(this.workbook, LICENSE_SHEET_NAME, spreadsheetFile);
        String verifyMsg = this.verifyWorkbook();
        if (verifyMsg != null) {
            logger.error((Object)verifyMsg);
            throw new SpreadsheetException(verifyMsg);
        }
    }

    @Override
    public void create(File spreadsheetFile) throws IOException, SpreadsheetException {
        this.create(spreadsheetFile, "Unknown", "Unknown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(File spreadsheetFile, String version, String releaseDate) throws IOException, SpreadsheetException {
        if (!spreadsheetFile.createNewFile()) {
            logger.error((Object)("Unable to create " + spreadsheetFile.getName()));
            throw new SpreadsheetException("Unable to create " + spreadsheetFile.getName());
        }
        FileOutputStream excelOut = null;
        try {
            excelOut = new FileOutputStream(spreadsheetFile);
            HSSFWorkbook wb = new HSSFWorkbook();
            LicenseSheet.create((Workbook)wb, LICENSE_SHEET_NAME, version, releaseDate);
            wb.write((OutputStream)excelOut);
        }
        finally {
            excelOut.close();
        }
    }

    @Override
    public void clear() {
        this.licenseSheet.clear();
    }

    @Override
    public String verifyWorkbook() {
        return this.licenseSheet.verify();
    }

    public LicenseSheet getLicenseSheet() {
        return this.licenseSheet;
    }

    @Override
    public Iterator<SPDXStandardLicense> getIterator() {
        try {
            return new LicenseIterator();
        }
        catch (SpreadsheetException e) {
            throw new RuntimeException(e);
        }
    }

    public class LicenseIterator
    implements Iterator<SPDXStandardLicense> {
        private int currentRowNum;
        SPDXStandardLicense currentLicense;

        public LicenseIterator() throws SpreadsheetException {
            this.currentRowNum = SPDXLicenseSpreadsheet.this.licenseSheet.getFirstDataRow();
            try {
                this.currentLicense = SPDXLicenseSpreadsheet.this.licenseSheet.getLicense(this.currentRowNum);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpreadsheetException(e.getMessage());
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentLicense != null;
        }

        @Override
        public SPDXStandardLicense next() {
            SPDXStandardLicense retval = this.currentLicense;
            ++this.currentRowNum;
            try {
                this.currentLicense = SPDXLicenseSpreadsheet.this.licenseSheet.getLicense(this.currentRowNum);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new RuntimeException(e.getMessage());
            }
            return retval;
        }

        @Override
        public void remove() {
        }
    }
}

