/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.spdxspreadsheet.AbstractSpreadsheet;
import org.spdx.spdxspreadsheet.NonStandardLicensesSheet;
import org.spdx.spdxspreadsheet.NonStandardLicensesSheetV0d9d4;
import org.spdx.spdxspreadsheet.OriginsSheet;
import org.spdx.spdxspreadsheet.PackageInfoSheet;
import org.spdx.spdxspreadsheet.PackageInfoSheetV09d2;
import org.spdx.spdxspreadsheet.PerFileSheet;
import org.spdx.spdxspreadsheet.PerFileSheetV09d3;
import org.spdx.spdxspreadsheet.ReviewersSheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public class SPDXSpreadsheet
extends AbstractSpreadsheet {
    public static final String CURRENT_VERSION = "1.2.0";
    public static final String VERSION_1_1_0 = "1.1.0";
    public static final String VERSION_0_9_4 = "0.9.4";
    public static final String VERSION_0_9_3 = "0.9.3";
    public static final String VERSION_0_9_2 = "0.9.2";
    public static final String VERSION_0_9_1 = "0.9.1";
    public static final String[] SUPPORTED_VERSIONS = new String[]{"1.2.0", "0.9.4", "0.9.3", "0.9.2", "0.9.1"};
    public static final String UNKNOWN_VERSION = "UNKNOWN";
    private OriginsSheet originsSheet;
    static final String ORIGIN_SHEET_NAME = "Origins";
    private PackageInfoSheet packageInfoSheet;
    static final String PACKAGE_INFO_SHEET_NAME = "Package Info";
    private NonStandardLicensesSheet nonStandardLicensesSheet;
    static final String NON_STANDARD_LICENSE_SHEET_NAME = "Extracted Lic Info";
    private PerFileSheet perFileSheet;
    static final String PER_FILE_SHEET_NAME = "Per File Info";
    private ReviewersSheet reviewersSheet;
    static final String REVIEWERS_SHEET_NAME = "Reviewers";
    private String version;

    public SPDXSpreadsheet(File spreadsheetFile, boolean create, boolean readonly) throws SpreadsheetException {
        super(spreadsheetFile, create, readonly);
        this.version = this.readVersion(this.workbook, ORIGIN_SHEET_NAME);
        if (this.version.equals(UNKNOWN_VERSION)) {
            throw new SpreadsheetException("The version for the SPDX spreadsheet could not be read.");
        }
        this.originsSheet = OriginsSheet.openVersion(this.workbook, ORIGIN_SHEET_NAME, this.version);
        String verifyMsg = this.originsSheet.verify();
        if (verifyMsg != null) {
            logger.error((Object)verifyMsg);
            throw new SpreadsheetException(verifyMsg);
        }
        this.packageInfoSheet = PackageInfoSheet.openVersion(this.workbook, PACKAGE_INFO_SHEET_NAME, this.version);
        this.nonStandardLicensesSheet = NonStandardLicensesSheetV0d9d4.openVersion(this.workbook, NON_STANDARD_LICENSE_SHEET_NAME, this.version);
        this.perFileSheet = PerFileSheet.openVersion(this.workbook, PER_FILE_SHEET_NAME, this.version);
        this.reviewersSheet = new ReviewersSheet(this.workbook, REVIEWERS_SHEET_NAME, this.version);
        verifyMsg = this.verifyWorkbook();
        if (verifyMsg != null) {
            logger.error((Object)verifyMsg);
            throw new SpreadsheetException(verifyMsg);
        }
    }

    private String readVersion(Workbook workbook, String originSheetName) {
        int firstRowNum;
        Sheet sheet = workbook.getSheet(originSheetName);
        Row dataRow = sheet.getRow((firstRowNum = sheet.getFirstRowNum()) + 1);
        if (dataRow == null) {
            return UNKNOWN_VERSION;
        }
        Cell versionCell = dataRow.getCell(0);
        if (versionCell == null) {
            return UNKNOWN_VERSION;
        }
        return versionCell.getStringCellValue();
    }

    public static boolean verifyVersion(String versionToCheck) {
        boolean supported = false;
        String trVersion = versionToCheck.trim();
        for (int i = 0; i < SUPPORTED_VERSIONS.length; ++i) {
            if (!SUPPORTED_VERSIONS[i].equals(trVersion)) continue;
            supported = true;
            break;
        }
        return supported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(File spreadsheetFile) throws IOException, SpreadsheetException {
        if (!spreadsheetFile.createNewFile()) {
            logger.error((Object)("Unable to create " + spreadsheetFile.getName()));
            throw new SpreadsheetException("Unable to create " + spreadsheetFile.getName());
        }
        FileOutputStream excelOut = null;
        try {
            excelOut = new FileOutputStream(spreadsheetFile);
            HSSFWorkbook wb = new HSSFWorkbook();
            OriginsSheet.create((Workbook)wb, ORIGIN_SHEET_NAME);
            PackageInfoSheet.create((Workbook)wb, PACKAGE_INFO_SHEET_NAME);
            NonStandardLicensesSheet.create((Workbook)wb, NON_STANDARD_LICENSE_SHEET_NAME);
            PerFileSheet.create((Workbook)wb, PER_FILE_SHEET_NAME);
            ReviewersSheet.create((Workbook)wb, REVIEWERS_SHEET_NAME);
            wb.write((OutputStream)excelOut);
        }
        finally {
            excelOut.close();
        }
    }

    @Override
    public void clear() {
        this.originsSheet.clear();
        this.packageInfoSheet.clear();
        this.nonStandardLicensesSheet.clear();
        this.perFileSheet.clear();
        this.reviewersSheet.clear();
    }

    @Override
    public String verifyWorkbook() {
        String retval = this.originsSheet.verify();
        if (retval == null || retval.isEmpty()) {
            retval = this.packageInfoSheet.verify();
        }
        if (retval == null || retval.isEmpty()) {
            retval = this.nonStandardLicensesSheet.verify();
        }
        if (retval == null || retval.isEmpty()) {
            retval = this.perFileSheet.verify();
        }
        if (retval == null || retval.isEmpty()) {
            retval = this.reviewersSheet.verify();
        }
        return retval;
    }

    public OriginsSheet getOriginsSheet() {
        return this.originsSheet;
    }

    public void setOriginsSheet(OriginsSheet originsSheet) {
        this.originsSheet = originsSheet;
    }

    public PackageInfoSheet getPackageInfoSheet() {
        return this.packageInfoSheet;
    }

    public void setPackageInfoSheet(PackageInfoSheetV09d2 packageInfoSheet) {
        this.packageInfoSheet = packageInfoSheet;
    }

    public NonStandardLicensesSheet getNonStandardLicensesSheet() {
        return this.nonStandardLicensesSheet;
    }

    public void setNonStandardLicensesSheet(NonStandardLicensesSheetV0d9d4 nonStandardLicensesSheet) {
        this.nonStandardLicensesSheet = nonStandardLicensesSheet;
    }

    public PerFileSheet getPerFileSheet() {
        return this.perFileSheet;
    }

    public void setPerFileSheet(PerFileSheetV09d3 perFileSheet) {
        this.perFileSheet = perFileSheet;
    }

    public ReviewersSheet getReviewersSheet() {
        return this.reviewersSheet;
    }

    public void setReviewersSheet(ReviewersSheet reviewersSheet) {
        this.reviewersSheet = reviewersSheet;
    }
}

