/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tag;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.spdx.rdfparser.DOAPProject;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXCreatorInformation;
import org.spdx.rdfparser.SPDXDocument;
import org.spdx.rdfparser.SPDXFile;
import org.spdx.rdfparser.SPDXLicenseInfo;
import org.spdx.rdfparser.SPDXLicenseInfoFactory;
import org.spdx.rdfparser.SPDXNonStandardLicense;
import org.spdx.rdfparser.SPDXNoneLicense;
import org.spdx.rdfparser.SPDXReview;
import org.spdx.rdfparser.SpdxPackageVerificationCode;
import org.spdx.tag.InvalidSpdxTagFileException;
import org.spdx.tag.TagValueBehavior;

public class BuildDocument
implements TagValueBehavior,
Serializable {
    private static final long serialVersionUID = -5490491489627686708L;
    private static final String DEFAULT_SHA1 = "0000000000000000000000000000000000000000";
    private Properties constants;
    private SPDXDocument analysis;
    private DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private SPDXReview lastReviewer = null;
    private SPDXNonStandardLicense lastExtractedLicense = null;
    private SPDXFile lastFile = null;
    private DOAPProject lastProject = null;
    private HashMap<String, ArrayList<SPDXFile>> fileDependencyMap = new HashMap();

    public BuildDocument(Model model, SPDXDocument spdxDocument, Properties constants) {
        this.constants = constants;
        this.analysis = spdxDocument;
        try {
            this.analysis.createSpdxAnalysis("http://www.uri.com#SPDXANALYSIS");
            this.analysis.createSpdxPackage();
        }
        catch (InvalidSPDXAnalysisException ex) {
            System.out.print("Error creating SPDX Analysis: " + ex.getMessage());
            return;
        }
    }

    @Override
    public void enter() throws Exception {
    }

    @Override
    public void buildDocument(String tag, String value) throws Exception {
        tag = tag.trim() + " ";
        value = BuildDocument.trim(value.trim());
        if (tag.equals(this.constants.getProperty("PROP_SPDX_VERSION"))) {
            this.analysis.setSpdxVersion(value);
        } else if (tag.equals(this.constants.getProperty("PROP_SPDX_DATA_LICENSE"))) {
            this.analysis.getDataLicense().setName(value);
        } else if (tag.equals(this.constants.getProperty("PROP_CREATION_CREATOR"))) {
            if (this.analysis.getCreatorInfo() == null) {
                SPDXCreatorInformation creator = new SPDXCreatorInformation(new String[]{value}, "", "", "");
                this.analysis.setCreationInfo(creator);
            } else {
                ArrayList<String> creators = new ArrayList<String>(Arrays.asList(this.analysis.getCreatorInfo().getCreators()));
                creators.add(value);
                this.analysis.getCreatorInfo().setCreators(creators.toArray(new String[0]));
            }
        } else if (tag.equals(this.constants.getProperty("PROP_CREATION_CREATED"))) {
            if (this.analysis.getCreatorInfo() == null) {
                SPDXCreatorInformation creator = new SPDXCreatorInformation(new String[0], "", "", "");
                this.analysis.setCreationInfo(creator);
            }
            this.analysis.getCreatorInfo().setCreated(value);
        } else if (tag.equals(this.constants.getProperty("PROP_CREATION_COMMENT"))) {
            if (this.analysis.getCreatorInfo() == null) {
                SPDXCreatorInformation creator = new SPDXCreatorInformation(new String[]{value}, "", "", "");
                this.analysis.setCreationInfo(creator);
            }
            this.analysis.getCreatorInfo().setComment(value);
        } else if (tag.equals(this.constants.getProperty("PROP_LICENSE_LIST_VERSION"))) {
            if (this.analysis.getCreatorInfo() == null) {
                SPDXCreatorInformation creator = new SPDXCreatorInformation(new String[]{value}, "", "", "");
                this.analysis.setCreationInfo(creator);
            }
            this.analysis.getCreatorInfo().setLicenseListVersion(value);
        } else if (tag.equals(this.constants.getProperty("PROP_SPDX_COMMENT"))) {
            this.analysis.setDocumentComment(value);
        } else if (tag.equals(this.constants.getProperty("PROP_REVIEW_REVIEWER"))) {
            this.lastReviewer = new SPDXReview(value, this.format.format(new Date()), "");
            ArrayList<SPDXReview> reviewers = new ArrayList<SPDXReview>(Arrays.asList(this.analysis.getReviewers()));
            reviewers.add(this.lastReviewer);
            this.analysis.setReviewers(reviewers.toArray(new SPDXReview[0]));
        } else if (tag.equals(this.constants.getProperty("PROP_REVIEW_DATE"))) {
            if (this.lastReviewer == null) {
                throw new InvalidSpdxTagFileException("Missing Reviewer - A reviewer must be provided before a review date");
            }
            this.lastReviewer.setReviewDate(value);
        } else if (tag.equals(this.constants.getProperty("PROP_REVIEW_COMMENT"))) {
            if (this.lastReviewer == null) {
                throw new InvalidSpdxTagFileException("Missing Reviewer - A reviewer must be provided before a review comment");
            }
            this.lastReviewer.setComment(value);
        } else if (tag.equals(this.constants.getProperty("PROP_LICENSE_ID"))) {
            this.lastExtractedLicense = new SPDXNonStandardLicense(value, "WARNING: TEXT IS REQUIRED", null, null, null);
            SPDXNonStandardLicense[] currentNonStdLicenses = this.analysis.getExtractedLicenseInfos();
            ArrayList<SPDXNonStandardLicense> licenses = new ArrayList<SPDXNonStandardLicense>(Arrays.asList(currentNonStdLicenses));
            licenses.add(this.lastExtractedLicense);
            this.analysis.setExtractedLicenseInfos(licenses.toArray(new SPDXNonStandardLicense[0]));
        } else if (tag.equals(this.constants.getProperty("PROP_EXTRACTED_TEXT"))) {
            if (this.lastExtractedLicense == null) {
                throw new InvalidSpdxTagFileException("Missing Extracted License - An  extracted license ID must be provided before the license text");
            }
            this.lastExtractedLicense.setText(value);
        } else if (tag.equals(this.constants.getProperty("PROP_LICENSE_NAME"))) {
            if (this.lastExtractedLicense == null) {
                throw new InvalidSpdxTagFileException("Missing Extracted License - An  extracted license ID must be provided before the license name");
            }
            this.lastExtractedLicense.setLicenseName(value);
        } else if (tag.equals(this.constants.getProperty("PROP_SOURCE_URLS"))) {
            if (this.lastExtractedLicense == null) {
                throw new InvalidSpdxTagFileException("Missing Extracted License - An  extracted license ID must be provided before the license URL");
            }
            String[] values = value.split(",");
            for (int i = 0; i < values.length; ++i) {
                values[i] = values[i].trim();
            }
            this.lastExtractedLicense.setSourceUrls(values);
        } else if (tag.equals(this.constants.getProperty("PROP_LICENSE_COMMENT"))) {
            if (this.lastExtractedLicense == null) {
                throw new InvalidSpdxTagFileException("Missing Extracted License - An  extracted license ID must be provided before the license comment");
            }
            this.lastExtractedLicense.setComment(value);
        } else {
            SPDXDocument.SPDXPackage spdxPackage = this.analysis.getSpdxPackage();
            this.buildPackage(spdxPackage, tag, value);
        }
    }

    private void buildPackage(SPDXDocument.SPDXPackage pkg, String tag, String value) throws Exception {
        if (tag.equals(this.constants.getProperty("PROP_PACKAGE_DECLARED_NAME"))) {
            pkg.setDeclaredName(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_VERSION_INFO"))) {
            pkg.setVersionInfo(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_DOWNLOAD_URL"))) {
            pkg.setDownloadUrl(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_HOMEPAGE_URL"))) {
            pkg.setHomePage(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_SHORT_DESC"))) {
            pkg.setShortDescription(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_SOURCE_INFO"))) {
            pkg.setSourceInfo(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_FILE_NAME"))) {
            pkg.setFileName(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_SUPPLIER"))) {
            pkg.setSupplier(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_ORIGINATOR"))) {
            pkg.setOriginator(value);
        } else if (this.constants.getProperty("PROP_PACKAGE_CHECKSUM").startsWith(tag)) {
            pkg.setSha1(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_VERIFICATION_CODE"))) {
            if (value.contains("(")) {
                String[] verification = value.split("\\(");
                String[] excludedFiles = verification[1].replace(")", "").split(",");
                for (int i = 0; i < excludedFiles.length; ++i) {
                    excludedFiles[i] = excludedFiles[i].trim();
                }
                pkg.setVerificationCode(new SpdxPackageVerificationCode(verification[0].trim(), excludedFiles));
            } else {
                pkg.setVerificationCode(new SpdxPackageVerificationCode(value, new String[0]));
            }
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_DESCRIPTION"))) {
            pkg.setDescription(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_DECLARED_COPYRIGHT"))) {
            pkg.setDeclaredCopyright(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_DECLARED_LICENSE"))) {
            SPDXLicenseInfo licenseSet = SPDXLicenseInfoFactory.parseSPDXLicenseString(value);
            pkg.setDeclaredLicense(licenseSet);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_CONCLUDED_LICENSE"))) {
            SPDXLicenseInfo licenseSet = SPDXLicenseInfoFactory.parseSPDXLicenseString(value);
            pkg.setConcludedLicenses(licenseSet);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_LICENSE_COMMENT"))) {
            pkg.setLicenseComment(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_LICENSE_INFO_FROM_FILES"))) {
            SPDXLicenseInfo license = SPDXLicenseInfoFactory.parseSPDXLicenseString(value);
            ArrayList<SPDXLicenseInfo> licenses = new ArrayList<SPDXLicenseInfo>(Arrays.asList(pkg.getLicenseInfoFromFiles()));
            licenses.add(license);
            pkg.setLicenseInfoFromFiles(licenses.toArray(new SPDXLicenseInfo[0]));
        } else {
            this.buildFile(pkg, tag, value);
        }
    }

    private void buildFile(SPDXDocument.SPDXPackage pkg, String tag, String value) throws Exception {
        if (tag.equals(this.constants.getProperty("PROP_FILE_NAME"))) {
            this.lastFile = new SPDXFile(value, "OTHER", DEFAULT_SHA1, new SPDXNoneLicense(), new SPDXLicenseInfo[0], "", "", new DOAPProject[0]);
            pkg.addFile(this.lastFile);
        } else {
            if (this.lastFile == null) {
                if (tag.equals(this.constants.getProperty("PROP_FILE_TYPE")) || this.constants.getProperty("PROP_FILE_CHECKSUM").startsWith(tag) || tag.equals(this.constants.getProperty("PROP_FILE_LICENSE")) || tag.equals(this.constants.getProperty("PROP_FILE_LIC_COMMENTS")) || tag.equals(this.constants.getProperty("PROP_FILE_COPYRIGHT")) || tag.equals(this.constants.getProperty("PROP_FILE_COMMENT"))) {
                    throw new InvalidSpdxTagFileException("Missing File Name - A file name must be specified before the file properties");
                }
                throw new InvalidSpdxTagFileException("Unrecognized SPDX Tag: " + tag);
            }
            if (tag.equals(this.constants.getProperty("PROP_FILE_TYPE"))) {
                this.lastFile.setType(value);
            } else if (this.constants.getProperty("PROP_FILE_CHECKSUM").startsWith(tag)) {
                this.lastFile.setSha1(value);
            } else if (tag.equals(this.constants.getProperty("PROP_FILE_LICENSE"))) {
                SPDXLicenseInfo licenseSet = SPDXLicenseInfoFactory.parseSPDXLicenseString(value);
                this.lastFile.setConcludedLicenses(licenseSet);
            } else if (tag.equals(this.constants.getProperty("PROP_FILE_SEEN_LICENSE"))) {
                SPDXLicenseInfo fileLicense = SPDXLicenseInfoFactory.parseSPDXLicenseString(value);
                ArrayList<SPDXLicenseInfo> seenLicenses = new ArrayList<SPDXLicenseInfo>(Arrays.asList(this.lastFile.getSeenLicenses()));
                seenLicenses.add(fileLicense);
                this.lastFile.setSeenLicenses(seenLicenses.toArray(new SPDXLicenseInfo[0]));
            } else if (tag.equals(this.constants.getProperty("PROP_FILE_LIC_COMMENTS"))) {
                this.lastFile.setLicenseComments(value);
            } else if (tag.equals(this.constants.getProperty("PROP_FILE_COPYRIGHT"))) {
                this.lastFile.setCopyright(value);
            } else if (tag.equals(this.constants.getProperty("PROP_FILE_COMMENT"))) {
                this.lastFile.setComment(value);
            } else if (tag.equals(this.constants.getProperty("PROP_FILE_DEPENDENCY"))) {
                this.addFileDependency(this.lastFile, value);
            } else if (tag.equals(this.constants.getProperty("PROP_FILE_CONTRIBUTOR"))) {
                this.addFileContributor(this.lastFile, value);
            } else if (tag.equals(this.constants.getProperty("PROP_FILE_NOTICE_TEXT"))) {
                this.lastFile.setNoticeText(value);
            } else {
                this.buildProject(this.lastFile, tag, value);
            }
        }
    }

    private void addFileContributor(SPDXFile file, String contributor) {
        String[] contributors = file.getContributors();
        if (contributors == null) {
            contributors = new String[]{contributor};
        } else {
            contributors = Arrays.copyOf(contributors, contributors.length + 1);
            contributors[contributors.length - 1] = contributor;
        }
        file.setContributors(contributors);
    }

    private void addFileDependency(SPDXFile file, String dependentFileName) {
        ArrayList<SPDXFile> filesWithThisAsADependency = this.fileDependencyMap.get(dependentFileName);
        if (filesWithThisAsADependency == null) {
            filesWithThisAsADependency = new ArrayList();
            this.fileDependencyMap.put(dependentFileName, filesWithThisAsADependency);
        }
        filesWithThisAsADependency.add(file);
    }

    private void buildProject(SPDXFile file, String tag, String value) throws Exception {
        if (tag.equals(this.constants.getProperty("PROP_PROJECT_NAME"))) {
            this.lastProject = new DOAPProject(value, null);
            ArrayList<DOAPProject> projects = new ArrayList<DOAPProject>(Arrays.asList(file.getArtifactOf()));
            projects.add(this.lastProject);
            file.setArtifactOf(projects.toArray(new DOAPProject[0]));
        } else if (tag.equals(this.constants.getProperty("PROP_PROJECT_HOMEPAGE"))) {
            if (this.lastProject == null) {
                throw new InvalidSpdxTagFileException("Missing Project Name - A project name must be provided before the project properties");
            }
            this.lastProject.setHomePage(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PROJECT_URI"))) {
            int i;
            if (this.lastProject == null) {
                throw new InvalidSpdxTagFileException("Missing Project Name - A project name must be provided before the project properties");
            }
            DOAPProject[] existingProjects = file.getArtifactOf();
            for (i = 0; i < existingProjects.length && !existingProjects[i].equals(this.lastProject); ++i) {
            }
            if (i >= existingProjects.length) {
                existingProjects = Arrays.copyOf(existingProjects, existingProjects.length + 1);
            }
            existingProjects[i] = new DOAPProject(this.lastProject.getName(), this.lastProject.getHomePage());
            existingProjects[i].setUri(value);
            file.setArtifactOf(existingProjects);
            this.lastProject = existingProjects[i];
        } else {
            throw new InvalidSpdxTagFileException("Unrecognized tag: " + tag);
        }
    }

    private static String trim(String value) {
        value.trim();
        value = value.replaceAll("<text>", "").replaceAll("</text>", "").replaceAll("SHA1: ", "");
        return value;
    }

    @Override
    public void exit() throws Exception {
        this.fixFileDependencies();
        ArrayList<String> warningMessages = this.analysis.verify();
        BuildDocument.assertEquals("SPDXDocument", 0, warningMessages);
    }

    private void fixFileDependencies() throws InvalidSPDXAnalysisException {
        HashMap<SPDXFile, ArrayList<SPDXFile>> filesWithDependencies = new HashMap<SPDXFile, ArrayList<SPDXFile>>();
        SPDXFile[] allFiles = this.analysis.getFileReferences();
        for (int i = 0; i < allFiles.length; ++i) {
            ArrayList<SPDXFile> alFilesHavingThisDependency = this.fileDependencyMap.get(allFiles[i].getName());
            if (alFilesHavingThisDependency == null) continue;
            for (int j = 0; j < alFilesHavingThisDependency.size(); ++j) {
                SPDXFile fileWithDependency = alFilesHavingThisDependency.get(j);
                ArrayList<SPDXFile> alDepdenciesForThisFile = (ArrayList<SPDXFile>)filesWithDependencies.get(fileWithDependency);
                if (alDepdenciesForThisFile == null) {
                    alDepdenciesForThisFile = new ArrayList<SPDXFile>();
                    filesWithDependencies.put(fileWithDependency, alDepdenciesForThisFile);
                }
                alDepdenciesForThisFile.add(allFiles[i]);
            }
            this.fileDependencyMap.remove(allFiles[i].getName());
        }
        for (Map.Entry entry : filesWithDependencies.entrySet()) {
            ArrayList alDependencies = (ArrayList)entry.getValue();
            if (alDependencies == null || alDependencies.size() <= 0) continue;
            ((SPDXFile)entry.getKey()).setFileDependencies(alDependencies.toArray(new SPDXFile[alDependencies.size()]));
        }
        Set<String> missingDependencies = this.fileDependencyMap.keySet();
        if (missingDependencies != null && missingDependencies.size() > 0) {
            System.out.println("The following file names were listed as file dependencies but were not found in the list of files:");
            Iterator<String> missingIter = missingDependencies.iterator();
            while (missingIter.hasNext()) {
                System.out.println("\t" + missingIter.next());
            }
        }
    }

    private static void assertEquals(String name, int expected, ArrayList<String> verify) {
        if (verify.size() > expected) {
            System.out.println("The following verifications failed for the " + name + ":");
            for (int x = 0; x < verify.size(); ++x) {
                System.out.println("\t" + verify.get(x));
            }
        }
    }
}

