/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tag;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.spdx.rdfparser.DOAPProject;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXDocument;
import org.spdx.rdfparser.SPDXFile;
import org.spdx.rdfparser.SPDXLicenseInfo;
import org.spdx.rdfparser.SPDXNonStandardLicense;
import org.spdx.rdfparser.SPDXReview;
import org.spdx.rdfparser.SPDXStandardLicense;
import org.spdx.tools.RdfToTag;

public class CommonCode {
    public static void printDoc(SPDXDocument doc, PrintWriter out, Properties constants) throws InvalidSPDXAnalysisException {
        int i;
        SPDXStandardLicense dataLicense;
        if (doc == null) {
            CommonCode.println(out, "Warning: No document to print");
            return;
        }
        String spdxVersion = "";
        if (doc.getSpdxVersion() != null && doc.getCreatorInfo().getCreated() != null) {
            spdxVersion = doc.getSpdxVersion();
            CommonCode.println(out, constants.getProperty("PROP_SPDX_VERSION") + spdxVersion);
        }
        if (!spdxVersion.equals("SPDX-0.8") && !spdxVersion.equals("SPDX-0.9") && (dataLicense = doc.getDataLicense()) != null) {
            CommonCode.println(out, constants.getProperty("PROP_SPDX_DATA_LICENSE") + dataLicense.getName());
        }
        if (doc.getDocumentComment() != null && !doc.getDocumentComment().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_SPDX_COMMENT") + constants.getProperty("PROP_BEGIN_TEXT") + doc.getDocumentComment() + constants.getProperty("PROP_END_TEXT"));
        }
        CommonCode.println(out, "");
        if (doc.getCreatorInfo().getCreators() != null && doc.getCreatorInfo().getCreators().length > 0) {
            CommonCode.println(out, constants.getProperty("CREATION_INFO_HEADER"));
            String[] creators = doc.getCreatorInfo().getCreators();
            for (i = 0; i < creators.length; ++i) {
                CommonCode.println(out, constants.getProperty("PROP_CREATION_CREATOR") + creators[i]);
            }
        }
        if (doc.getCreatorInfo().getCreated() != null && !doc.getCreatorInfo().getCreated().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_CREATION_CREATED") + doc.getCreatorInfo().getCreated());
        }
        if (doc.getCreatorInfo().getLicenseListVersion() != null && !doc.getCreatorInfo().getLicenseListVersion().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_LICENSE_LIST_VERSION") + doc.getCreatorInfo().getLicenseListVersion());
        }
        if (doc.getCreatorInfo().getComment() != null && !doc.getCreatorInfo().getComment().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_CREATION_COMMENT") + constants.getProperty("PROP_BEGIN_TEXT") + doc.getCreatorInfo().getComment() + constants.getProperty("PROP_END_TEXT"));
        }
        CommonCode.println(out, "");
        if (doc.getReviewers() != null && doc.getReviewers().length > 0) {
            CommonCode.println(out, constants.getProperty("REVIEW_INFO_HEADER"));
            SPDXReview[] reviewedBy = doc.getReviewers();
            for (i = 0; i < reviewedBy.length; ++i) {
                CommonCode.println(out, constants.getProperty("PROP_REVIEW_REVIEWER") + reviewedBy[i].getReviewer());
                CommonCode.println(out, constants.getProperty("PROP_REVIEW_DATE") + reviewedBy[i].getReviewDate());
                if (reviewedBy[i].getComment() != null && !reviewedBy[i].getComment().isEmpty()) {
                    CommonCode.println(out, constants.getProperty("PROP_REVIEW_COMMENT") + constants.getProperty("PROP_BEGIN_TEXT") + reviewedBy[i].getComment() + constants.getProperty("PROP_END_TEXT"));
                }
                CommonCode.println(out, "");
            }
        }
        CommonCode.printPackage(doc.getSpdxPackage(), out, constants);
        CommonCode.println(out, "");
        if (doc.getExtractedLicenseInfos() != null && doc.getExtractedLicenseInfos().length > 0) {
            SPDXNonStandardLicense[] nonStandardLic = doc.getExtractedLicenseInfos();
            CommonCode.println(out, constants.getProperty("LICENSE_INFO_HEADER"));
            for (i = 0; i < nonStandardLic.length; ++i) {
                CommonCode.printLicense(nonStandardLic[i], out, constants);
            }
        }
    }

    private static void printLicense(SPDXNonStandardLicense license, PrintWriter out, Properties constants) {
        if (license.getId() != null && !license.getId().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_LICENSE_ID") + license.getId());
        }
        if (license.getText() != null && !license.getText().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_EXTRACTED_TEXT") + constants.getProperty("PROP_BEGIN_TEXT") + license.getText() + constants.getProperty("PROP_END_TEXT"));
        }
        if (license.getLicenseName() != null && !license.getLicenseName().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_LICENSE_NAME") + license.getLicenseName());
        }
        if (license.getSourceUrls() != null && license.getSourceUrls().length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(license.getSourceUrls()[0]);
            for (int i = 1; i < license.getSourceUrls().length; ++i) {
                sb.append(", ");
                sb.append(license.getSourceUrls()[i]);
            }
            CommonCode.println(out, constants.getProperty("PROP_SOURCE_URLS") + sb.toString());
        }
        if (license.getSourceUrls() != null && license.getComment() != null && !license.getComment().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_LICENSE_COMMENT") + constants.getProperty("PROP_BEGIN_TEXT") + license.getComment() + constants.getProperty("PROP_END_TEXT"));
        }
        CommonCode.println(out, "");
    }

    private static void printPackage(SPDXDocument.SPDXPackage pkg, PrintWriter out, Properties constants) throws InvalidSPDXAnalysisException {
        CommonCode.println(out, constants.getProperty("PACKAGE_INFO_HEADER"));
        if (pkg.getDeclaredName() != null && !pkg.getDeclaredName().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_DECLARED_NAME") + pkg.getDeclaredName());
        }
        if (pkg.getVersionInfo() != null && !pkg.getVersionInfo().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_VERSION_INFO") + pkg.getVersionInfo());
        }
        if (pkg.getHomePage() != null && !pkg.getHomePage().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_HOMEPAGE_URL") + pkg.getHomePage());
        }
        if (pkg.getDownloadUrl() != null && !pkg.getDownloadUrl().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_DOWNLOAD_URL") + pkg.getDownloadUrl());
        }
        if (pkg.getShortDescription() != null && !pkg.getShortDescription().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_SHORT_DESC") + constants.getProperty("PROP_BEGIN_TEXT") + pkg.getShortDescription() + constants.getProperty("PROP_END_TEXT"));
        }
        if (pkg.getSourceInfo() != null && !pkg.getSourceInfo().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_SOURCE_INFO") + pkg.getSourceInfo());
        }
        if (pkg.getFileName() != null && !pkg.getFileName().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_FILE_NAME") + pkg.getFileName());
        }
        if (pkg.getSupplier() != null && !pkg.getSupplier().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_SUPPLIER") + pkg.getSupplier());
        }
        if (pkg.getOriginator() != null && !pkg.getOriginator().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_ORIGINATOR") + pkg.getOriginator());
        }
        if (pkg.getSha1() != null && !pkg.getSha1().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_CHECKSUM") + pkg.getSha1());
        }
        if (pkg.getVerificationCode() != null && pkg.getVerificationCode().getValue() != null && !pkg.getVerificationCode().getValue().isEmpty()) {
            String code = constants.getProperty("PROP_PACKAGE_VERIFICATION_CODE") + pkg.getVerificationCode().getValue();
            String excludedFilesString = "";
            String[] stringArray = pkg.getVerificationCode().getExcludedFileNames();
            if (stringArray.length != 0) {
                excludedFilesString = " (" + stringArray[0];
                for (int i = 1; i < stringArray.length; ++i) {
                    excludedFilesString = excludedFilesString + ", " + stringArray[i];
                }
                excludedFilesString = excludedFilesString + ")";
                code = code + excludedFilesString;
            }
            CommonCode.println(out, code);
        }
        if (pkg.getDescription() != null && !pkg.getDescription().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_DESCRIPTION") + constants.getProperty("PROP_BEGIN_TEXT") + pkg.getDescription() + constants.getProperty("PROP_END_TEXT"));
        }
        CommonCode.println(out, "");
        if (pkg.getDeclaredCopyright() != null && !pkg.getDeclaredCopyright().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_DECLARED_COPYRIGHT") + constants.getProperty("PROP_BEGIN_TEXT") + pkg.getDeclaredCopyright() + constants.getProperty("PROP_END_TEXT"));
        }
        CommonCode.println(out, "");
        if (pkg.getDeclaredLicense() != null) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_DECLARED_LICENSE") + pkg.getDeclaredLicense());
        }
        if (pkg.getConcludedLicenses() != null) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_CONCLUDED_LICENSE") + pkg.getConcludedLicenses());
        }
        if (pkg.getLicenseInfoFromFiles() != null && pkg.getLicenseInfoFromFiles().length > 0) {
            SPDXLicenseInfo[] licenses = pkg.getLicenseInfoFromFiles();
            CommonCode.println(out, constants.getProperty("LICENSE_FROM_FILES_INFO_HEADER"));
            for (int i = 0; i < licenses.length; ++i) {
                CommonCode.println(out, constants.getProperty("PROP_PACKAGE_LICENSE_INFO_FROM_FILES") + licenses[i].toString());
            }
        }
        if (pkg.getLicenseComment() != null && !pkg.getLicenseComment().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_LICENSE_COMMENT") + constants.getProperty("PROP_BEGIN_TEXT") + pkg.getLicenseComment() + constants.getProperty("PROP_END_TEXT"));
        }
        if (pkg.getFiles() != null && pkg.getFiles().length > 0) {
            List<Object> sortedFileList = new ArrayList();
            sortedFileList = Arrays.asList(pkg.getFiles());
            Collections.sort(sortedFileList);
            CommonCode.println(out, "");
            CommonCode.println(out, constants.getProperty("FILE_INFO_HEADER"));
            for (SPDXFile sPDXFile : sortedFileList) {
                CommonCode.printFile(sPDXFile, out, constants);
                CommonCode.println(out, "");
            }
        }
    }

    private static void printFile(SPDXFile file, PrintWriter out, Properties constants) {
        int i;
        if (file.getName() != null && !file.getName().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_FILE_NAME") + file.getName());
        }
        if (file.getType() != null && !file.getType().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_FILE_TYPE") + file.getType());
        }
        if (file.getSha1() != null && !file.getSha1().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_FILE_CHECKSUM") + file.getSha1());
        }
        if (file.getConcludedLicenses() != null) {
            CommonCode.println(out, constants.getProperty("PROP_FILE_LICENSE") + file.getConcludedLicenses().toString());
        }
        if (file.getSeenLicenses() != null && file.getSeenLicenses().length > 0) {
            for (i = 0; i < file.getSeenLicenses().length; ++i) {
                CommonCode.println(out, constants.getProperty("PROP_FILE_SEEN_LICENSE") + file.getSeenLicenses()[i].toString());
            }
        }
        if (file.getLicenseComments() != null && !file.getLicenseComments().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_FILE_LIC_COMMENTS") + file.getLicenseComments());
        }
        if (file.getCopyright() != null && !file.getCopyright().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_FILE_COPYRIGHT") + constants.getProperty("PROP_BEGIN_TEXT") + file.getCopyright() + constants.getProperty("PROP_END_TEXT"));
        }
        if (file.getArtifactOf() != null && file.getArtifactOf().length > 0) {
            for (i = 0; i < file.getArtifactOf().length; ++i) {
                CommonCode.printProject(file.getArtifactOf()[i], out, constants);
            }
        }
        if (file.getFileDependencies() != null && file.getFileDependencies().length > 0) {
            for (i = 0; i < file.getFileDependencies().length; ++i) {
                CommonCode.println(out, constants.getProperty("PROP_FILE_DEPENDENCY") + file.getFileDependencies()[i].getName());
            }
        }
        if (file.getContributors() != null && file.getContributors().length > 0) {
            for (i = 0; i < file.getContributors().length; ++i) {
                CommonCode.println(out, constants.getProperty("PROP_FILE_CONTRIBUTOR") + file.getContributors()[i]);
            }
        }
        if (file.getNoticeText() != null && !file.getNoticeText().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_FILE_NOTICE_TEXT") + constants.getProperty("PROP_BEGIN_TEXT") + file.getNoticeText() + constants.getProperty("PROP_END_TEXT"));
        }
        if (file.getComment() != null && !file.getComment().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_FILE_COMMENT") + constants.getProperty("PROP_BEGIN_TEXT") + file.getComment() + constants.getProperty("PROP_END_TEXT"));
        }
    }

    private static void printProject(DOAPProject doapProject, PrintWriter out, Properties constants) {
        if (doapProject.getName() != null && !doapProject.getName().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_PROJECT_NAME") + doapProject.getName());
        }
        if (doapProject.getHomePage() != null && !doapProject.getHomePage().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_PROJECT_HOMEPAGE") + doapProject.getHomePage());
        }
        if (doapProject.getProjectUri() != null && !doapProject.getProjectUri().isEmpty() && !doapProject.getProjectUri().equals("UNKNOWN")) {
            CommonCode.println(out, constants.getProperty("PROP_PROJECT_URI") + doapProject.getProjectUri());
        }
    }

    private static void println(PrintWriter out, String output) {
        if (out != null) {
            out.println(output);
        } else {
            System.out.println(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getTextFromProperties(String path) throws IOException {
        InputStream is = null;
        Properties prop = new Properties();
        try {
            is = RdfToTag.class.getClassLoader().getResourceAsStream(path);
            prop.load(is);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return prop;
    }
}

