/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tag;

import antlr.RecognitionException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spdx.tag.BuildDocument;

public class HandBuiltParser {
    private static final String END_TEXT = "</text>";
    private static final String START_TEXT = "<text>";
    Pattern tagPattern = Pattern.compile("^\\w+:");
    private BuildDocument buildDocument;
    private InputStream textInput;

    public HandBuiltParser(InputStream textInput) {
        this.textInput = textInput;
    }

    public void setBehavior(BuildDocument buildDocument) {
        this.buildDocument = buildDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void data() throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(this.textInput));
        try {
            boolean inTextBlock = false;
            String tag = "";
            String value = "";
            String nextLine = br.readLine();
            while (nextLine != null) {
                if (inTextBlock) {
                    int endText = nextLine.indexOf(END_TEXT);
                    if (endText >= 0) {
                        value = value + "\n" + nextLine.substring(0, endText).trim();
                        inTextBlock = false;
                        this.buildDocument.buildDocument(tag, value);
                        tag = "";
                        value = "";
                    } else {
                        value = value + "\n" + nextLine;
                    }
                } else {
                    Matcher tagMatcher = this.tagPattern.matcher(nextLine);
                    if (tagMatcher.find()) {
                        tag = tagMatcher.group();
                        int startText = nextLine.indexOf(START_TEXT);
                        if (startText > 0) {
                            value = nextLine.substring(startText + START_TEXT.length()).trim();
                            if (value.contains(END_TEXT)) {
                                value = value.substring(0, value.indexOf(END_TEXT)).trim();
                                this.buildDocument.buildDocument(tag, value);
                                tag = "";
                                value = "";
                            } else {
                                inTextBlock = true;
                            }
                        } else {
                            value = nextLine.substring(tag.length()).trim();
                            this.buildDocument.buildDocument(tag, value);
                            tag = "";
                            value = "";
                        }
                    }
                }
                nextLine = br.readLine();
            }
            if (inTextBlock) {
                throw new RecognitionException("Un terminted text block.  Expecting </text>");
            }
            this.buildDocument.exit();
        }
        finally {
            br.close();
        }
    }
}

