/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tag;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;

public class NoCommentInputStream
extends InputStream {
    static final Logger logger = Logger.getLogger((String)NoCommentInputStream.class.getName());
    private static final CharSequence START_TEXT_TAG = "<text>";
    private static final CharSequence END_TEXT_TAG = "</text>";
    private static final char COMMENT_CHAR = '#';
    private InputStream inputStream;
    private InputStreamReader reader;
    private BufferedReader bufferedReader;
    private int lineIndex = 1;
    private String currentLine = "";
    boolean eof = false;
    boolean inText = false;

    public NoCommentInputStream(InputStream in) throws IOException {
        this.inputStream = in;
        this.reader = new InputStreamReader(this.inputStream);
        this.bufferedReader = new BufferedReader(this.reader);
        this.readNextLine();
    }

    private void readNextLine() throws IOException {
        if (this.eof) {
            return;
        }
        this.currentLine = this.bufferedReader.readLine();
        while (!(this.currentLine == null || this.inText || this.currentLine.length() != 0 && this.currentLine.charAt(0) != '#')) {
            this.currentLine = this.bufferedReader.readLine();
        }
        if (this.currentLine == null) {
            this.eof = true;
            return;
        }
        if (this.inText) {
            if (this.containsEndText(this.currentLine)) {
                this.inText = false;
            }
        } else if (this.containsStartText(this.currentLine)) {
            this.inText = true;
        }
        this.lineIndex = 0;
    }

    private boolean containsEndText(String str) {
        return str.contains(END_TEXT_TAG);
    }

    private boolean containsStartText(String str) {
        return str.contains(START_TEXT_TAG);
    }

    @Override
    public int read() throws IOException {
        if (!this.eof && this.lineIndex >= this.currentLine.length()) {
            this.readNextLine();
            if (this.eof) {
                return -1;
            }
            return 10;
        }
        if (this.eof) {
            return -1;
        }
        return this.currentLine.charAt(this.lineIndex++);
    }

    @Override
    public void close() {
        if (this.bufferedReader != null) {
            try {
                this.bufferedReader.close();
            }
            catch (IOException e) {
                logger.error((Object)("IO Error closing buffered reader: " + e.getMessage()));
            }
        }
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                logger.error((Object)("IO Error closing reader: " + e.getMessage()));
            }
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                logger.error((Object)("IO Error closing input stream: " + e.getMessage()));
            }
        }
    }
}

