/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.io.File;
import java.util.ArrayList;
import org.spdx.compare.MultiDocumentSpreadsheet;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXDocument;
import org.spdx.spdxspreadsheet.SpreadsheetException;
import org.spdx.tools.CompareSpdxDocs;

public class CompareMultpleSpdxDocs {
    static final int MIN_ARGS = 3;
    static final int MAX_ARGS = 14;
    static final int ERROR_STATUS = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        File outputFile;
        if (args.length < 3) {
            System.out.println("Insufficient arguments");
            CompareMultpleSpdxDocs.usage();
            System.exit(1);
        }
        if (args.length > 14) {
            System.out.println("Too many SPDX documents specified.  Must be less than " + String.valueOf(13) + " document filenames");
            CompareMultpleSpdxDocs.usage();
            System.exit(1);
        }
        if ((outputFile = new File(args[0])).exists()) {
            System.out.println("Output file " + args[0] + " already exists.");
            CompareMultpleSpdxDocs.usage();
            System.exit(1);
        }
        SPDXDocument[] compareDocs = new SPDXDocument[args.length - 1];
        String[] docNames = new String[args.length - 1];
        ArrayList[] verificationErrors = new ArrayList[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            try {
                compareDocs[i - 1] = CompareSpdxDocs.openRdfOrTagDoc(args[i]);
                docNames[i - 1] = CompareSpdxDocs.convertDocName(args[i]);
                verificationErrors[i - 1] = compareDocs[i - 1].verify();
                if (verificationErrors[i - 1] == null || verificationErrors[i - 1].size() <= 0) continue;
                System.out.println("Warning: " + docNames[i - 1] + " contains verification errors.");
                continue;
            }
            catch (SpdxCompareException e) {
                System.out.println("Error opening SPDX document " + args[i] + ": " + e.getMessage());
                System.exit(1);
            }
        }
        MultiDocumentSpreadsheet outSheet = null;
        try {
            outSheet = new MultiDocumentSpreadsheet(outputFile, true, false);
            outSheet.importVerificationErrors(verificationErrors, docNames);
            SpdxComparer comparer = new SpdxComparer();
            comparer.compare(compareDocs);
            outSheet.importCompareResults(comparer, docNames);
        }
        catch (SpreadsheetException e) {
            System.out.println("Unable to create output spreadsheet: " + e.getMessage());
            System.exit(1);
        }
        catch (InvalidSPDXAnalysisException e) {
            System.out.println("Invalid SPDX analysis: " + e.getMessage());
            System.exit(1);
        }
        catch (SpdxCompareException e) {
            System.out.println("Error comparing SPDX documents: " + e.getMessage());
            System.exit(1);
        }
        finally {
            if (outSheet != null) {
                try {
                    outSheet.close();
                }
                catch (SpreadsheetException e) {
                    System.out.println("Warning - error closing spreadsheet: " + e.getMessage());
                }
            }
        }
    }

    private static void usage() {
        System.out.println("Usage: CompareMultipleSpdxDoc output.xls doc1 doc2 ... docN");
        System.out.println("where output.xls is a file name for the output spreadsheet file");
        System.out.println("and doc1 through docN are file names of valid SPDX documents ");
        System.out.println("in either tag/value or RDF/XML format");
    }
}

