/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import org.spdx.rdfparser.SPDXStandardLicense;

public class LicenseRDFAGenerator {
    static final HashSet<Character> INVALID_FILE_CHARS = new HashSet();
    static int MIN_ARGS;
    static int MAX_ARGS;
    static final String CSS_TEMPLATE_FILE = "resources/screen.css";
    static final String CSS_FILE_NAME = "screen.css";
    static final String LICENSE_HTML_TEMPLATE_FILENAME = "resources/LicenseHTMLTemplate.txt";
    static final String TOC_HTML_TEMPLATE_FILENAME = "resources/TocHTMLTemplate.txt";
    static final String TEXT_FOLDER_NAME = "text";
    static final String TEMPLATE_FOLDER_NAME = "template";
    static final String HTML_FOLDER_NAME = "html";

    /*
     * Exception decompiling
     */
    public static void main(String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 88[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String textFileToString(File htmlTemplateFile) {
        FileInputStream fis = null;
        InputStreamReader reader = null;
        BufferedReader in = null;
        String retval = null;
        try {
            fis = new FileInputStream(htmlTemplateFile);
            reader = new InputStreamReader((InputStream)fis, "UTF-8");
            in = new BufferedReader(reader);
            StringBuilder sb = new StringBuilder();
            String line = in.readLine();
            while (line != null) {
                sb.append(line);
                sb.append('\n');
                line = in.readLine();
            }
            retval = sb.toString();
        }
        catch (IOException e) {
            System.out.println("IO Error copying HTML template files: " + e.getMessage());
            String string = null;
            return string;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    System.out.println("Warning - error closing HTML template file.  Processing will continue.  Error: " + e.getMessage());
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    System.out.println("Warning - error closing HTML template file.  Processing will continue.  Error: " + e.getMessage());
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    System.out.println("Warning - error closing HTML template file.  Processing will continue.  Error: " + e.getMessage());
                }
            }
        }
        return retval;
    }

    private static void writeCssFile(File dir) throws IOException {
        File cssFile = new File(dir.getPath() + File.separator + CSS_FILE_NAME);
        if (cssFile.exists()) {
            return;
        }
        File cssTemplateFile = new File(CSS_TEMPLATE_FILE);
        Files.copy((File)cssTemplateFile, (File)cssFile);
    }

    private static String formLicenseHTMLFileName(SPDXStandardLicense license) {
        StringBuilder sb = new StringBuilder();
        String licId = license.getId();
        for (int i = 0; i < licId.length(); ++i) {
            if (INVALID_FILE_CHARS.contains(Character.valueOf(licId.charAt(i)))) {
                sb.append('_');
                continue;
            }
            sb.append(licId.charAt(i));
        }
        return sb.toString();
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("LicenseRDFAGenerator licenseSpreadsheet.xls outputDirectory [version] [releasedate]");
        System.out.println("   Note - if version or release date is not specified, the information will be taken from the spreadsheet.");
    }

    static {
        INVALID_FILE_CHARS.add(Character.valueOf('\\'));
        INVALID_FILE_CHARS.add(Character.valueOf('/'));
        INVALID_FILE_CHARS.add(Character.valueOf('*'));
        INVALID_FILE_CHARS.add(Character.valueOf('<'));
        INVALID_FILE_CHARS.add(Character.valueOf('>'));
        INVALID_FILE_CHARS.add(Character.valueOf('['));
        INVALID_FILE_CHARS.add(Character.valueOf(']'));
        INVALID_FILE_CHARS.add(Character.valueOf('='));
        INVALID_FILE_CHARS.add(Character.valueOf(';'));
        INVALID_FILE_CHARS.add(Character.valueOf(':'));
        INVALID_FILE_CHARS.add(Character.valueOf('\''));
        INVALID_FILE_CHARS.add(Character.valueOf('\"'));
        INVALID_FILE_CHARS.add(Character.valueOf('|'));
        INVALID_FILE_CHARS.add(Character.valueOf('\t'));
        INVALID_FILE_CHARS.add(Character.valueOf('?'));
        INVALID_FILE_CHARS.add(Character.valueOf('&'));
        INVALID_FILE_CHARS.add(Character.valueOf('\u00b3'));
        MIN_ARGS = 2;
        MAX_ARGS = 4;
    }
}

