/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.spdx.rdfparser.DOAPProject;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXDocument;
import org.spdx.rdfparser.SPDXDocumentFactory;
import org.spdx.rdfparser.SPDXFile;
import org.spdx.rdfparser.SPDXLicenseInfo;
import org.spdx.rdfparser.SPDXNonStandardLicense;
import org.spdx.rdfparser.SPDXReview;
import org.spdx.rdfparser.SPDXStandardLicense;

public class PrettyPrinter {
    static final int MIN_ARGS = 1;
    static final int MAX_ARGS = 1;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.console().printf("Usage:\n PrettyPrinter file\nwhere file is the file path to a valid SPDX RDF XML file", new Object[0]);
            return;
        }
        if (args.length > 1) {
            System.out.printf("Warning: Extra arguments will be ignored", new Object[0]);
        }
        SPDXDocument doc = null;
        try {
            doc = SPDXDocumentFactory.creatSpdxDocument(args[0]);
        }
        catch (Exception ex) {
            System.out.print("Error creating SPDX Document: " + ex.getMessage());
            return;
        }
        try {
            ArrayList<String> verify = doc.verify();
            if (verify.size() > 0) {
                System.out.println("This SPDX Document is not valid due to:");
                for (int i = 0; i < verify.size(); ++i) {
                    System.out.print("\t" + verify.get(i));
                }
            }
            PrettyPrinter.prettyPrintDoc(doc);
        }
        catch (InvalidSPDXAnalysisException e) {
            System.out.print("Error pretty printing SPDX Document: " + e.getMessage());
            return;
        }
        catch (Exception e) {
            System.out.print("Unexpected error displaying SPDX Document: " + e.getMessage());
        }
    }

    private static void prettyPrintDoc(SPDXDocument doc) throws InvalidSPDXAnalysisException {
        int i;
        SPDXStandardLicense dataLicense;
        if (doc == null) {
            System.out.println("Warning: No document to print");
            return;
        }
        if (doc.getSpdxDocUri() != null) {
            System.out.printf("SPDX Document for %1s\n", doc.getSpdxDocUri());
        }
        String spdxVersion = "";
        if (doc.getSpdxVersion() != null && doc.getCreatorInfo().getCreated() != null) {
            spdxVersion = doc.getSpdxVersion();
            System.out.printf("Version: %1s\tCreated: %2s\n", spdxVersion, doc.getCreatorInfo().getCreated());
        }
        if (!spdxVersion.equals("SPDX-0.8") && !spdxVersion.equals("SPDX-0.9") && (dataLicense = doc.getDataLicense()) != null) {
            System.out.printf("Data License: %1s\n", dataLicense.getName());
        }
        if (doc.getCreatorInfo().getCreators() != null && doc.getCreatorInfo().getCreators().length > 0) {
            System.out.println("Created by:");
            String[] creators = doc.getCreatorInfo().getCreators();
            for (i = 0; i < creators.length; ++i) {
                System.out.printf("\t%1s\n", creators[i]);
            }
        }
        if (doc.getCreatorInfo().getCreated() != null && !doc.getCreatorInfo().getCreated().isEmpty()) {
            System.out.printf("\t%1s\n", doc.getCreatorInfo().getCreated());
        }
        if (doc.getCreatorInfo().getComment() != null && !doc.getCreatorInfo().getComment().isEmpty()) {
            System.out.println("Creator comment: " + doc.getCreatorInfo().getComment());
        }
        if (doc.getReviewers() != null && doc.getReviewers().length > 0) {
            System.out.println("Reviewed by:");
            SPDXReview[] reviewedBy = doc.getReviewers();
            for (i = 0; i < reviewedBy.length; ++i) {
                if (reviewedBy[i].getComment() != null && !reviewedBy[i].getComment().isEmpty()) {
                    System.out.printf("\t%1s\t%2s\tComment:%3s\n", reviewedBy[i].getReviewer(), reviewedBy[i].getReviewDate(), reviewedBy[i].getComment());
                    continue;
                }
                System.out.printf("\t%1s\t%2s\n", reviewedBy[i].getReviewer(), reviewedBy[i].getReviewDate());
            }
        }
        PrettyPrinter.prettyPrintPackage(doc.getSpdxPackage());
        if (doc.getExtractedLicenseInfos() != null && doc.getExtractedLicenseInfos().length > 0) {
            SPDXNonStandardLicense[] nonStandardLic = doc.getExtractedLicenseInfos();
            System.out.println("Non-Standard Licenses:");
            for (i = 0; i < nonStandardLic.length; ++i) {
                PrettyPrinter.prettyPrintLicense(nonStandardLic[i]);
            }
        }
    }

    private static void prettyPrintLicense(SPDXNonStandardLicense license) {
        if (license.getId() != null && !license.getId().isEmpty()) {
            System.out.printf("\tLicense ID: %1s", license.getId());
        }
        if (license.getText() != null && !license.getText().isEmpty()) {
            System.out.printf("\tText: %1s", license.getText());
        }
        System.out.println();
    }

    private static void prettyPrintPackage(SPDXDocument.SPDXPackage pkg) throws InvalidSPDXAnalysisException {
        if (pkg.getDeclaredName() != null && !pkg.getDeclaredName().isEmpty()) {
            System.out.printf("Package Name: %1s\n", pkg.getDeclaredName());
        }
        if (pkg.getShortDescription() != null && !pkg.getShortDescription().isEmpty()) {
            System.out.println(pkg.getShortDescription());
        }
        if (pkg.getSourceInfo() != null && !pkg.getSourceInfo().isEmpty()) {
            System.out.printf("Additional Information: %1s\n", pkg.getSourceInfo());
        }
        if (pkg.getFileName() != null && !pkg.getFileName().isEmpty()) {
            System.out.printf("File name: %1s\n", pkg.getFileName());
        }
        if (pkg.getSupplier() != null && !pkg.getSupplier().isEmpty()) {
            System.out.printf("Supplier: %1s\n", pkg.getSupplier());
        }
        if (pkg.getOriginator() != null && !pkg.getOriginator().isEmpty()) {
            System.out.printf("Originator: %1s\n", pkg.getOriginator());
        }
        if (pkg.getSha1() != null && !pkg.getSha1().isEmpty()) {
            System.out.printf("SHA1: %1s\n", pkg.getSha1());
        }
        if (pkg.getVerificationCode() != null && pkg.getVerificationCode().getValue() != null && !pkg.getVerificationCode().getValue().isEmpty()) {
            System.out.printf("Verification: %1s\n", pkg.getVerificationCode().getValue());
        }
        if (pkg.getDescription() != null && !pkg.getDescription().isEmpty()) {
            System.out.printf("Description: %1s\n", pkg.getDescription());
        }
        if (pkg.getDeclaredCopyright() != null && !pkg.getDeclaredCopyright().isEmpty()) {
            System.out.printf("Declared Copyright: %1s\n", pkg.getDeclaredCopyright());
        }
        if (pkg.getDeclaredLicense() != null) {
            System.out.println("License declared: " + pkg.getDeclaredLicense());
        }
        if (pkg.getConcludedLicenses() != null) {
            System.out.println("License concluded: " + pkg.getConcludedLicenses());
        }
        if (pkg.getLicenseInfoFromFiles() != null && pkg.getLicenseInfoFromFiles().length > 0) {
            SPDXLicenseInfo[] licenses = pkg.getLicenseInfoFromFiles();
            System.out.println("Licenses from files:");
            for (int i = 0; i < licenses.length; ++i) {
                System.out.printf("\t%1s\n", licenses[i].toString());
            }
        }
        if (pkg.getLicenseComment() != null && !pkg.getLicenseComment().isEmpty()) {
            System.out.println("License comments: " + pkg.getLicenseComment());
        }
        if (pkg.getFiles() != null && pkg.getFiles().length > 0) {
            List<Object> sortedFileList = new ArrayList();
            sortedFileList = Arrays.asList(pkg.getFiles());
            Collections.sort(sortedFileList);
            for (SPDXFile sPDXFile : sortedFileList) {
                PrettyPrinter.prettyPrintFile(sPDXFile);
            }
        }
    }

    private static void prettyPrintFile(SPDXFile file) {
        int i;
        if (file.getName() != null && !file.getName().isEmpty()) {
            System.out.printf("File Name: %1s\n", file.getName());
        }
        if (file.getType() != null && !file.getType().isEmpty()) {
            System.out.printf("\tFile Type: %1s\n", file.getType());
        }
        if (file.getSha1() != null && !file.getSha1().isEmpty()) {
            System.out.printf("\tSHA1: %1s\n", file.getSha1());
        }
        if (file.getConcludedLicenses() != null) {
            System.out.println("\tConcluded license: " + file.getConcludedLicenses().toString());
        }
        if (file.getSeenLicenses() != null && file.getSeenLicenses().length > 0) {
            System.out.print("\tLicense information from file: ");
            System.out.print(file.getSeenLicenses()[0].toString());
            for (i = 1; i < file.getSeenLicenses().length; ++i) {
                System.out.print(", " + file.getSeenLicenses()[i].toString());
            }
            System.out.println();
        }
        if (file.getLicenseComments() != null && !file.getLicenseComments().isEmpty()) {
            System.out.println("\tLicense comments: " + file.getLicenseComments());
        }
        if (file.getCopyright() != null && !file.getCopyright().isEmpty()) {
            System.out.println("\tFile copyright: " + file.getCopyright());
        }
        if (file.getArtifactOf() != null && file.getArtifactOf().length > 0) {
            for (i = 0; i < file.getArtifactOf().length; ++i) {
                PrettyPrinter.prettyPrintProject(file.getArtifactOf()[i]);
            }
        }
    }

    private static void prettyPrintProject(DOAPProject doapProject) {
        if (doapProject.getName() != null && !doapProject.getName().isEmpty()) {
            System.out.println("\t\tArtifact of Project: " + doapProject.getName());
        }
        if (doapProject.getHomePage() != null && !doapProject.getHomePage().isEmpty()) {
            System.out.println("\t\tArtifact of home page: " + doapProject.getHomePage());
        }
        if (doapProject.getProjectUri() != null && !doapProject.getProjectUri().isEmpty() && !doapProject.getProjectUri().equals("UNKNOWN")) {
            System.out.println("\t\tArtifact of DOAP URI: " + doapProject.getProjectUri());
        }
    }
}

