/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import com.sampullara.mustache.Mustache;
import com.sampullara.mustache.MustacheBuilder;
import com.sampullara.mustache.MustacheException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import org.spdx.html.MustacheMap;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXDocument;
import org.spdx.rdfparser.SPDXDocumentFactory;

public class RdfToHtml {
    static final String TEMPLATE_CLASS_PATH = "resources/htmlTemplate";
    static final String TEMPLATE_ROOT_PATH = "resources" + File.separator + "htmlTemplate";
    static final String SPDX_HTML_TEMPLATE = "SpdxHTMLTemplate.html";
    static final int MIN_ARGS = 2;
    static final int MAX_ARGS = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        File spdxFile;
        if (args.length < 2) {
            RdfToHtml.usage();
            return;
        }
        if (args.length > 2) {
            System.out.println("Warning: Extra arguments will be ignored");
            RdfToHtml.usage();
        }
        if (!(spdxFile = new File(args[0])).exists()) {
            System.out.println("SPDX File " + args[0] + " does not exist.");
            RdfToHtml.usage();
            return;
        }
        if (!spdxFile.canRead()) {
            System.out.println("Can not read SPDX File " + args[0] + ".  Check permissions on the file.");
            RdfToHtml.usage();
            return;
        }
        File outputHtmlFile = new File(args[1]);
        if (outputHtmlFile.exists()) {
            System.out.println("Can not create output file " + args[1] + ", already exists.");
            RdfToHtml.usage();
            return;
        }
        Writer writer = null;
        try {
            SPDXDocument doc = SPDXDocumentFactory.creatSpdxDocument(args[0]);
            writer = new FileWriter(outputHtmlFile);
            RdfToHtml.rdfToHtml(doc, writer);
        }
        catch (IOException e) {
            System.out.println("IO Error opening SPDX Document");
            RdfToHtml.usage();
            return;
        }
        catch (InvalidSPDXAnalysisException e) {
            System.out.println("Invalid SPDX Document: " + e.getMessage());
            RdfToHtml.usage();
            return;
        }
        catch (MustacheException e) {
            System.out.println("Unexpected error reading the HTML template: " + e.getMessage());
            RdfToHtml.usage();
            return;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    System.out.println("Warning: error closing HTML file: " + e.getMessage());
                }
                writer = null;
            }
        }
    }

    private static void usage() {
        System.out.println("Usage: RdfToHtml rdfxmlfile.rdf htmlfile.html\nwhere rdfxmlfile.rdf is a valid SPDX RDF XML file and htmlfile.html is\nthe output html file.");
    }

    public static void rdfToHtml(SPDXDocument doc, Writer writer, String templateDirName, String templateFileName) throws MustacheException, IOException, InvalidSPDXAnalysisException {
        MustacheBuilder builder = new MustacheBuilder(templateDirName);
        HashMap<String, Object> mustacheMap = MustacheMap.buildMustachMap(doc);
        Mustache mustache = builder.parseFile(templateFileName);
        mustache.execute(writer, mustacheMap);
    }

    public static void rdfToHtml(SPDXDocument doc, Writer writer) throws MustacheException, IOException, InvalidSPDXAnalysisException {
        String templateDir = TEMPLATE_ROOT_PATH;
        File templateDirectoryRoot = new File(templateDir);
        if (!templateDirectoryRoot.exists() || !templateDirectoryRoot.isDirectory()) {
            templateDir = TEMPLATE_CLASS_PATH;
        }
        RdfToHtml.rdfToHtml(doc, writer, templateDir, SPDX_HTML_TEMPLATE);
    }
}

