/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXCreatorInformation;
import org.spdx.rdfparser.SPDXDocument;
import org.spdx.rdfparser.SPDXDocumentFactory;
import org.spdx.rdfparser.SPDXFile;
import org.spdx.rdfparser.SPDXNonStandardLicense;
import org.spdx.rdfparser.SPDXPackageInfo;
import org.spdx.rdfparser.SPDXReview;
import org.spdx.rdfparser.SPDXStandardLicense;
import org.spdx.spdxspreadsheet.NonStandardLicensesSheet;
import org.spdx.spdxspreadsheet.OriginsSheet;
import org.spdx.spdxspreadsheet.PackageInfoSheet;
import org.spdx.spdxspreadsheet.PerFileSheet;
import org.spdx.spdxspreadsheet.ReviewersSheet;
import org.spdx.spdxspreadsheet.SPDXSpreadsheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public class RdfToSpreadsheet {
    static final int MIN_ARGS = 2;
    static final int MAX_ARGS = 2;
    static Pattern datePattern = Pattern.compile(".. ... \\d\\d\\d\\d \\d\\d:\\d\\d:\\d\\d GMT$");
    public static final String NOT_SUPPORTED_STRING = "This field is not yet supported by SPDX";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 2) {
            RdfToSpreadsheet.usage();
            return;
        }
        if (args.length > 2) {
            RdfToSpreadsheet.usage();
            return;
        }
        File spdxRdfFile = new File(args[0]);
        if (!spdxRdfFile.exists()) {
            System.out.printf("Error: File %1$s does not exist.\n", args[0]);
            return;
        }
        File spdxSpreadsheetFile = new File(args[1]);
        if (spdxSpreadsheetFile.exists()) {
            System.out.println("Spreadsheet file already exists - please specify a new file.");
            return;
        }
        SPDXDocument doc = null;
        try {
            doc = SPDXDocumentFactory.creatSpdxDocument(args[0]);
        }
        catch (InvalidSPDXAnalysisException ex) {
            System.out.print("Error creating SPDX Document: " + ex.getMessage());
            return;
        }
        catch (IOException e) {
            System.out.print("Unable to open file :" + args[0] + ", " + e.getMessage());
        }
        SPDXSpreadsheet ss = null;
        try {
            ss = new SPDXSpreadsheet(spdxSpreadsheetFile, true, false);
            RdfToSpreadsheet.copyRdfXmlToSpreadsheet(doc, ss);
            ArrayList<String> verify = doc.verify();
            if (verify.size() > 0) {
                System.out.println("Warning: The following verifications failed for the resultant SPDX RDF file:");
                for (int i = 0; i < verify.size(); ++i) {
                    System.out.println("\t" + verify.get(i));
                }
            }
        }
        catch (SpreadsheetException e) {
            System.out.println("Error opening or writing to spreadsheet: " + e.getMessage());
        }
        catch (InvalidSPDXAnalysisException e) {
            System.out.println("Error translating the RDF file: " + e.getMessage());
        }
        catch (Exception ex) {
            System.out.println("Unexpected error translating the RDF to spreadsheet: " + ex.getMessage());
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (SpreadsheetException e) {
                    System.out.println("Error closing spreadsheet: " + e.getMessage());
                }
            }
        }
    }

    public static void copyRdfXmlToSpreadsheet(SPDXDocument doc, SPDXSpreadsheet ss) throws InvalidSPDXAnalysisException {
        if (doc == null) {
            System.out.println("Warning: No document to copy");
            return;
        }
        RdfToSpreadsheet.copyOrigins(doc, ss.getOriginsSheet());
        RdfToSpreadsheet.copyPackageInfo(doc.getSpdxPackage(), ss.getPackageInfoSheet());
        RdfToSpreadsheet.copyNonStdLicenses(doc.getExtractedLicenseInfos(), ss.getNonStandardLicensesSheet());
        RdfToSpreadsheet.copyPerFileInfo(doc.getSpdxPackage().getFiles(), ss.getPerFileSheet());
        RdfToSpreadsheet.copyReviewerInfo(doc.getReviewers(), ss.getReviewersSheet());
    }

    private static void copyReviewerInfo(SPDXReview[] reviewers, ReviewersSheet reviewersSheet) throws InvalidSPDXAnalysisException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        for (int i = 0; i < reviewers.length; ++i) {
            String reviewerName = reviewers[i].getReviewer();
            Date reviewDate = null;
            String dateString = reviewers[i].getReviewDate();
            if (dateString != null && !dateString.isEmpty()) {
                try {
                    dateString = dateString.trim();
                    reviewDate = dateFormat.parse(dateString);
                }
                catch (Exception ex) {
                    throw new InvalidSPDXAnalysisException("Invalid reviewer date format for reviewer " + reviewers[i]);
                }
            }
            reviewersSheet.addReviewer(reviewerName, reviewDate, reviewers[i].getComment());
        }
    }

    private static void copyPerFileInfo(SPDXFile[] files, PerFileSheet perFileSheet) {
        List<Object> sortedFileList = new ArrayList();
        sortedFileList = Arrays.asList(files);
        Collections.sort(sortedFileList);
        for (SPDXFile sPDXFile : sortedFileList) {
            perFileSheet.add(sPDXFile);
        }
    }

    private static void copyNonStdLicenses(SPDXNonStandardLicense[] nonStandardLicenses, NonStandardLicensesSheet nonStandardLicensesSheet) {
        for (int i = 0; i < nonStandardLicenses.length; ++i) {
            nonStandardLicensesSheet.add(nonStandardLicenses[i].getId(), nonStandardLicenses[i].getText(), nonStandardLicenses[i].getLicenseName(), nonStandardLicenses[i].getSourceUrls(), nonStandardLicenses[i].getComment());
        }
    }

    private static void copyPackageInfo(SPDXDocument.SPDXPackage spdxPackage, PackageInfoSheet packageInfoSheet) throws InvalidSPDXAnalysisException {
        SPDXPackageInfo pkgInfo = spdxPackage.getPackageInfo();
        packageInfoSheet.add(pkgInfo);
    }

    private static void copyOrigins(SPDXDocument doc, OriginsSheet originsSheet) throws InvalidSPDXAnalysisException {
        String licenseListVersion;
        String comments;
        originsSheet.setSPDXVersion(doc.getSpdxVersion());
        SPDXCreatorInformation creator = doc.getCreatorInfo();
        String[] createdBys = creator.getCreators();
        originsSheet.setCreatedBy(createdBys);
        SPDXStandardLicense dataLicense = doc.getDataLicense();
        if (dataLicense != null) {
            originsSheet.setDataLicense(dataLicense.getId());
        }
        if ((comments = creator.getComment()) != null && !comments.isEmpty()) {
            originsSheet.setAuthorComments(comments);
        }
        String created = creator.getCreated();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        try {
            originsSheet.setCreated(dateFormat.parse(created));
        }
        catch (ParseException e) {
            throw new InvalidSPDXAnalysisException("Invalid created date - unable to parse");
        }
        String docComment = doc.getDocumentComment();
        if (docComment != null) {
            originsSheet.setDocumentComment(docComment);
        }
        if ((licenseListVersion = doc.getCreatorInfo().getLicenseListVersion()) != null) {
            originsSheet.setLicenseListVersion(licenseListVersion);
        }
    }

    private static void usage() {
        System.out.println("Usage: RdfToSpreadsheet rdfxmlfile.rdf spreadsheetfile.xls\nwhere rdfxmlfile.rdf is a valid SPDX RDF XML file and spreadsheetfile.xls is\nthe output SPDX spreadsheeet file.");
    }
}

