/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXDocument;
import org.spdx.rdfparser.SPDXDocumentFactory;
import org.spdx.tag.CommonCode;

public class RdfToTag {
    static final int MIN_ARGS = 2;
    static final int MAX_ARGS = 2;
    static final Logger logger = Logger.getLogger((String)RdfToTag.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        File spdxRdfFile;
        if (args.length < 2) {
            RdfToTag.usage();
            return;
        }
        if (args.length > 2) {
            System.out.printf("Warning: Extra arguments will be ignored\n", new Object[0]);
            RdfToTag.usage();
        }
        if (!(spdxRdfFile = new File(args[0])).exists()) {
            System.out.printf("RDF file %1$s does not exists.\n", args[0]);
            return;
        }
        File spdxTagFile = new File(args[1]);
        if (spdxTagFile.exists()) {
            System.out.printf("Error: File %1$s already exists - please specify a new file.\n", args[1]);
            return;
        }
        try {
            if (!spdxTagFile.createNewFile()) {
                System.out.println("Could not create the new SPDX Tag file " + args[1]);
                RdfToTag.usage();
                return;
            }
        }
        catch (IOException e1) {
            System.out.println("Could not create the new SPDX Tag file " + args[1]);
            System.out.println("due to error " + e1.getMessage());
            RdfToTag.usage();
            return;
        }
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new FileWriter(spdxTagFile));
            }
            catch (IOException e1) {
                System.out.println("Could not write to the new SPDX Tag file " + args[1]);
                System.out.println("due to error " + e1.getMessage());
                RdfToTag.usage();
                if (out != null) {
                    out.flush();
                    out.close();
                }
                return;
            }
            SPDXDocument doc = null;
            try {
                doc = SPDXDocumentFactory.creatSpdxDocument(args[0]);
            }
            catch (Exception ex) {
                System.out.print("Error creating SPDX Document: " + ex.getMessage());
                if (out != null) {
                    out.flush();
                    out.close();
                }
                return;
            }
            try {
                ArrayList<String> verify = doc.verify();
                if (verify.size() > 0) {
                    System.out.println("This SPDX Document is not valid due to:");
                    for (int i = 0; i < verify.size(); ++i) {
                        System.out.println("\t" + verify.get(i));
                    }
                }
                Properties constants = CommonCode.getTextFromProperties("org/spdx/tag/SpdxTagValueConstants.properties");
                CommonCode.printDoc(doc, out, constants);
            }
            catch (InvalidSPDXAnalysisException e) {
                System.out.print("Error transalting SPDX Document to tag-value format: " + e.getMessage());
                if (out != null) {
                    out.flush();
                    out.close();
                }
                return;
            }
            catch (Exception e) {
                System.out.print("Unexpected error displaying SPDX Document: " + e.getMessage());
            }
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    private static void usage() {
        System.out.println("Usage: RdfToTag rdfxmlfile.rdf spdxfile.spdx\nwhere rdfxmlfile.rdf is a valid SPDX RDF XML file and spdxfile.spdx is\nthe output SPDX tag-value file.");
    }
}

