/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.util.ArrayList;
import java.util.Properties;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXDocument;
import org.spdx.rdfparser.SPDXDocumentFactory;
import org.spdx.tag.CommonCode;

public class SpdxViewer {
    static final int MIN_ARGS = 1;
    static final int MAX_ARGS = 1;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.console().printf("Usage:\n SPDXViewer file\nwhere file is the file path to a valid SPDX RDF XML file", new Object[0]);
            return;
        }
        if (args.length > 1) {
            System.out.printf("Warning: Extra arguments will be ignored", new Object[0]);
        }
        SPDXDocument doc = null;
        try {
            doc = SPDXDocumentFactory.creatSpdxDocument(args[0]);
        }
        catch (Exception ex) {
            System.out.print("Error creating SPDX Document: " + ex.getMessage());
            return;
        }
        try {
            ArrayList<String> verify = doc.verify();
            if (verify.size() > 0) {
                System.out.println("This SPDX Document is not valid due to:");
                for (int i = 0; i < verify.size(); ++i) {
                    System.out.print("\t" + verify.get(i) + "\n");
                }
            }
            Properties constants = CommonCode.getTextFromProperties("org/spdx/tag/SpdxViewerConstants.properties");
            CommonCode.printDoc(doc, null, constants);
        }
        catch (InvalidSPDXAnalysisException e) {
            System.out.print("Error pretty printing SPDX Document: " + e.getMessage());
            return;
        }
        catch (Exception e) {
            System.out.print("Unexpected error displaying SPDX Document: " + e.getMessage());
        }
    }
}

