/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Properties;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXDocument;
import org.spdx.spdxspreadsheet.SPDXSpreadsheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;
import org.spdx.tag.CommonCode;
import org.spdx.tools.SpreadsheetToRDF;

public class SpreadsheetToTag {
    static final int MIN_ARGS = 2;
    static final int MAX_ARGS = 2;
    static DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        block41: {
            if (args.length < 2) {
                SpreadsheetToTag.usage();
                return;
            }
            if (args.length > 2) {
                SpreadsheetToTag.usage();
                return;
            }
            File spdxSpreadsheetFile = new File(args[0]);
            if (!spdxSpreadsheetFile.exists()) {
                System.out.printf("Spreadsheet file %1$s does not exists.\n", args[0]);
                return;
            }
            File spdxTagFile = new File(args[1]);
            if (spdxTagFile.exists()) {
                System.out.printf("Error: File %1$s already exists - please specify a new file.\n", args[1]);
                return;
            }
            try {
                if (!spdxTagFile.createNewFile()) {
                    System.out.println("Could not create the new SPDX Tag file " + args[1]);
                    SpreadsheetToTag.usage();
                    return;
                }
            }
            catch (IOException e1) {
                System.out.println("Could not create the new SPDX Tag file " + args[1]);
                System.out.println("due to error " + e1.getMessage());
                SpreadsheetToTag.usage();
                return;
            }
            PrintWriter out = null;
            try {
                try {
                    out = new PrintWriter(new FileWriter(spdxTagFile));
                }
                catch (IOException e1) {
                    System.out.println("Could not write to the new SPDX Tag file " + args[1]);
                    System.out.println("due to error " + e1.getMessage());
                    SpreadsheetToTag.usage();
                    if (out != null) {
                        out.flush();
                        out.close();
                    }
                    return;
                }
                Model model = ModelFactory.createDefaultModel();
                SPDXDocument analysis = null;
                try {
                    analysis = new SPDXDocument(model);
                }
                catch (InvalidSPDXAnalysisException ex) {
                    System.out.print("Error creating SPDX Tag file: " + ex.getMessage());
                    if (out != null) {
                        out.flush();
                        out.close();
                    }
                    return;
                }
                SPDXSpreadsheet ss = null;
                try {
                    ss = new SPDXSpreadsheet(spdxSpreadsheetFile, false, true);
                    SpreadsheetToRDF.copySpreadsheetToSPDXAnalysis(ss, analysis);
                    ArrayList<String> verify = analysis.verify();
                    if (verify.size() > 0) {
                        System.out.println("Warning: The following verification errors were found in the resultant SPDX Document:");
                        for (int i = 0; i < verify.size(); ++i) {
                            System.out.println("\t" + verify.get(i));
                        }
                    }
                    Properties constants = CommonCode.getTextFromProperties("org/spdx/tag/SpdxTagValueConstants.properties");
                    CommonCode.printDoc(analysis, out, constants);
                }
                catch (SpreadsheetException e) {
                    System.out.println("Error creating or writing to spreadsheet: " + e.getMessage());
                }
                catch (InvalidSPDXAnalysisException e) {
                    System.out.println("Error translating the Tag file: " + e.getMessage());
                }
                catch (Exception e2) {
                    System.out.print("Unexpected error displaying SPDX Document: " + e2.getMessage());
                    break block41;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (ss != null) {
                        try {
                            ss.close();
                        }
                        catch (SpreadsheetException e) {
                            System.out.println("Error closing spreadsheet: " + e.getMessage());
                        }
                    }
                }
            }
            finally {
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
        }
    }

    private static void usage() {
        System.out.println("Usage: SpreadsheetToTag spreadsheetfile.xls spdxfile.spdx \nwhere spreadsheetfile.xls is a valid SPDX Spreadsheet and\nspdxfile.spdx is the output SPDX tag-value file.");
    }
}

