/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Properties;
import org.spdx.rdfparser.SPDXDocument;
import org.spdx.tag.BuildDocument;
import org.spdx.tag.CommonCode;
import org.spdx.tag.HandBuiltParser;
import org.spdx.tag.NoCommentInputStream;

public class TagToRDF {
    static final int MIN_ARGS = 2;
    static final int MAX_ARGS = 3;
    static final String OUTPUT_XML_ABBREV = "RDF/XML-ABBREV";
    static final String OUTPUT_XML = "RDF/XML";
    static final String OUTPUT_N_TRIPLET = "N-TRIPLET";
    static final String OUTPUT_TURTLE = "TURTLE";
    static final String DEFAULT_OUTPUT_FORMAT = "RDF/XML-ABBREV";
    static final HashSet<String> AVAILABLE_OUTPUT_TYPES = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        FileOutputStream out;
        File spdxRDFFile;
        FileInputStream spdxTagStream;
        String outputFormat;
        block37: {
            if (args.length < 2) {
                TagToRDF.usage();
                return;
            }
            if (args.length > 3) {
                TagToRDF.usage();
                return;
            }
            outputFormat = "RDF/XML-ABBREV";
            if (args.length > 2 && !AVAILABLE_OUTPUT_TYPES.contains(outputFormat = args[2])) {
                System.out.println("Invalid output format type.");
                TagToRDF.usage();
                return;
            }
            try {
                spdxTagStream = new FileInputStream(args[0]);
            }
            catch (FileNotFoundException ex) {
                System.out.printf("Tag-Value file %1$s does not exists.\n", args[0]);
                return;
            }
            spdxRDFFile = new File(args[1]);
            if (spdxRDFFile.exists()) {
                System.out.printf("Error: File %1$s already exists - please specify a new file.\n", args[1]);
                try {
                    spdxTagStream.close();
                }
                catch (IOException e) {
                    System.out.println("Warning: Unable to close input file on error.");
                }
                return;
            }
            try {
                if (spdxRDFFile.createNewFile()) break block37;
                System.out.println("Could not create the new SPDX RDF file " + args[1]);
                TagToRDF.usage();
                try {
                    spdxTagStream.close();
                }
                catch (IOException e) {
                    System.out.println("Warning: Unable to close input file on error.");
                }
                return;
            }
            catch (IOException e1) {
                System.out.println("Could not create the new SPDX Tag-Value file " + args[1]);
                System.out.println("due to error " + e1.getMessage());
                TagToRDF.usage();
                try {
                    spdxTagStream.close();
                }
                catch (IOException e) {
                    System.out.println("Warning: Unable to close input file on error.");
                }
                return;
            }
        }
        try {
            out = new FileOutputStream(spdxRDFFile);
        }
        catch (FileNotFoundException e1) {
            System.out.println("Could not write to the new SPDX RDF file " + args[1]);
            System.out.println("due to error " + e1.getMessage());
            TagToRDF.usage();
            try {
                spdxTagStream.close();
            }
            catch (IOException e) {
                System.out.println("Warning: Unable to close input file on error.");
            }
            return;
        }
        try {
            TagToRDF.convertTagFileToRdf(spdxTagStream, out, outputFormat);
        }
        catch (Exception e) {
            System.err.println("Error creating SPDX Analysis: " + e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    System.out.println("Error closing RDF file: " + e.getMessage());
                }
            }
            if (spdxTagStream != null) {
                try {
                    spdxTagStream.close();
                }
                catch (IOException e) {
                    System.out.println("Error closing Tag/Value file: " + e.getMessage());
                }
            }
        }
    }

    public static void convertTagFileToRdf(InputStream spdxTagFile, OutputStream out, String outputFormat) throws RecognitionException, TokenStreamException, Exception {
        Properties constants = CommonCode.getTextFromProperties("org/spdx/tag/SpdxTagValueConstants.properties");
        NoCommentInputStream nci = new NoCommentInputStream(spdxTagFile);
        HandBuiltParser parser = new HandBuiltParser(new DataInputStream(nci));
        Model model = ModelFactory.createDefaultModel();
        SPDXDocument analysis = new SPDXDocument(model);
        parser.setBehavior(new BuildDocument(model, analysis, constants));
        parser.data();
        model.write(out, outputFormat);
    }

    private static void usage() {
        System.out.println("Usage: TagToRDF spdxfile.spdx rdfxmlfile.rdf [outputFormat]\nwhere spdxfile.spdx is a valid SPDX tag-value file, \nrdfxmlfile.rdf is the output SPDX RDF analysis file and \n[outputFormat] is an optional format for the XML document.\n[outputFormat] must be one of RDF/XML-ABBREV (default), RDF/XML, N-TRIPLET, or TURTLE.");
    }

    static {
        AVAILABLE_OUTPUT_TYPES.add(OUTPUT_N_TRIPLET);
        AVAILABLE_OUTPUT_TYPES.add(OUTPUT_TURTLE);
        AVAILABLE_OUTPUT_TYPES.add("RDF/XML-ABBREV");
        AVAILABLE_OUTPUT_TYPES.add(OUTPUT_XML);
    }
}

