/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.jruby;

import com.github.mustachejava.reflect.ReflectionObjectHandler;
import com.github.mustachejava.util.Wrapper;
import com.google.common.base.Predicate;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nullable;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyHash;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;

public class JRubyObjectHandler
extends ReflectionObjectHandler {
    private static final Method CALL_METHOD;

    @Override
    public Object coerce(Object object) {
        if (object instanceof RubyBoolean) {
            RubyBoolean rb = (RubyBoolean)object;
            return rb.toJava(Boolean.class);
        }
        return object;
    }

    @Override
    protected Wrapper findWrapper(final int scopeIndex, Wrapper[] wrappers, List<Predicate<Object[]>> guards, Object scope, final String name) {
        Wrapper wrapper = super.findWrapper(scopeIndex, wrappers, guards, scope, name);
        if (wrapper == null) {
            if (scope instanceof RubyHash) {
                RubyHash hash = (RubyHash)scope;
                final RubySymbol rs = RubySymbol.newSymbol((Ruby)hash.getRuntime(), (String)name);
                if (hash.get((Object)rs) != null) {
                    guards.add(new Predicate<Object[]>(){

                        @Override
                        public boolean apply(@Nullable Object[] input) {
                            return ((RubyHash)input[scopeIndex]).containsKey((Object)rs);
                        }
                    });
                    return this.createWrapper(scopeIndex, wrappers, guards, MAP_METHOD, new Object[]{rs});
                }
                guards.add(new Predicate<Object[]>(){

                    @Override
                    public boolean apply(@Nullable Object[] input) {
                        return !((RubyHash)input[scopeIndex]).containsKey((Object)rs);
                    }
                });
            }
            if (scope instanceof RubyObject) {
                RubyObject ro = (RubyObject)scope;
                if (ro.respondsTo(name)) {
                    guards.add(new Predicate<Object[]>(){

                        @Override
                        public boolean apply(@Nullable Object[] objects) {
                            RubyObject scope = (RubyObject)objects[scopeIndex];
                            return scope.respondsTo(name);
                        }
                    });
                    return this.createWrapper(scopeIndex, wrappers, guards, CALL_METHOD, new Object[]{name});
                }
                guards.add(new Predicate<Object[]>(){

                    @Override
                    public boolean apply(@Nullable Object[] objects) {
                        RubyObject scope = (RubyObject)objects[scopeIndex];
                        return !scope.respondsTo(name);
                    }
                });
            }
        }
        return wrapper;
    }

    static {
        try {
            CALL_METHOD = RubyHash.class.getMethod("callMethod", String.class);
        }
        catch (NoSuchMethodException e2) {
            throw new AssertionError((Object)e2);
        }
    }
}

