/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.Buffer;
import com.googlecode.javaewah.BufferedRunningLengthWord;
import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.EWAHIterator;
import com.googlecode.javaewah.IteratingRLW;

public final class IteratingBufferedRunningLengthWord
implements IteratingRLW,
Cloneable {
    private BufferedRunningLengthWord brlw;
    private final Buffer buffer;
    private int literalWordStartPosition;
    private EWAHIterator iterator;

    public IteratingBufferedRunningLengthWord(EWAHIterator iterator) {
        this.iterator = iterator;
        this.brlw = new BufferedRunningLengthWord(this.iterator.next());
        this.literalWordStartPosition = this.iterator.literalWords() + this.brlw.literalWordOffset;
        this.buffer = this.iterator.buffer();
    }

    public IteratingBufferedRunningLengthWord(EWAHCompressedBitmap bitmap) {
        this(EWAHIterator.getEWAHIterator(bitmap));
    }

    @Override
    public void discardFirstWords(long x) {
        while (x > 0L) {
            if (this.brlw.runningLength > x) {
                this.brlw.runningLength -= x;
                return;
            }
            this.brlw.runningLength = 0L;
            long toDiscard = (x -= this.brlw.runningLength) > (long)this.brlw.numberOfLiteralWords ? (long)this.brlw.numberOfLiteralWords : x;
            this.literalWordStartPosition = (int)((long)this.literalWordStartPosition + toDiscard);
            this.brlw.numberOfLiteralWords = (int)((long)this.brlw.numberOfLiteralWords - toDiscard);
            if ((x -= toDiscard) <= 0L && this.brlw.size() != 0L) continue;
            if (!this.iterator.hasNext()) break;
            this.brlw.reset(this.iterator.next());
            this.literalWordStartPosition = this.iterator.literalWords();
        }
    }

    @Override
    public void discardRunningWords() {
        this.brlw.runningLength = 0L;
        if (this.brlw.getNumberOfLiteralWords() == 0) {
            this.next();
        }
    }

    @Override
    public boolean next() {
        if (!this.iterator.hasNext()) {
            this.brlw.numberOfLiteralWords = 0;
            this.brlw.runningLength = 0L;
            return false;
        }
        this.brlw.reset(this.iterator.next());
        this.literalWordStartPosition = this.iterator.literalWords();
        return true;
    }

    public long discharge(BitmapStorage container2, long max2) {
        long index;
        int pd;
        for (index = 0L; index < max2 && this.size() > 0L; index += (long)pd) {
            long pl = this.getRunningLength();
            if (index + pl > max2) {
                pl = max2 - index;
            }
            container2.addStreamOfEmptyWords(this.getRunningBit(), pl);
            pd = this.getNumberOfLiteralWords();
            if ((long)pd + (index += pl) > max2) {
                pd = (int)(max2 - index);
            }
            this.writeLiteralWords(pd, container2);
            this.discardFirstWords(pl + (long)pd);
        }
        return index;
    }

    public long dischargeNegated(BitmapStorage container2, long max2) {
        long index;
        int pd;
        for (index = 0L; index < max2 && this.size() > 0L; index += (long)pd) {
            long pl = this.getRunningLength();
            if (index + pl > max2) {
                pl = max2 - index;
            }
            container2.addStreamOfEmptyWords(!this.getRunningBit(), pl);
            pd = this.getNumberOfLiteralWords();
            if ((long)pd + (index += pl) > max2) {
                pd = (int)(max2 - index);
            }
            this.writeNegatedLiteralWords(pd, container2);
            this.discardFirstWords(pl + (long)pd);
        }
        return index;
    }

    public void dischargeAsEmpty(BitmapStorage container2) {
        while (this.size() > 0L) {
            container2.addStreamOfEmptyWords(false, this.size());
            this.discardFirstWords(this.size());
        }
    }

    public void discharge(BitmapStorage container2) {
        this.brlw.literalWordOffset = this.literalWordStartPosition - this.iterator.literalWords();
        IteratingBufferedRunningLengthWord.discharge(this.brlw, this.iterator, container2);
    }

    @Override
    public long getLiteralWordAt(int index) {
        return this.buffer.getWord(this.literalWordStartPosition + index);
    }

    @Override
    public int getNumberOfLiteralWords() {
        return this.brlw.numberOfLiteralWords;
    }

    @Override
    public boolean getRunningBit() {
        return this.brlw.runningBit;
    }

    @Override
    public long getRunningLength() {
        return this.brlw.runningLength;
    }

    @Override
    public long size() {
        return this.brlw.size();
    }

    public void writeLiteralWords(int numWords, BitmapStorage container2) {
        container2.addStreamOfLiteralWords(this.buffer, this.literalWordStartPosition, numWords);
    }

    public void writeNegatedLiteralWords(int numWords, BitmapStorage container2) {
        container2.addStreamOfNegatedLiteralWords(this.buffer, this.literalWordStartPosition, numWords);
    }

    private static void discharge(BufferedRunningLengthWord initialWord, EWAHIterator iterator, BitmapStorage container2) {
        BufferedRunningLengthWord runningLengthWord = initialWord;
        while (true) {
            long runningLength = runningLengthWord.getRunningLength();
            container2.addStreamOfEmptyWords(runningLengthWord.getRunningBit(), runningLength);
            container2.addStreamOfLiteralWords(iterator.buffer(), iterator.literalWords() + runningLengthWord.literalWordOffset, runningLengthWord.getNumberOfLiteralWords());
            if (!iterator.hasNext()) break;
            runningLengthWord = new BufferedRunningLengthWord(iterator.next());
        }
    }

    @Override
    public IteratingBufferedRunningLengthWord clone() throws CloneNotSupportedException {
        IteratingBufferedRunningLengthWord answer = (IteratingBufferedRunningLengthWord)super.clone();
        answer.brlw = this.brlw.clone();
        answer.iterator = this.iterator.clone();
        return answer;
    }
}

