/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.impl;

import java.util.HashMap;
import nu.validator.htmlparser.annotation.Inline;
import nu.validator.htmlparser.annotation.NoLength;
import nu.validator.htmlparser.common.TokenHandler;
import nu.validator.htmlparser.common.TransitionHandler;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.impl.ElementName;
import nu.validator.htmlparser.impl.HtmlAttributes;
import nu.validator.htmlparser.impl.Tokenizer;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorReportingTokenizer
extends Tokenizer {
    private static final int SURROGATE_OFFSET = -56613888;
    private XmlViolationPolicy contentNonXmlCharPolicy = XmlViolationPolicy.ALTER_INFOSET;
    private boolean alreadyComplainedAboutNonAscii;
    private boolean alreadyWarnedAboutPrivateUseCharacters;
    private int line;
    private int linePrev;
    private int col;
    private int colPrev;
    private boolean nextCharOnNewLine;
    private char prev;
    private HashMap<String, String> errorProfileMap = null;
    private TransitionHandler transitionHandler = null;
    private int transitionBaseOffset = 0;

    public ErrorReportingTokenizer(TokenHandler tokenHandler, boolean newAttributesEachTime) {
        super(tokenHandler, newAttributesEachTime);
    }

    public ErrorReportingTokenizer(TokenHandler tokenHandler) {
        super(tokenHandler);
    }

    @Override
    public int getLineNumber() {
        if (this.line > 0) {
            return this.line;
        }
        return -1;
    }

    @Override
    public int getColumnNumber() {
        if (this.col > 0) {
            return this.col;
        }
        return -1;
    }

    @Override
    public void setContentNonXmlCharPolicy(XmlViolationPolicy contentNonXmlCharPolicy) {
        this.contentNonXmlCharPolicy = contentNonXmlCharPolicy;
    }

    public void setErrorProfile(HashMap<String, String> errorProfileMap) {
        this.errorProfileMap = errorProfileMap;
    }

    public void note(String profile, String message) throws SAXException {
        if (this.errorProfileMap == null) {
            return;
        }
        String level = this.errorProfileMap.get(profile);
        if ("warn".equals(level)) {
            this.warn(message);
        } else if ("err".equals(level)) {
            this.err(message);
        }
    }

    protected void startErrorReporting() throws SAXException {
        this.alreadyComplainedAboutNonAscii = false;
        this.linePrev = 0;
        this.line = 0;
        this.colPrev = 1;
        this.col = 1;
        this.nextCharOnNewLine = true;
        this.prev = '\u0000';
        this.alreadyWarnedAboutPrivateUseCharacters = false;
        this.transitionBaseOffset = 0;
    }

    @Inline
    protected void silentCarriageReturn() {
        this.nextCharOnNewLine = true;
        this.lastCR = true;
    }

    @Inline
    protected void silentLineFeed() {
        this.nextCharOnNewLine = true;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getCol() {
        return this.col;
    }

    @Override
    public boolean isNextCharOnNewLine() {
        return this.nextCharOnNewLine;
    }

    private void complainAboutNonAscii() throws SAXException {
        String encoding = null;
        if (this.encodingDeclarationHandler != null) {
            encoding = this.encodingDeclarationHandler.getCharacterEncoding();
        }
        if (encoding == null) {
            this.err("The character encoding of the document was not explicit but the document contains non-ASCII.");
        } else {
            this.err("No explicit character encoding declaration has been seen yet (assumed \u201c" + encoding + "\u201d) but the document contains non-ASCII.");
        }
    }

    @Override
    public boolean isAlreadyComplainedAboutNonAscii() {
        return this.alreadyComplainedAboutNonAscii;
    }

    protected void flushChars(char[] buf, int pos) throws SAXException {
        if (pos > this.cstart) {
            int currLine = this.line;
            int currCol = this.col;
            this.line = this.linePrev;
            this.col = this.colPrev;
            this.tokenHandler.characters(buf, this.cstart, pos - this.cstart);
            this.line = currLine;
            this.col = currCol;
        }
        this.cstart = Integer.MAX_VALUE;
    }

    protected char checkChar(@NoLength char[] buf, int pos) throws SAXException {
        this.linePrev = this.line++;
        this.colPrev = this.col++;
        if (this.nextCharOnNewLine) {
            this.col = 1;
            this.nextCharOnNewLine = false;
        }
        char c = buf[pos];
        if (!this.confident && !this.alreadyComplainedAboutNonAscii && c > '\u007f') {
            this.complainAboutNonAscii();
            this.alreadyComplainedAboutNonAscii = true;
        }
        switch (c) {
            case '\u0000': {
                this.err("Saw U+0000 in stream.");
            }
            case '\t': 
            case '\n': 
            case '\r': {
                break;
            }
            case '\f': {
                if (this.contentNonXmlCharPolicy == XmlViolationPolicy.FATAL) {
                    this.fatal("This document is not mappable to XML 1.0 without data loss due to " + this.toUPlusString(c) + " which is not a legal XML 1.0 character.");
                    break;
                }
                if (this.contentNonXmlCharPolicy == XmlViolationPolicy.ALTER_INFOSET) {
                    buf[pos] = ' ';
                    c = ' ';
                }
                this.warn("This document is not mappable to XML 1.0 without data loss due to " + this.toUPlusString(c) + " which is not a legal XML 1.0 character.");
                break;
            }
            default: {
                if ((c & 0xFC00) == 56320) {
                    if ((this.prev & 0xFC00) != 55296) break;
                    int intVal = (this.prev << 10) + c + -56613888;
                    if ((intVal & 0xFFFE) == 65534) {
                        this.err("Astral non-character.");
                    }
                    if (!this.isAstralPrivateUse(intVal)) break;
                    this.warnAboutPrivateUseChar();
                    break;
                }
                if (c < ' ' || (c & 0xFFFE) == 65534) {
                    switch (this.contentNonXmlCharPolicy) {
                        case FATAL: {
                            this.fatal("Forbidden code point " + this.toUPlusString(c) + ".");
                            break;
                        }
                        case ALTER_INFOSET: {
                            buf[pos] = '\ufffd';
                            c = '\ufffd';
                        }
                        case ALLOW: {
                            this.err("Forbidden code point " + this.toUPlusString(c) + ".");
                        }
                    }
                    break;
                }
                if (c >= '\u007f' && c <= '\u009f' || c >= '\ufdd0' && c <= '\ufdef') {
                    this.err("Forbidden code point " + this.toUPlusString(c) + ".");
                    break;
                }
                if (!this.isPrivateUse(c)) break;
                this.warnAboutPrivateUseChar();
            }
        }
        this.prev = c;
        return c;
    }

    protected int transition(int from, int to, boolean reconsume, int pos) throws SAXException {
        if (this.transitionHandler != null) {
            this.transitionHandler.transition(from, to, reconsume, this.transitionBaseOffset + pos);
        }
        return to;
    }

    private String toUPlusString(int c) {
        String hexString = Integer.toHexString(c);
        switch (hexString.length()) {
            case 1: {
                return "U+000" + hexString;
            }
            case 2: {
                return "U+00" + hexString;
            }
            case 3: {
                return "U+0" + hexString;
            }
        }
        return "U+" + hexString;
    }

    private void warnAboutPrivateUseChar() throws SAXException {
        if (!this.alreadyWarnedAboutPrivateUseCharacters) {
            this.warn("Document uses the Unicode Private Use Area(s), which should not be used in publicly exchanged documents. (Charmod C073)");
            this.alreadyWarnedAboutPrivateUseCharacters = true;
        }
    }

    private boolean isPrivateUse(char c) {
        return c >= '\ue000' && c <= '\uf8ff';
    }

    private boolean isAstralPrivateUse(int c) {
        return c >= 983040 && c <= 1048573 || c >= 0x100000 && c <= 1114109;
    }

    protected void errGarbageAfterLtSlash() throws SAXException {
        this.err("Garbage after \u201c</\u201d.");
    }

    protected void errLtSlashGt() throws SAXException {
        this.err("Saw \u201c</>\u201d. Probable causes: Unescaped \u201c<\u201d (escape as \u201c&lt;\u201d) or mistyped end tag.");
    }

    protected void errWarnLtSlashInRcdata() throws SAXException {
        if (this.html4) {
            this.err((this.stateSave == 0 ? "CDATA" : "RCDATA") + " element \u201c" + this.endTagExpectation + "\u201d contained the string \u201c</\u201d, but it was not the start of the end tag. (HTML4-only error)");
        } else {
            this.warn((this.stateSave == 0 ? "CDATA" : "RCDATA") + " element \u201c" + this.endTagExpectation + "\u201d contained the string \u201c</\u201d, but this did not close the element.");
        }
    }

    protected void errHtml4LtSlashInRcdata(char folded) throws SAXException {
        if (this.html4 && (this.index > 0 || folded >= 'a' && folded <= 'z') && ElementName.IFRAME != this.endTagExpectation) {
            this.err((this.stateSave == 0 ? "CDATA" : "RCDATA") + " element \u201c" + this.endTagExpectation.name + "\u201d contained the string \u201c</\u201d, but it was not the start of the end tag. (HTML4-only error)");
        }
    }

    protected void errCharRefLacksSemicolon() throws SAXException {
        this.err("Character reference was not terminated by a semicolon.");
    }

    protected void errNoDigitsInNCR() throws SAXException {
        this.err("No digits after \u201c" + this.strBufToString() + "\u201d.");
    }

    protected void errGtInSystemId() throws SAXException {
        this.err("\u201c>\u201d in system identifier.");
    }

    protected void errGtInPublicId() throws SAXException {
        this.err("\u201c>\u201d in public identifier.");
    }

    protected void errNamelessDoctype() throws SAXException {
        this.err("Nameless doctype.");
    }

    protected void errConsecutiveHyphens() throws SAXException {
        this.err("Consecutive hyphens did not terminate a comment. \u201c--\u201d is not permitted inside a comment, but e.g. \u201c- -\u201d is.");
    }

    protected void errPrematureEndOfComment() throws SAXException {
        this.err("Premature end of comment. Use \u201c-->\u201d to end a comment properly.");
    }

    protected void errBogusComment() throws SAXException {
        this.err("Bogus comment.");
    }

    protected void errUnquotedAttributeValOrNull(char c) throws SAXException {
        switch (c) {
            case '<': {
                this.err("\u201c<\u201d in an unquoted attribute value. Probable cause: Missing \u201c>\u201d immediately before.");
                return;
            }
            case '`': {
                this.err("\u201c`\u201d in an unquoted attribute value. Probable cause: Using the wrong character as a quote.");
                return;
            }
            case '\ufffd': {
                return;
            }
        }
        this.err("\u201c" + c + "\u201d in an unquoted attribute value. Probable causes: Attributes running together or a URL query string in an unquoted attribute value.");
    }

    protected void errSlashNotFollowedByGt() throws SAXException {
        this.err("A slash was not immediately followed by \u201c>\u201d.");
    }

    protected void errHtml4XmlVoidSyntax() throws SAXException {
        if (this.html4) {
            this.err("The \u201c/>\u201d syntax on void elements is not allowed.  (This is an HTML4-only error.)");
        }
    }

    protected void errNoSpaceBetweenAttributes() throws SAXException {
        this.err("No space between attributes.");
    }

    protected void errHtml4NonNameInUnquotedAttribute(char c) throws SAXException {
        if (!(!this.html4 || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '-' || c == '_' || c == ':')) {
            this.err("Non-name character in an unquoted attribute value. (This is an HTML4-only error.)");
        }
    }

    protected void errLtOrEqualsOrGraveInUnquotedAttributeOrNull(char c) throws SAXException {
        switch (c) {
            case '=': {
                this.err("\u201c=\u201d at the start of an unquoted attribute value. Probable cause: Stray duplicate equals sign.");
                return;
            }
            case '<': {
                this.err("\u201c<\u201d at the start of an unquoted attribute value. Probable cause: Missing \u201c>\u201d immediately before.");
                return;
            }
            case '`': {
                this.err("\u201c`\u201d at the start of an unquoted attribute value. Probable cause: Using the wrong character as a quote.");
                return;
            }
        }
    }

    protected void errAttributeValueMissing() throws SAXException {
        this.err("Attribute value missing.");
    }

    protected void errBadCharBeforeAttributeNameOrNull(char c) throws SAXException {
        if (c == '<') {
            this.err("Saw \u201c<\u201d when expecting an attribute name. Probable cause: Missing \u201c>\u201d immediately before.");
        } else if (c == '=') {
            this.errEqualsSignBeforeAttributeName();
        } else if (c != '\ufffd') {
            this.errQuoteBeforeAttributeName(c);
        }
    }

    protected void errEqualsSignBeforeAttributeName() throws SAXException {
        this.err("Saw \u201c=\u201d when expecting an attribute name. Probable cause: Attribute name missing.");
    }

    protected void errBadCharAfterLt(char c) throws SAXException {
        this.err("Bad character \u201c" + c + "\u201d after \u201c<\u201d. Probable cause: Unescaped \u201c<\u201d. Try escaping it as \u201c&lt;\u201d.");
    }

    protected void errLtGt() throws SAXException {
        this.err("Saw \u201c<>\u201d. Probable causes: Unescaped \u201c<\u201d (escape as \u201c&lt;\u201d) or mistyped start tag.");
    }

    protected void errProcessingInstruction() throws SAXException {
        this.err("Saw \u201c<?\u201d. Probable cause: Attempt to use an XML processing instruction in HTML. (XML processing instructions are not supported in HTML.)");
    }

    protected void errUnescapedAmpersandInterpretedAsCharacterReference() throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        SAXParseException spe = new SAXParseException("The string following \u201c&\u201d was interpreted as a character reference. (\u201c&\u201d probably should have been escaped as \u201c&amp;\u201d.)", this.ampersandLocation);
        this.errorHandler.error(spe);
    }

    protected void errNotSemicolonTerminated() throws SAXException {
        this.err("Named character reference was not terminated by a semicolon. (Or \u201c&\u201d should have been escaped as \u201c&amp;\u201d.)");
    }

    protected void errNoNamedCharacterMatch() throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        SAXParseException spe = new SAXParseException("\u201c&\u201d did not start a character reference. (\u201c&\u201d probably should have been escaped as \u201c&amp;\u201d.)", this.ampersandLocation);
        this.errorHandler.error(spe);
    }

    protected void errQuoteBeforeAttributeName(char c) throws SAXException {
        this.err("Saw \u201c" + c + "\u201d when expecting an attribute name. Probable cause: \u201c=\u201d missing immediately before.");
    }

    protected void errQuoteOrLtInAttributeNameOrNull(char c) throws SAXException {
        if (c == '<') {
            this.err("\u201c<\u201d in attribute name. Probable cause: \u201c>\u201d missing immediately before.");
        } else if (c != '\ufffd') {
            this.err("Quote \u201c" + c + "\u201d in attribute name. Probable cause: Matching quote missing somewhere earlier.");
        }
    }

    protected void errExpectedPublicId() throws SAXException {
        this.err("Expected a public identifier but the doctype ended.");
    }

    protected void errBogusDoctype() throws SAXException {
        this.err("Bogus doctype.");
    }

    protected void maybeWarnPrivateUseAstral() throws SAXException {
        if (this.errorHandler != null && this.isAstralPrivateUse(this.value)) {
            this.warnAboutPrivateUseChar();
        }
    }

    protected void maybeWarnPrivateUse(char ch) throws SAXException {
        if (this.errorHandler != null && this.isPrivateUse(ch)) {
            this.warnAboutPrivateUseChar();
        }
    }

    protected void maybeErrAttributesOnEndTag(HtmlAttributes attrs) throws SAXException {
        if (attrs.getLength() != 0) {
            this.err("End tag had attributes.");
        }
    }

    protected void maybeErrSlashInEndTag(boolean selfClosing) throws SAXException {
        if (selfClosing && this.endTag) {
            this.err("Stray \u201c/\u201d at the end of an end tag.");
        }
    }

    protected char errNcrNonCharacter(char ch) throws SAXException {
        switch (this.contentNonXmlCharPolicy) {
            case FATAL: {
                this.fatal("Character reference expands to a non-character (" + this.toUPlusString((char)this.value) + ").");
                break;
            }
            case ALTER_INFOSET: {
                ch = (char)65533;
            }
            case ALLOW: {
                this.err("Character reference expands to a non-character (" + this.toUPlusString((char)this.value) + ").");
            }
        }
        return ch;
    }

    protected void errAstralNonCharacter(int ch) throws SAXException {
        this.err("Character reference expands to an astral non-character (" + this.toUPlusString(this.value) + ").");
    }

    protected void errNcrSurrogate() throws SAXException {
        this.err("Character reference expands to a surrogate.");
    }

    protected char errNcrControlChar(char ch) throws SAXException {
        switch (this.contentNonXmlCharPolicy) {
            case FATAL: {
                this.fatal("Character reference expands to a control character (" + this.toUPlusString((char)this.value) + ").");
                break;
            }
            case ALTER_INFOSET: {
                ch = (char)65533;
            }
            case ALLOW: {
                this.err("Character reference expands to a control character (" + this.toUPlusString((char)this.value) + ").");
            }
        }
        return ch;
    }

    protected void errNcrCr() throws SAXException {
        this.err("A numeric character reference expanded to carriage return.");
    }

    protected void errNcrInC1Range() throws SAXException {
        this.err("A numeric character reference expanded to the C1 controls range.");
    }

    protected void errEofInPublicId() throws SAXException {
        this.err("End of file inside public identifier.");
    }

    protected void errEofInComment() throws SAXException {
        this.err("End of file inside comment.");
    }

    protected void errEofInDoctype() throws SAXException {
        this.err("End of file inside doctype.");
    }

    protected void errEofInAttributeValue() throws SAXException {
        this.err("End of file reached when inside an attribute value. Ignoring tag.");
    }

    protected void errEofInAttributeName() throws SAXException {
        this.err("End of file occurred in an attribute name. Ignoring tag.");
    }

    protected void errEofWithoutGt() throws SAXException {
        this.err("Saw end of file without the previous tag ending with \u201c>\u201d. Ignoring tag.");
    }

    protected void errEofInTagName() throws SAXException {
        this.err("End of file seen when looking for tag name. Ignoring tag.");
    }

    protected void errEofInEndTag() throws SAXException {
        this.err("End of file inside end tag. Ignoring tag.");
    }

    protected void errEofAfterLt() throws SAXException {
        this.err("End of file after \u201c<\u201d.");
    }

    protected void errNcrOutOfRange() throws SAXException {
        this.err("Character reference outside the permissible Unicode range.");
    }

    protected void errNcrUnassigned() throws SAXException {
        this.err("Character reference expands to a permanently unassigned code point.");
    }

    protected void errDuplicateAttribute() throws SAXException {
        this.err("Duplicate attribute \u201c" + this.attributeName.getLocal(0) + "\u201d.");
    }

    protected void errEofInSystemId() throws SAXException {
        this.err("End of file inside system identifier.");
    }

    protected void errExpectedSystemId() throws SAXException {
        this.err("Expected a system identifier but the doctype ended.");
    }

    protected void errMissingSpaceBeforeDoctypeName() throws SAXException {
        this.err("Missing space before doctype name.");
    }

    protected void errHyphenHyphenBang() throws SAXException {
        this.err("\u201c--!\u201d found in comment.");
    }

    protected void errNcrControlChar() throws SAXException {
        this.err("Character reference expands to a control character (" + this.toUPlusString((char)this.value) + ").");
    }

    protected void errNcrZero() throws SAXException {
        this.err("Character reference expands to zero.");
    }

    protected void errNoSpaceBetweenDoctypeSystemKeywordAndQuote() throws SAXException {
        this.err("No space between the doctype \u201cSYSTEM\u201d keyword and the quote.");
    }

    protected void errNoSpaceBetweenPublicAndSystemIds() throws SAXException {
        this.err("No space between the doctype public and system identifiers.");
    }

    protected void errNoSpaceBetweenDoctypePublicKeywordAndQuote() throws SAXException {
        this.err("No space between the doctype \u201cPUBLIC\u201d keyword and the quote.");
    }

    protected void noteAttributeWithoutValue() throws SAXException {
        this.note("xhtml2", "Attribute without value");
    }

    protected void noteUnquotedAttributeValue() throws SAXException {
        this.note("xhtml1", "Unquoted attribute value.");
    }

    public void setTransitionHandler(TransitionHandler transitionHandler) {
        this.transitionHandler = transitionHandler;
    }

    public void setTransitionBaseOffset(int offset) {
        this.transitionBaseOffset = offset;
    }
}

