/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import org.apache.jena.atlas.lib.Pool;
import org.apache.jena.atlas.lib.PoolBase;
import org.apache.jena.atlas.lib.PoolSync;

public class Chars {
    public static final char[] digits10 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char[] hexDigitsUC = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final char[] hexDigitsLC = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final Charset charsetUTF8 = StandardCharsets.UTF_8;
    public static final Charset charsetASCII = StandardCharsets.US_ASCII;
    private static final ThreadLocal<CharsetEncoder> threadCharsetEncoder = new ThreadLocal<CharsetEncoder>(){

        @Override
        protected CharsetEncoder initialValue() {
            return Chars.createEncoder();
        }
    };
    private static final ThreadLocal<CharsetDecoder> threadCharsetDecoder = new ThreadLocal<CharsetDecoder>(){

        @Override
        protected CharsetDecoder initialValue() {
            return Chars.createDecoder();
        }
    };
    private static final int PoolSize = 2;
    private static Pool<CharsetEncoder> encoders = PoolSync.create(new PoolBase());
    private static Pool<CharsetDecoder> decoders = PoolSync.create(new PoolBase());
    public static final int EOF = -1;
    public static final char BOM = '\ufeff';
    public static final int UNSET = -2;
    public static final char NL = '\n';
    public static final char CR = '\r';
    public static final char TAB = '\t';
    public static final char SPC = ' ';
    public static final char BSPACE = '\b';
    public static final char CH_ZERO = '\u0000';
    public static final char CH_LBRACKET = '[';
    public static final char CH_RBRACKET = ']';
    public static final char CH_LBRACE = '{';
    public static final char CH_RBRACE = '}';
    public static final char CH_LPAREN = '(';
    public static final char CH_RPAREN = ')';
    public static final char CH_LT = '<';
    public static final char CH_GT = '>';
    public static final char CH_UNDERSCORE = '_';
    public static final char CH_QUOTE1 = '\'';
    public static final char CH_QUOTE2 = '\"';
    public static final char CH_EQUALS = '=';
    public static final char CH_STAR = '*';
    public static final char CH_DOT = '.';
    public static final char CH_COMMA = ',';
    public static final char CH_SEMICOLON = ';';
    public static final char CH_COLON = ':';
    public static final char CH_AMPHERSAND = '&';
    public static final char CH_AT = '@';
    public static final char CH_QMARK = '?';
    public static final char CH_HASH = '#';
    public static final char CH_PLUS = '+';
    public static final char CH_MINUS = '-';
    public static final char CH_DASH = '-';
    public static final char CH_SLASH = '/';
    public static final char CH_RSLASH = '\\';
    public static final char CH_PERCENT = '%';
    public static final byte B_NL = 10;
    public static final byte B_CR = 13;
    public static final byte B_LBRACKET = 91;
    public static final byte B_RBRACKET = 93;
    public static final byte B_LBRACE = 123;
    public static final byte B_RBRACE = 125;
    public static final byte B_LPAREN = 40;
    public static final byte B_RPAREN = 41;
    public static final byte B_LT = 60;
    public static final byte B_GT = 62;
    public static final byte B_UNDERSCORE = 95;
    public static final byte B_QUOTE1 = 39;
    public static final byte B_QUOTE2 = 34;
    public static final byte B_EQUALS = 61;
    public static final byte B_STAR = 42;
    public static final byte B_DOT = 46;
    public static final byte B_COMMA = 44;
    public static final byte B_SEMICOLON = 59;
    public static final byte B_COLON = 58;
    public static final byte B_AT = 64;
    public static final byte B_AMPHERSAND = 38;
    public static final byte B_QMARK = 63;
    public static final byte B_HASH = 35;
    public static final byte B_PLUS = 43;
    public static final byte B_MINUS = 45;
    public static final byte B_DASH = 45;
    public static final byte B_SLASH = 47;
    public static final byte B_RSLASH = 92;
    public static final byte B_PERCENT = 37;
    public static final String S_LBRACKET = "[";
    public static final String S_RBRACKET = "]";
    public static final String S_LBRACE = "{";
    public static final String S_RBRACE = "}";
    public static final String S_LPAREN = "(";
    public static final String S_RPAREN = ")";
    public static final String S_LT = "<";
    public static final String S_LE = "<=";
    public static final String S_GT = ">";
    public static final String S_GE = ">=";
    public static final String S_UNDERSCORE = "_";
    public static final String S_QUOTE1 = "'";
    public static final String S_QUOTE2 = "\"";
    public static final String S_EQUALS = "=";
    public static final String S_STAR = "*";
    public static final String S_DOT = ".";
    public static final String S_COMMA = ",";
    public static final String S_SEMICOLON = ";";
    public static final String S_COLON = ":";
    public static final String S_AMPHERSAND = "&";
    public static final String S_AT = "@";
    public static final String S_QMARK = "?";
    public static final String S_HASH = "#";
    public static final String S_PLUS = "+";
    public static final String S_MINUS = "-";
    public static final String S_DASH = "-";
    public static final String S_SLASH = "/";
    public static final String S_RSLASH = "\\";
    public static final String S_PERCENT = "%";

    private Chars() {
    }

    public static CharsetEncoder getThreadEncoder() {
        return threadCharsetEncoder.get();
    }

    public static CharsetDecoder getThreadDecoder() {
        return threadCharsetDecoder.get();
    }

    public static CharsetEncoder createEncoder() {
        return charsetUTF8.newEncoder();
    }

    public static CharsetDecoder createDecoder() {
        return charsetUTF8.newDecoder();
    }

    public static CharsetEncoder getEncoder() {
        return encoders.get();
    }

    public static void putEncoder(CharsetEncoder encoder) {
        encoders.put(encoder);
    }

    public static CharsetDecoder getDecoder() {
        return decoders.get();
    }

    public static void putDecoder(CharsetDecoder decoder) {
        decoders.put(decoder);
    }

    public static CharsetEncoder allocEncoder() {
        CharsetEncoder enc = Chars.getEncoder();
        if (enc == null) {
            enc = Chars.createEncoder();
        }
        enc.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).reset();
        return enc;
    }

    public static void deallocEncoder(CharsetEncoder enc) {
        Chars.putEncoder(enc);
    }

    public static CharsetDecoder allocDecoder() {
        CharsetDecoder dec = Chars.getDecoder();
        if (dec == null) {
            dec = Chars.createDecoder();
        }
        dec.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).reset();
        return dec;
    }

    public static void deallocDecoder(CharsetDecoder dec) {
        Chars.putDecoder(dec);
    }

    public static boolean charInArray(int ch, char[] chars) {
        for (char xch : chars) {
            if (ch != xch) continue;
            return true;
        }
        return false;
    }

    public static void encodeAsHex(StringBuilder buff, char marker, char ch) {
        if (ch < '\u0100') {
            buff.append(marker);
            int lo = ch & 0xF;
            int hi = ch >> 4 & 0xF;
            buff.append(hexDigitsUC[hi]);
            buff.append(hexDigitsUC[lo]);
            return;
        }
        int n4 = ch & 0xF;
        int n3 = ch >> 4 & 0xF;
        int n2 = ch >> 8 & 0xF;
        int n1 = ch >> 12 & 0xF;
        buff.append(marker);
        buff.append(hexDigitsUC[n1]);
        buff.append(hexDigitsUC[n2]);
        buff.append(marker);
        buff.append(hexDigitsUC[n3]);
        buff.append(hexDigitsUC[n4]);
    }

    static {
        for (int i = 0; i < 2; ++i) {
            Chars.putEncoder(Chars.createEncoder());
            Chars.putDecoder(Chars.createDecoder());
        }
    }
}

