/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.io.InputStream;
import java.util.List;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.BIOInput;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.ResultSetMgr;
import org.apache.jena.shared.NotFoundException;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.ResultSetStream;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.resultset.CSVInput;
import org.apache.jena.sparql.resultset.JSONInput;
import org.apache.jena.sparql.resultset.RDFInput;
import org.apache.jena.sparql.resultset.RDFOutput;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.resultset.ResultSetMem;
import org.apache.jena.sparql.resultset.ResultSetPeekable;
import org.apache.jena.sparql.resultset.ResultSetPeeking;
import org.apache.jena.sparql.resultset.ResultsFormat;
import org.apache.jena.sparql.resultset.SPARQLResult;
import org.apache.jena.sparql.resultset.TSVInput;
import org.apache.jena.sparql.resultset.XMLInput;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.builders.BuilderTable;
import org.apache.jena.util.FileManager;

public class ResultSetFactory {
    public static ResultSet load(String filenameOrURI) {
        return ResultSetFactory.load(filenameOrURI, null);
    }

    public static ResultSet load(String filenameOrURI, ResultsFormat format) {
        if (format == null) {
            format = ResultsFormat.guessSyntax(filenameOrURI);
        }
        InputStream in = IO.openFile(filenameOrURI);
        return ResultSetFactory.load(in, format);
    }

    public static ResultSet load(InputStream input, ResultsFormat format) {
        Lang lang;
        if (format == null) {
            Log.warn(ResultSet.class, "Null format - defaulting to XML");
            format = ResultsFormat.FMT_RS_XML;
        }
        if ((lang = ResultsFormat.convert(format)) != null) {
            return ResultSetMgr.read(input, lang);
        }
        if (format.equals(ResultsFormat.FMT_RS_JSON)) {
            return JSONInput.fromJSON(input);
        }
        if (format.equals(ResultsFormat.FMT_RS_TSV)) {
            return TSVInput.fromTSV(input);
        }
        if (format.equals(ResultsFormat.FMT_RS_CSV)) {
            return CSVInput.fromCSV(input);
        }
        if (format.equals(ResultsFormat.FMT_RS_BIO)) {
            return BIOInput.fromBIO(input);
        }
        if (format.equals(ResultsFormat.FMT_RS_XML)) {
            return ResultSetFactory.fromXML(input);
        }
        if (format.equals(ResultsFormat.FMT_TEXT)) {
            Log.warn(ResultSet.class, "Can't read a text result set");
            throw new ResultSetException("Can't read a text result set");
        }
        if (format.equals(ResultsFormat.FMT_RDF_XML)) {
            Model m = ModelFactory.createDefaultModel();
            m.read(input, null);
            return RDFInput.fromRDF(m);
        }
        if (format.equals(ResultsFormat.FMT_RDF_TTL)) {
            Model m = ModelFactory.createDefaultModel();
            m.read(input, null, "TURTLE");
            return RDFInput.fromRDF(m);
        }
        if (format.equals(ResultsFormat.FMT_RDF_N3)) {
            Model m = ModelFactory.createDefaultModel();
            m.read(input, null, "N3");
            return RDFInput.fromRDF(m);
        }
        if (format.equals(ResultsFormat.FMT_RDF_NT)) {
            Model m = ModelFactory.createDefaultModel();
            m.read(input, null, "N-TRIPLES");
            return RDFInput.fromRDF(m);
        }
        Log.warn(ResultSet.class, "Unknown result set syntax: " + format);
        return null;
    }

    public static Model loadAsModel(String filenameOrURI) {
        return ResultSetFactory.loadAsModel(null, filenameOrURI, null);
    }

    public static Model loadAsModel(Model model, String filenameOrURI) {
        return ResultSetFactory.loadAsModel(model, filenameOrURI, null);
    }

    public static Model loadAsModel(String filenameOrURI, ResultsFormat format) {
        return ResultSetFactory.loadAsModel(null, filenameOrURI, format);
    }

    public static Model loadAsModel(Model model, String filenameOrURI, ResultsFormat format) {
        if (model == null) {
            model = GraphFactory.makeDefaultModel();
        }
        if (format == null) {
            format = ResultsFormat.guessSyntax(filenameOrURI);
        }
        if (format == null) {
            Log.warn(ResultSet.class, "Null format - defaulting to XML");
            format = ResultsFormat.FMT_RS_XML;
        }
        if (format.equals(ResultsFormat.FMT_TEXT)) {
            Log.fatal(ResultSet.class, "Can't read a text result set");
            throw new ResultSetException("Can't read a text result set");
        }
        if (format.equals(ResultsFormat.FMT_RS_XML) || format.equals(ResultsFormat.FMT_RS_JSON)) {
            InputStream in = null;
            try {
                in = FileManager.get().open(filenameOrURI);
                if (in == null) {
                    throw new NotFoundException(filenameOrURI);
                }
            }
            catch (NotFoundException ex) {
                throw new NotFoundException("File not found: " + filenameOrURI);
            }
            SPARQLResult x = null;
            x = format.equals(ResultsFormat.FMT_RS_JSON) ? JSONInput.make(in, GraphFactory.makeDefaultModel()) : XMLInput.make(in, GraphFactory.makeDefaultModel());
            if (x.isResultSet()) {
                RDFOutput.encodeAsRDF(model, x.getResultSet());
            } else {
                RDFOutput.encodeAsRDF(model, x.getBooleanResult());
            }
            return model;
        }
        if (ResultsFormat.isRDFGraphSyntax(format)) {
            return FileManager.get().readModel(model, filenameOrURI);
        }
        Log.fatal(ResultSet.class, "Unknown result set syntax: " + format);
        return null;
    }

    public static SPARQLResult result(String filenameOrURI) {
        return ResultSetFactory.result(filenameOrURI, null);
    }

    public static SPARQLResult result(String filenameOrURI, ResultsFormat format) {
        if (format == null) {
            format = ResultsFormat.guessSyntax(filenameOrURI);
        }
        if (format == null) {
            Log.warn(ResultSet.class, "Null format - defaulting to XML");
            format = ResultsFormat.FMT_RS_XML;
        }
        if (format.equals(ResultsFormat.FMT_TEXT)) {
            Log.fatal(ResultSet.class, "Can't read a text result set");
            throw new ResultSetException("Can't read a text result set");
        }
        if (format.equals(ResultsFormat.FMT_RS_XML) || format.equals(ResultsFormat.FMT_RS_JSON) || format.equals(ResultsFormat.FMT_RS_TSV) || format.equals(ResultsFormat.FMT_RS_CSV)) {
            InputStream in = null;
            try {
                in = FileManager.get().open(filenameOrURI);
                if (in == null) {
                    throw new NotFoundException(filenameOrURI);
                }
            }
            catch (NotFoundException ex) {
                throw new NotFoundException("File not found: " + filenameOrURI);
            }
            Object x = null;
            if (format.equals(ResultsFormat.FMT_RS_JSON)) {
                return JSONInput.make(in, GraphFactory.makeDefaultModel());
            }
            if (format.equals(ResultsFormat.FMT_RS_XML)) {
                return XMLInput.make(in, GraphFactory.makeDefaultModel());
            }
            if (format.equals(ResultsFormat.FMT_RS_TSV)) {
                ResultSet rs = TSVInput.fromTSV(in);
                return new SPARQLResult(rs);
            }
            if (format.equals(ResultsFormat.FMT_RS_CSV)) {
                ResultSet rs = CSVInput.fromCSV(in);
                return new SPARQLResult(rs);
            }
            if (format.equals(ResultsFormat.FMT_RS_BIO)) {
                ResultSet rs = BIOInput.fromBIO(in);
                return new SPARQLResult(rs);
            }
        }
        if (ResultsFormat.isRDFGraphSyntax(format)) {
            Model model = FileManager.get().loadModel(filenameOrURI);
            return new SPARQLResult(model);
        }
        Log.fatal(ResultSet.class, "Unknown result set syntax: " + format);
        return null;
    }

    public static ResultSet fromXML(InputStream in) {
        return XMLInput.fromXML(in);
    }

    public static ResultSet fromXML(String str2) {
        return XMLInput.fromXML(str2);
    }

    public static ResultSet fromJSON(InputStream in) {
        return JSONInput.fromJSON(in);
    }

    public static ResultSet fromTSV(InputStream in) {
        return TSVInput.fromTSV(in);
    }

    public static ResultSet fromSSE(InputStream in) {
        Item item = SSE.parse(in);
        Log.warn(ResultSet.class, "Reading SSE result set not full implemented");
        BuilderTable.build(item);
        return null;
    }

    public static ResultSet makeResults(Model model) {
        return new RDFInput(model);
    }

    public static ResultSetRewindable makeRewindable(Model model) {
        return new RDFInput(model);
    }

    public static ResultSetRewindable makeRewindable(ResultSet resultSet) {
        if (resultSet instanceof ResultSetRewindable) {
            ResultSetRewindable rsw = (ResultSetRewindable)resultSet;
            rsw.reset();
            return rsw;
        }
        return new ResultSetMem(resultSet);
    }

    public static ResultSetPeekable makePeekable(ResultSet resultSet) {
        return new ResultSetPeeking(resultSet);
    }

    public static ResultSetRewindable copyResults(ResultSet results) {
        return new ResultSetMem(results);
    }

    public static ResultSet create(QueryIterator queryIterator, List<String> vars) {
        return new ResultSetStream(vars, null, queryIterator);
    }
}

