/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.sparql.graph.GraphReadOnly;

public class DatasetGraphReadOnly
extends DatasetGraphWrapper {
    private Graph dftGraph = null;
    private Map<Node, Graph> namedGraphs = new HashMap<Node, Graph>();

    public DatasetGraphReadOnly(DatasetGraph dsg) {
        super(dsg);
    }

    @Override
    public Graph getDefaultGraph() {
        if (this.dftGraph == null) {
            this.dftGraph = new GraphReadOnly(super.getDefaultGraph());
        }
        return this.dftGraph;
    }

    @Override
    public void begin(ReadWrite mode) {
        if (mode == ReadWrite.WRITE) {
            Log.warn(this, "Write transaction on a read-only dataset");
        }
        this.get().begin(mode);
    }

    @Override
    public Graph getGraph(Node graphNode) {
        if (this.namedGraphs.containsKey(graphNode)) {
            if (!super.containsGraph(graphNode)) {
                this.namedGraphs.remove(graphNode);
                return null;
            }
            return this.namedGraphs.get(graphNode);
        }
        Graph g = super.getGraph(graphNode);
        if (g == null) {
            return null;
        }
        g = new GraphReadOnly(g);
        this.namedGraphs.put(graphNode, g);
        return g;
    }

    @Override
    public void setDefaultGraph(Graph g) {
        throw new UnsupportedOperationException("read-only dataset");
    }

    @Override
    public void addGraph(Node graphName, Graph graph) {
        throw new UnsupportedOperationException("read-only dataset");
    }

    @Override
    public void removeGraph(Node graphName) {
        throw new UnsupportedOperationException("read-only dataset");
    }

    @Override
    protected DatasetGraph getW() {
        throw new UnsupportedOperationException("read-only dataset");
    }

    @Override
    public void close() {
        this.get().close();
    }
}

