/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify;

import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.modify.UpdateEngine;
import org.apache.jena.sparql.modify.UpdateEngineFactory;
import org.apache.jena.sparql.modify.UpdateSink;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;

public class UpdateProcessorBase
implements UpdateProcessor {
    protected final UpdateRequest request;
    protected final DatasetGraph datasetGraph;
    protected final Binding inputBinding;
    protected final UpdateEngineFactory factory;
    protected final Context context;

    public UpdateProcessorBase(UpdateRequest request, DatasetGraph datasetGraph, Binding inputBinding, Context context, UpdateEngineFactory factory) {
        this.request = request;
        this.datasetGraph = datasetGraph;
        this.inputBinding = inputBinding;
        this.context = Context.setupContext(context, datasetGraph);
        this.factory = factory;
    }

    @Override
    public void execute() {
        UpdateEngine uProc = this.factory.create(this.datasetGraph, this.inputBinding, this.context);
        uProc.startRequest();
        try {
            UpdateSink sink = uProc.getUpdateSink();
            Iter.sendToSink(this.request, sink);
        }
        finally {
            uProc.finishRequest();
        }
    }

    @Override
    public DatasetGraph getDatasetGraph() {
        return this.datasetGraph;
    }

    @Override
    public Context getContext() {
        return this.context;
    }
}

