/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax.syntaxtransform;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.modify.request.QuadAcc;
import org.apache.jena.sparql.modify.request.UpdateAdd;
import org.apache.jena.sparql.modify.request.UpdateClear;
import org.apache.jena.sparql.modify.request.UpdateCopy;
import org.apache.jena.sparql.modify.request.UpdateCreate;
import org.apache.jena.sparql.modify.request.UpdateDataDelete;
import org.apache.jena.sparql.modify.request.UpdateDataInsert;
import org.apache.jena.sparql.modify.request.UpdateDeleteWhere;
import org.apache.jena.sparql.modify.request.UpdateDrop;
import org.apache.jena.sparql.modify.request.UpdateLoad;
import org.apache.jena.sparql.modify.request.UpdateModify;
import org.apache.jena.sparql.modify.request.UpdateMove;
import org.apache.jena.sparql.modify.request.UpdateVisitor;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformSubst;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformer;
import org.apache.jena.sparql.syntax.syntaxtransform.ExprTransformNodeElement;
import org.apache.jena.sparql.syntax.syntaxtransform.NodeTransformSubst;
import org.apache.jena.sparql.syntax.syntaxtransform.TransformElementLib;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateRequest;

public class UpdateTransformOps {
    public static Update transform(Update update, Map<Var, Node> substitutions) {
        ElementTransformSubst eltrans = new ElementTransformSubst(substitutions);
        NodeTransformSubst nodeTransform = new NodeTransformSubst(substitutions);
        ExprTransformNodeElement exprTrans = new ExprTransformNodeElement(nodeTransform, eltrans);
        return UpdateTransformOps.transform(update, (ElementTransform)eltrans, (ExprTransform)exprTrans);
    }

    public static UpdateRequest transform(UpdateRequest update, Map<Var, Node> substitutions) {
        ElementTransformSubst eltrans = new ElementTransformSubst(substitutions);
        NodeTransformSubst nodeTransform = new NodeTransformSubst(substitutions);
        ExprTransformNodeElement exprTrans = new ExprTransformNodeElement(nodeTransform, eltrans);
        return UpdateTransformOps.transform(update, (ElementTransform)eltrans, (ExprTransform)exprTrans);
    }

    public static Update transform(Update update, ElementTransform transform, ExprTransform exprTransform) {
        UpdateTransform upParam = new UpdateTransform(transform, exprTransform);
        update.visit(upParam);
        Update update1 = upParam.result;
        return update1;
    }

    public static UpdateRequest transform(UpdateRequest update, ElementTransform transform, ExprTransform exprTransform) {
        UpdateRequest req = new UpdateRequest();
        req.getPrefixMapping().setNsPrefixes(update.getPrefixMapping());
        for (Update up : update.getOperations()) {
            up = UpdateTransformOps.transform(up, transform, exprTransform);
            req.add(up);
        }
        return req;
    }

    static class UpdateTransform
    implements UpdateVisitor {
        ElementTransform elTransform;
        ExprTransform exprTransform;
        Update result = null;

        public UpdateTransform(ElementTransform transform, ExprTransform exprTransform) {
            this.elTransform = transform;
            this.exprTransform = exprTransform;
        }

        @Override
        public void visit(UpdateDrop update) {
            this.result = update;
        }

        @Override
        public void visit(UpdateClear update) {
            this.result = update;
        }

        @Override
        public void visit(UpdateCreate update) {
            this.result = update;
        }

        @Override
        public void visit(UpdateLoad update) {
            this.result = update;
        }

        @Override
        public void visit(UpdateAdd update) {
            this.result = update;
        }

        @Override
        public void visit(UpdateCopy update) {
            this.result = update;
        }

        @Override
        public void visit(UpdateMove update) {
            this.result = update;
        }

        @Override
        public void visit(UpdateDataInsert update) {
            this.result = update;
        }

        @Override
        public void visit(UpdateDataDelete update) {
            this.result = update;
        }

        @Override
        public void visit(UpdateDeleteWhere update) {
            List<Quad> quads2;
            List<Quad> quads = update.getQuads();
            if (quads == (quads2 = this.transform(quads))) {
                this.result = update;
            } else {
                QuadAcc acc = new QuadAcc();
                this.addAll(acc, quads2);
                this.result = new UpdateDeleteWhere(acc);
            }
        }

        @Override
        public void visit(UpdateModify update) {
            Element el = update.getWherePattern();
            Element el2 = ElementTransformer.transform(el, this.elTransform, this.exprTransform);
            List<Quad> del = update.getDeleteQuads();
            List<Quad> del1 = this.transform(del);
            List<Quad> ins = update.getInsertQuads();
            List<Quad> ins1 = this.transform(ins);
            UpdateModify mod = new UpdateModify();
            this.addAll(mod.getDeleteAcc(), del1);
            this.addAll(mod.getInsertAcc(), ins1);
            mod.setElement(el2);
            this.result = mod;
        }

        private void addAll(QuadAcc acc, List<Quad> quads) {
            for (Quad q : quads) {
                acc.addQuad(q);
            }
        }

        public List<Quad> transform(List<Quad> quads) {
            ArrayList<Quad> x = new ArrayList<Quad>();
            boolean changed = false;
            for (Quad q : quads) {
                Quad q1 = this.transform(q);
                changed = changed || q1 != q;
                x.add(q1);
            }
            if (changed) {
                return x;
            }
            return quads;
        }

        private Quad transform(Quad q) {
            Node g = q.getGraph();
            Node g1 = this.transform(g);
            Node s = q.getSubject();
            Node s1 = this.transform(s);
            Node p = q.getPredicate();
            Node p1 = this.transform(p);
            Node o = q.getObject();
            Node o1 = this.transform(o);
            if (g == g1 && s == s1 && p == p1 && o == o1) {
                return q;
            }
            return Quad.create(g1, s1, p1, o1);
        }

        private Node transform(Node n) {
            if (Var.isVar(n)) {
                return TransformElementLib.apply(Var.alloc(n), this.exprTransform);
            }
            return TransformElementLib.apply(n, this.exprTransform);
        }

        @Override
        public Sink<Quad> createInsertDataSink() {
            return null;
        }

        @Override
        public Sink<Quad> createDeleteDataSink() {
            return null;
        }
    }
}

