/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.xerces.impl.dv.xs.SchemaDateTimeException;

public class MonthDV
extends AbstractDateTimeDV {
    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        try {
            return this.parse(content);
        }
        catch (Exception ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "gMonth"});
        }
    }

    protected AbstractDateTimeDV.DateTimeData parse(String str2) throws SchemaDateTimeException {
        AbstractDateTimeDV.DateTimeData date2 = new AbstractDateTimeDV.DateTimeData(str2, this);
        int len = str2.length();
        date2.year = 2000;
        date2.day = 1;
        if (str2.charAt(0) != '-' || str2.charAt(1) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonth: " + str2);
        }
        int stop = 4;
        date2.month = this.parseInt(str2, 2, stop);
        if (str2.length() >= stop + 2 && str2.charAt(stop) == '-' && str2.charAt(stop + 1) == '-') {
            stop += 2;
        }
        if (stop < len) {
            if (!this.isNextCharUTCSign(str2, stop, len)) {
                throw new SchemaDateTimeException("Error in month parsing: " + str2);
            }
            this.getTimeZone(str2, date2, stop, len);
        }
        this.validateDateTime(date2);
        this.saveUnnormalized(date2);
        if (date2.utc != 0 && date2.utc != 90) {
            this.normalize(date2);
        }
        date2.position = 1;
        return date2;
    }

    protected String dateToString(AbstractDateTimeDV.DateTimeData date2) {
        StringBuffer message = new StringBuffer(5);
        message.append('-');
        message.append('-');
        this.append(message, date2.month, 2);
        this.append(message, (char)date2.utc, 0);
        return message.toString();
    }

    protected XMLGregorianCalendar getXMLGregorianCalendar(AbstractDateTimeDV.DateTimeData date2) {
        return datatypeFactory.newXMLGregorianCalendar(Integer.MIN_VALUE, date2.unNormMonth, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, date2.hasTimeZone() ? date2.timezoneHr * 60 + date2.timezoneMin : Integer.MIN_VALUE);
    }
}

