/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xerces.util.SymbolHash;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;

public class XSNamedMapImpl
extends AbstractMap
implements XSNamedMap {
    public static final XSNamedMapImpl EMPTY_MAP = new XSNamedMapImpl(new XSObject[0], 0);
    final String[] fNamespaces;
    final int fNSNum;
    final SymbolHash[] fMaps;
    XSObject[] fArray = null;
    int fLength = -1;
    private Set fEntrySet = null;

    public XSNamedMapImpl(String namespace2, SymbolHash map) {
        this.fNamespaces = new String[]{namespace2};
        this.fMaps = new SymbolHash[]{map};
        this.fNSNum = 1;
    }

    public XSNamedMapImpl(String[] namespaces, SymbolHash[] maps, int num) {
        this.fNamespaces = namespaces;
        this.fMaps = maps;
        this.fNSNum = num;
    }

    public XSNamedMapImpl(XSObject[] array, int length) {
        if (length == 0) {
            this.fNamespaces = null;
            this.fMaps = null;
            this.fNSNum = 0;
            this.fArray = array;
            this.fLength = 0;
            return;
        }
        this.fNamespaces = new String[]{array[0].getNamespace()};
        this.fMaps = null;
        this.fNSNum = 1;
        this.fArray = array;
        this.fLength = length;
    }

    public synchronized int getLength() {
        if (this.fLength == -1) {
            this.fLength = 0;
            for (int i = 0; i < this.fNSNum; ++i) {
                this.fLength += this.fMaps[i].getLength();
            }
        }
        return this.fLength;
    }

    public XSObject itemByName(String namespace2, String localName) {
        for (int i = 0; i < this.fNSNum; ++i) {
            if (!XSNamedMapImpl.isEqual(namespace2, this.fNamespaces[i])) continue;
            if (this.fMaps != null) {
                return (XSObject)this.fMaps[i].get(localName);
            }
            for (int j = 0; j < this.fLength; ++j) {
                XSObject ret = this.fArray[j];
                if (!ret.getName().equals(localName)) continue;
                return ret;
            }
            return null;
        }
        return null;
    }

    public synchronized XSObject item(int index) {
        if (this.fArray == null) {
            this.getLength();
            this.fArray = new XSObject[this.fLength];
            int pos = 0;
            for (int i = 0; i < this.fNSNum; ++i) {
                pos += this.fMaps[i].getValues(this.fArray, pos);
            }
        }
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        return this.fArray[index];
    }

    static boolean isEqual(String one, String two) {
        return one != null ? one.equals(two) : two == null;
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public Object get(Object key) {
        if (key instanceof QName) {
            QName name = (QName)key;
            String namespaceURI = name.getNamespaceURI();
            if ("".equals(namespaceURI)) {
                namespaceURI = null;
            }
            String localPart = name.getLocalPart();
            return this.itemByName(namespaceURI, localPart);
        }
        return null;
    }

    public int size() {
        return this.getLength();
    }

    public synchronized Set entrySet() {
        if (this.fEntrySet == null) {
            final int length = this.getLength();
            final XSNamedMapEntry[] entries = new XSNamedMapEntry[length];
            for (int i = 0; i < length; ++i) {
                XSObject xso = this.item(i);
                entries[i] = new XSNamedMapEntry(new QName(xso.getNamespace(), xso.getName()), xso);
            }
            this.fEntrySet = new AbstractSet(){

                public Iterator iterator() {
                    return new Iterator(){
                        private int index = 0;

                        public boolean hasNext() {
                            return this.index < length;
                        }

                        public Object next() {
                            if (this.index < length) {
                                return entries[this.index++];
                            }
                            throw new NoSuchElementException();
                        }

                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                public int size() {
                    return length;
                }
            };
        }
        return this.fEntrySet;
    }

    private static final class XSNamedMapEntry
    implements Map.Entry {
        private final QName key;
        private final XSObject value;

        public XSNamedMapEntry(QName key, XSObject value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e2 = (Map.Entry)o;
                Object otherKey = e2.getKey();
                Object otherValue = e2.getValue();
                return (this.key == null ? otherKey == null : this.key.equals(otherKey)) && (this.value == null ? otherValue == null : this.value.equals(otherValue));
            }
            return false;
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(String.valueOf(this.key));
            buffer.append('=');
            buffer.append(String.valueOf(this.value));
            return buffer.toString();
        }
    }
}

