/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.xni.parser;

import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;

public class XMLParseException
extends XNIException {
    static final long serialVersionUID = 1732959359448549967L;
    protected String fPublicId;
    protected String fLiteralSystemId;
    protected String fExpandedSystemId;
    protected String fBaseSystemId;
    protected int fLineNumber = -1;
    protected int fColumnNumber = -1;
    protected int fCharacterOffset = -1;

    public XMLParseException(XMLLocator locator, String message) {
        super(message);
        if (locator != null) {
            this.fPublicId = locator.getPublicId();
            this.fLiteralSystemId = locator.getLiteralSystemId();
            this.fExpandedSystemId = locator.getExpandedSystemId();
            this.fBaseSystemId = locator.getBaseSystemId();
            this.fLineNumber = locator.getLineNumber();
            this.fColumnNumber = locator.getColumnNumber();
            this.fCharacterOffset = locator.getCharacterOffset();
        }
    }

    public XMLParseException(XMLLocator locator, String message, Exception exception) {
        super(message, exception);
        if (locator != null) {
            this.fPublicId = locator.getPublicId();
            this.fLiteralSystemId = locator.getLiteralSystemId();
            this.fExpandedSystemId = locator.getExpandedSystemId();
            this.fBaseSystemId = locator.getBaseSystemId();
            this.fLineNumber = locator.getLineNumber();
            this.fColumnNumber = locator.getColumnNumber();
            this.fCharacterOffset = locator.getCharacterOffset();
        }
    }

    public String getPublicId() {
        return this.fPublicId;
    }

    public String getExpandedSystemId() {
        return this.fExpandedSystemId;
    }

    public String getLiteralSystemId() {
        return this.fLiteralSystemId;
    }

    public String getBaseSystemId() {
        return this.fBaseSystemId;
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public int getColumnNumber() {
        return this.fColumnNumber;
    }

    public int getCharacterOffset() {
        return this.fCharacterOffset;
    }

    public String toString() {
        Exception exception;
        StringBuffer str2 = new StringBuffer();
        if (this.fPublicId != null) {
            str2.append(this.fPublicId);
        }
        str2.append(':');
        if (this.fLiteralSystemId != null) {
            str2.append(this.fLiteralSystemId);
        }
        str2.append(':');
        if (this.fExpandedSystemId != null) {
            str2.append(this.fExpandedSystemId);
        }
        str2.append(':');
        if (this.fBaseSystemId != null) {
            str2.append(this.fBaseSystemId);
        }
        str2.append(':');
        str2.append(this.fLineNumber);
        str2.append(':');
        str2.append(this.fColumnNumber);
        str2.append(':');
        str2.append(this.fCharacterOffset);
        str2.append(':');
        String message = this.getMessage();
        if (message == null && (exception = this.getException()) != null) {
            message = exception.getMessage();
        }
        if (message != null) {
            str2.append(message);
        }
        return str2.toString();
    }
}

