/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class RmCommand
extends GitCommand<DirCache> {
    private Collection<String> filepatterns = new LinkedList<String>();
    private boolean cached = false;

    public RmCommand(Repository repo) {
        super(repo);
    }

    public RmCommand addFilepattern(String filepattern) {
        this.checkCallable();
        this.filepatterns.add(filepattern);
        return this;
    }

    public RmCommand setCached(boolean cached) {
        this.checkCallable();
        this.cached = cached;
        return this;
    }

    @Override
    public DirCache call() throws GitAPIException, NoFilepatternException {
        if (this.filepatterns.isEmpty()) {
            throw new NoFilepatternException(JGitText.get().atLeastOnePatternIsRequired);
        }
        this.checkCallable();
        DirCache dc = null;
        try (TreeWalk tw = new TreeWalk(this.repo);){
            dc = this.repo.lockDirCache();
            DirCacheBuilder builder = dc.builder();
            tw.reset();
            tw.setRecursive(true);
            tw.setFilter(PathFilterGroup.createFromStrings(this.filepatterns));
            tw.addTree(new DirCacheBuildIterator(builder));
            while (tw.next()) {
                FileMode mode;
                if (this.cached || (mode = tw.getFileMode(0)).getObjectType() != 3) continue;
                File path = new File(this.repo.getWorkTree(), tw.getPathString());
                this.delete(path);
            }
            builder.commit();
            this.setCallable(false);
        }
        catch (IOException e2) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfRmCommand, e2);
        }
        finally {
            if (dc != null) {
                dc.unlock();
            }
        }
        return dc;
    }

    private void delete(File p) {
        while (p != null && !p.equals(this.repo.getWorkTree()) && p.delete()) {
            p = p.getParentFile();
        }
    }
}

