/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.PushCertificate;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class PushCertificateStore
implements AutoCloseable {
    static final String REF_NAME = "refs/meta/push-certs";
    private final Repository db;
    private final List<PendingCert> pending;
    ObjectReader reader;
    RevCommit commit;

    public PushCertificateStore(Repository db) {
        this.db = db;
        this.pending = new ArrayList<PendingCert>();
    }

    @Override
    public void close() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
            this.commit = null;
        }
    }

    public PushCertificate get(String refName) throws IOException {
        if (this.reader == null) {
            this.load();
        }
        try (TreeWalk tw = this.newTreeWalk(refName);){
            PushCertificate pushCertificate = PushCertificateStore.read(tw);
            return pushCertificate;
        }
    }

    public Iterable<PushCertificate> getAll(final String refName) {
        return new Iterable<PushCertificate>(){

            @Override
            public Iterator<PushCertificate> iterator() {
                return new Iterator<PushCertificate>(){
                    private final String path;
                    private PushCertificate next;
                    private RevWalk rw;
                    {
                        this.path = PushCertificateStore.pathName(refName);
                        try {
                            if (PushCertificateStore.this.reader == null) {
                                PushCertificateStore.this.load();
                            }
                            if (PushCertificateStore.this.commit != null) {
                                this.rw = new RevWalk(PushCertificateStore.this.reader);
                                this.rw.setTreeFilter(AndTreeFilter.create(PathFilterGroup.create(Collections.singleton(PathFilter.create(this.path))), TreeFilter.ANY_DIFF));
                                this.rw.setRewriteParents(false);
                                this.rw.markStart(this.rw.parseCommit(PushCertificateStore.this.commit));
                            } else {
                                this.rw = null;
                            }
                        }
                        catch (IOException e2) {
                            throw new RuntimeException(e2);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean hasNext() {
                        try {
                            block22: {
                                if (this.next == null) {
                                    if (this.rw == null) {
                                        boolean bl = false;
                                        return bl;
                                    }
                                    try {
                                        RevCommit c = this.rw.next();
                                        if (c != null) {
                                            try (TreeWalk tw = TreeWalk.forPath(this.rw.getObjectReader(), this.path, c.getTree());){
                                                this.next = PushCertificateStore.read(tw);
                                                break block22;
                                            }
                                        }
                                        this.next = null;
                                    }
                                    catch (IOException e2) {
                                        throw new RuntimeException(e2);
                                    }
                                }
                            }
                            boolean bl = this.next != null;
                            return bl;
                        }
                        finally {
                            if (this.next == null && this.rw != null) {
                                this.rw.close();
                                this.rw = null;
                            }
                        }
                    }

                    @Override
                    public PushCertificate next() {
                        this.hasNext();
                        PushCertificate n = this.next;
                        if (n == null) {
                            throw new NoSuchElementException();
                        }
                        this.next = null;
                        return n;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    void load() throws IOException {
        this.close();
        this.reader = this.db.newObjectReader();
        Ref ref = this.db.getRefDatabase().exactRef(REF_NAME);
        if (ref == null) {
            return;
        }
        try (RevWalk rw = new RevWalk(this.reader);){
            this.commit = rw.parseCommit(ref.getObjectId());
        }
    }

    /*
     * Exception decompiling
     */
    static PushCertificate read(TreeWalk tw) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void put(PushCertificate cert, PersonIdent ident) {
        this.put(cert, ident, null);
    }

    public void put(PushCertificate cert, PersonIdent ident, Collection<ReceiveCommand> matching) {
        this.pending.add(new PendingCert(cert, ident, matching));
    }

    /*
     * Loose catch block
     */
    public RefUpdate.Result save() throws IOException {
        ObjectId newId = this.write();
        if (newId == null) {
            return RefUpdate.Result.NO_CHANGE;
        }
        try {
            try (ObjectInserter inserter = this.db.newObjectInserter();){
                RefUpdate.Result result = this.updateRef(newId);
                switch (result) {
                    case FAST_FORWARD: 
                    case NEW: 
                    case NO_CHANGE: {
                        this.pending.clear();
                        break;
                    }
                }
                RefUpdate.Result result2 = result;
                return result2;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.close();
        }
    }

    public boolean save(BatchRefUpdate batch) throws IOException {
        ObjectId newId = this.write();
        if (newId == null || newId.equals(this.commit)) {
            return false;
        }
        batch.addCommand(new ReceiveCommand(this.commit != null ? this.commit : ObjectId.zeroId(), newId, REF_NAME));
        return true;
    }

    public void clear() {
        this.pending.clear();
    }

    private ObjectId write() throws IOException {
        if (this.pending.isEmpty()) {
            return null;
        }
        if (this.reader == null) {
            this.load();
        }
        PushCertificateStore.sortPending(this.pending);
        ObjectId curr = this.commit;
        DirCache dc = this.newDirCache();
        try (ObjectInserter inserter = this.db.newObjectInserter();){
            for (PendingCert pc : this.pending) {
                curr = this.saveCert(inserter, dc, pc, curr);
            }
            inserter.flush();
            RevCommit revCommit = curr;
            return revCommit;
        }
    }

    private static void sortPending(List<PendingCert> pending) {
        Collections.sort(pending, new Comparator<PendingCert>(){

            @Override
            public int compare(PendingCert a, PendingCert b) {
                return Long.signum(a.ident.getWhen().getTime() - b.ident.getWhen().getTime());
            }
        });
    }

    private DirCache newDirCache() throws IOException {
        if (this.commit != null) {
            return DirCache.read(this.reader, this.commit.getTree());
        }
        return DirCache.newInCore();
    }

    private ObjectId saveCert(ObjectInserter inserter, DirCache dc, PendingCert pc, ObjectId curr) throws IOException {
        HashMap<String, ReceiveCommand> byRef;
        if (pc.matching != null) {
            byRef = new HashMap<String, ReceiveCommand>();
            for (ReceiveCommand cmd : pc.matching) {
                if (byRef.put(cmd.getRefName(), cmd) == null) continue;
                throw new IllegalStateException();
            }
        } else {
            byRef = null;
        }
        DirCacheEditor editor = dc.editor();
        String certText = pc.cert.toText() + pc.cert.getSignature();
        final ObjectId certId = inserter.insert(3, certText.getBytes(StandardCharsets.UTF_8));
        boolean any = false;
        for (ReceiveCommand cmd : pc.cert.getCommands()) {
            if (byRef != null && !PushCertificateStore.commandsEqual(cmd, (ReceiveCommand)byRef.get(cmd.getRefName()))) continue;
            any = true;
            editor.add(new DirCacheEditor.PathEdit(PushCertificateStore.pathName(cmd.getRefName())){

                @Override
                public void apply(DirCacheEntry ent) {
                    ent.setFileMode(FileMode.REGULAR_FILE);
                    ent.setObjectId(certId);
                }
            });
        }
        if (!any) {
            return curr;
        }
        editor.finish();
        CommitBuilder cb = new CommitBuilder();
        cb.setAuthor(pc.ident);
        cb.setCommitter(pc.ident);
        cb.setTreeId(dc.writeTree(inserter));
        if (curr != null) {
            cb.setParentId(curr);
        } else {
            cb.setParentIds(Collections.emptyList());
        }
        cb.setMessage(PushCertificateStore.buildMessage(pc.cert));
        return inserter.insert(1, cb.build());
    }

    private static boolean commandsEqual(ReceiveCommand c1, ReceiveCommand c2) {
        if (c1 == null || c2 == null) {
            return c1 == c2;
        }
        return c1.getRefName().equals(c2.getRefName()) && c1.getOldId().equals(c2.getOldId()) && c1.getNewId().equals(c2.getNewId());
    }

    private RefUpdate.Result updateRef(ObjectId newId) throws IOException {
        RefUpdate ru = this.db.updateRef(REF_NAME);
        ru.setExpectedOldObjectId(this.commit != null ? this.commit : ObjectId.zeroId());
        ru.setNewObjectId(newId);
        ru.setRefLogIdent(this.pending.get((int)(this.pending.size() - 1)).ident);
        ru.setRefLogMessage(JGitText.get().storePushCertReflog, false);
        try (RevWalk rw = new RevWalk(this.reader);){
            RefUpdate.Result result = ru.update(rw);
            return result;
        }
    }

    private TreeWalk newTreeWalk(String refName) throws IOException {
        if (this.commit == null) {
            return null;
        }
        return TreeWalk.forPath(this.reader, PushCertificateStore.pathName(refName), this.commit.getTree());
    }

    static String pathName(String refName) {
        return refName + "@{cert}";
    }

    private static String buildMessage(PushCertificate cert) {
        StringBuilder sb = new StringBuilder();
        if (cert.getCommands().size() == 1) {
            sb.append(MessageFormat.format(JGitText.get().storePushCertOneRef, cert.getCommands().get(0).getRefName()));
        } else {
            sb.append(MessageFormat.format(JGitText.get().storePushCertMultipleRefs, cert.getCommands().size()));
        }
        return sb.append('\n').toString();
    }

    private static class PendingCert {
        PushCertificate cert;
        PersonIdent ident;
        Collection<ReceiveCommand> matching;

        PendingCert(PushCertificate cert, PersonIdent ident, Collection<ReceiveCommand> matching) {
            this.cert = cert;
            this.ident = ident;
            this.matching = matching;
        }
    }
}

