/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.CompoundException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackLock;
import org.eclipse.jgit.internal.storage.file.UnpackedObject;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.DateRevQueue;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.BaseFetchConnection;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase;
import org.eclipse.jgit.transport.WalkTransport;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.FileUtils;

class WalkFetchConnection
extends BaseFetchConnection {
    final Repository local;
    final ObjectChecker objCheck;
    private final List<WalkRemoteObjectDatabase> remotes;
    private int lastRemoteIdx;
    private final RevWalk revWalk;
    private final TreeWalk treeWalk;
    private final RevFlag COMPLETE;
    private final RevFlag IN_WORK_QUEUE;
    private final RevFlag LOCALLY_SEEN;
    private final DateRevQueue localCommitQueue;
    private LinkedList<ObjectId> workQueue;
    private final LinkedList<WalkRemoteObjectDatabase> noPacksYet;
    private final LinkedList<WalkRemoteObjectDatabase> noAlternatesYet;
    private final LinkedList<RemotePack> unfetchedPacks;
    private final Set<String> packsConsidered;
    private final MutableObjectId idBuffer = new MutableObjectId();
    private final HashMap<ObjectId, List<Throwable>> fetchErrors;
    String lockMessage;
    final List<PackLock> packLocks;
    final ObjectInserter inserter;
    private final ObjectReader reader;

    WalkFetchConnection(WalkTransport t, WalkRemoteObjectDatabase w) {
        Transport wt = (Transport)((Object)t);
        this.local = wt.local;
        this.objCheck = wt.getObjectChecker();
        this.inserter = this.local.newObjectInserter();
        this.reader = this.inserter.newReader();
        this.remotes = new ArrayList<WalkRemoteObjectDatabase>();
        this.remotes.add(w);
        this.unfetchedPacks = new LinkedList();
        this.packsConsidered = new HashSet<String>();
        this.noPacksYet = new LinkedList();
        this.noPacksYet.add(w);
        this.noAlternatesYet = new LinkedList();
        this.noAlternatesYet.add(w);
        this.fetchErrors = new HashMap();
        this.packLocks = new ArrayList<PackLock>(4);
        this.revWalk = new RevWalk(this.reader);
        this.revWalk.setRetainBody(false);
        this.treeWalk = new TreeWalk(this.reader);
        this.COMPLETE = this.revWalk.newFlag("COMPLETE");
        this.IN_WORK_QUEUE = this.revWalk.newFlag("IN_WORK_QUEUE");
        this.LOCALLY_SEEN = this.revWalk.newFlag("LOCALLY_SEEN");
        this.localCommitQueue = new DateRevQueue();
        this.workQueue = new LinkedList();
    }

    @Override
    public boolean didFetchTestConnectivity() {
        return true;
    }

    @Override
    protected void doFetch(ProgressMonitor monitor, Collection<Ref> want, Set<ObjectId> have) throws TransportException {
        this.markLocalRefsComplete(have);
        this.queueWants(want);
        while (!monitor.isCancelled() && !this.workQueue.isEmpty()) {
            ObjectId id = this.workQueue.removeFirst();
            if (!(id instanceof RevObject) || !((RevObject)id).has(this.COMPLETE)) {
                this.downloadObject(monitor, id);
            }
            this.process(id);
        }
        try {
            this.inserter.flush();
        }
        catch (IOException e2) {
            throw new TransportException(e2.getMessage(), e2);
        }
    }

    @Override
    public Collection<PackLock> getPackLocks() {
        return this.packLocks;
    }

    @Override
    public void setPackLockMessage(String message) {
        this.lockMessage = message;
    }

    @Override
    public void close() {
        this.inserter.close();
        this.reader.close();
        for (RemotePack p : this.unfetchedPacks) {
            if (p.tmpIdx == null) continue;
            p.tmpIdx.delete();
        }
        for (WalkRemoteObjectDatabase r : this.remotes) {
            r.close();
        }
    }

    private void queueWants(Collection<Ref> want) throws TransportException {
        HashSet<ObjectId> inWorkQueue = new HashSet<ObjectId>();
        for (Ref r : want) {
            ObjectId id = r.getObjectId();
            if (id == null) {
                throw new NullPointerException(MessageFormat.format(JGitText.get().transportProvidedRefWithNoObjectId, r.getName()));
            }
            try {
                RevObject obj = this.revWalk.parseAny(id);
                if (obj.has(this.COMPLETE) || !inWorkQueue.add(id)) continue;
                obj.add(this.IN_WORK_QUEUE);
                this.workQueue.add(obj);
            }
            catch (MissingObjectException e2) {
                if (!inWorkQueue.add(id)) continue;
                this.workQueue.add(id);
            }
            catch (IOException e3) {
                throw new TransportException(MessageFormat.format(JGitText.get().cannotRead, id.name()), e3);
            }
        }
    }

    private void process(ObjectId id) throws TransportException {
        RevObject obj;
        try {
            if (id instanceof RevObject) {
                obj = (RevObject)id;
                if (obj.has(this.COMPLETE)) {
                    return;
                }
                this.revWalk.parseHeaders(obj);
            } else {
                obj = this.revWalk.parseAny(id);
                if (obj.has(this.COMPLETE)) {
                    return;
                }
            }
        }
        catch (IOException e2) {
            throw new TransportException(MessageFormat.format(JGitText.get().cannotRead, id.name()), e2);
        }
        switch (obj.getType()) {
            case 3: {
                this.processBlob(obj);
                break;
            }
            case 2: {
                this.processTree(obj);
                break;
            }
            case 1: {
                this.processCommit(obj);
                break;
            }
            case 4: {
                this.processTag(obj);
                break;
            }
            default: {
                throw new TransportException(MessageFormat.format(JGitText.get().unknownObjectType, id.name()));
            }
        }
        this.fetchErrors.remove(id);
    }

    private void processBlob(RevObject obj) throws TransportException {
        try {
            if (!this.reader.has(obj, 3)) {
                throw new TransportException(MessageFormat.format(JGitText.get().cannotReadBlob, obj.name()), new MissingObjectException((ObjectId)obj, "blob"));
            }
            obj.add(this.COMPLETE);
        }
        catch (IOException error) {
            throw new TransportException(MessageFormat.format(JGitText.get().cannotReadBlob, obj.name()), error);
        }
    }

    private void processTree(RevObject obj) throws TransportException {
        try {
            this.treeWalk.reset((AnyObjectId)obj);
            block5: while (this.treeWalk.next()) {
                FileMode mode = this.treeWalk.getFileMode(0);
                int sType = mode.getObjectType();
                switch (sType) {
                    case 2: 
                    case 3: {
                        this.treeWalk.getObjectId(this.idBuffer, 0);
                        this.needs(this.revWalk.lookupAny(this.idBuffer, sType));
                        continue block5;
                    }
                }
                if (FileMode.GITLINK.equals(mode)) continue;
                this.treeWalk.getObjectId(this.idBuffer, 0);
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().invalidModeFor, mode, this.idBuffer.name(), this.treeWalk.getPathString(), obj.getId().name()));
            }
        }
        catch (IOException ioe) {
            throw new TransportException(MessageFormat.format(JGitText.get().cannotReadTree, obj.name()), ioe);
        }
        obj.add(this.COMPLETE);
    }

    private void processCommit(RevObject obj) throws TransportException {
        RevCommit commit = (RevCommit)obj;
        this.markLocalCommitsComplete(commit.getCommitTime());
        this.needs(commit.getTree());
        for (RevCommit p : commit.getParents()) {
            this.needs(p);
        }
        obj.add(this.COMPLETE);
    }

    private void processTag(RevObject obj) {
        RevTag tag = (RevTag)obj;
        this.needs(tag.getObject());
        obj.add(this.COMPLETE);
    }

    private void needs(RevObject obj) {
        if (obj.has(this.COMPLETE)) {
            return;
        }
        if (!obj.has(this.IN_WORK_QUEUE)) {
            obj.add(this.IN_WORK_QUEUE);
            this.workQueue.add(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadObject(ProgressMonitor pm, AnyObjectId id) throws TransportException {
        if (this.alreadyHave(id)) {
            return;
        }
        block5: while (true) {
            Object packNameList;
            int i;
            if (this.downloadPackedObject(pm, id)) {
                return;
            }
            String idStr = id.name();
            String subdir = idStr.substring(0, 2);
            String file = idStr.substring(2);
            String looseName = subdir + "/" + file;
            for (i = this.lastRemoteIdx; i < this.remotes.size(); ++i) {
                if (!this.downloadLooseObject(id, looseName, this.remotes.get(i))) continue;
                this.lastRemoteIdx = i;
                return;
            }
            for (i = 0; i < this.lastRemoteIdx; ++i) {
                if (!this.downloadLooseObject(id, looseName, this.remotes.get(i))) continue;
                this.lastRemoteIdx = i;
                return;
            }
            while (!this.noPacksYet.isEmpty()) {
                WalkRemoteObjectDatabase wrr = this.noPacksYet.removeFirst();
                try {
                    pm.beginTask(JGitText.get().listingPacks, 0);
                    packNameList = wrr.getPackNames();
                }
                catch (IOException e2) {
                    this.recordError(id, e2);
                    continue;
                }
                finally {
                    pm.endTask();
                    continue;
                }
                if (packNameList == null || packNameList.isEmpty()) continue;
                Iterator e2 = packNameList.iterator();
                while (e2.hasNext()) {
                    String packName = (String)e2.next();
                    if (!this.packsConsidered.add(packName)) continue;
                    this.unfetchedPacks.add(new RemotePack(wrr, packName));
                }
                if (!this.downloadPackedObject(pm, id)) continue;
                return;
            }
            Collection<WalkRemoteObjectDatabase> al = this.expandOneAlternate(id, pm);
            if (al == null || al.isEmpty()) break;
            packNameList = al.iterator();
            while (true) {
                if (!packNameList.hasNext()) continue block5;
                WalkRemoteObjectDatabase alt2 = (WalkRemoteObjectDatabase)packNameList.next();
                this.remotes.add(alt2);
                this.noPacksYet.add(alt2);
                this.noAlternatesYet.add(alt2);
            }
            break;
        }
        List<Throwable> failures = this.fetchErrors.get(id);
        TransportException te = new TransportException(MessageFormat.format(JGitText.get().cannotGet, id.name()));
        if (failures != null && !failures.isEmpty()) {
            if (failures.size() == 1) {
                te.initCause(failures.get(0));
            } else {
                te.initCause(new CompoundException(failures));
            }
        }
        throw te;
    }

    private boolean alreadyHave(AnyObjectId id) throws TransportException {
        try {
            return this.reader.has(id);
        }
        catch (IOException error) {
            throw new TransportException(MessageFormat.format(JGitText.get().cannotReadObject, id.name()), error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadPackedObject(ProgressMonitor monitor, AnyObjectId id) throws TransportException {
        Iterator packItr = this.unfetchedPacks.iterator();
        while (packItr.hasNext() && !monitor.isCancelled()) {
            RemotePack pack = (RemotePack)packItr.next();
            try {
                pack.openIndex(monitor);
            }
            catch (IOException err) {
                this.recordError(id, err);
                packItr.remove();
                continue;
            }
            if (monitor.isCancelled()) {
                return false;
            }
            if (!pack.index.hasObject(id)) continue;
            try {
                pack.downloadPack(monitor);
            }
            catch (IOException err) {
                this.recordError(id, err);
                continue;
            }
            finally {
                try {
                    if (pack.tmpIdx != null) {
                        FileUtils.delete(pack.tmpIdx);
                    }
                }
                catch (IOException e2) {
                    throw new TransportException(e2.getMessage(), e2);
                }
                packItr.remove();
                continue;
            }
            if (!this.alreadyHave(id)) {
                this.recordError(id, new FileNotFoundException(MessageFormat.format(JGitText.get().objectNotFoundIn, id.name(), pack.packName)));
                continue;
            }
            Iterator<ObjectId> pending = this.swapFetchQueue();
            while (pending.hasNext()) {
                ObjectId p = pending.next();
                if (pack.index.hasObject(p)) {
                    pending.remove();
                    this.process(p);
                    continue;
                }
                this.workQueue.add(p);
            }
            return true;
        }
        return false;
    }

    private Iterator<ObjectId> swapFetchQueue() {
        Iterator<ObjectId> r = this.workQueue.iterator();
        this.workQueue = new LinkedList();
        return r;
    }

    private boolean downloadLooseObject(AnyObjectId id, String looseName, WalkRemoteObjectDatabase remote) throws TransportException {
        try {
            byte[] compressed = remote.open(looseName).toArray();
            this.verifyAndInsertLooseObject(id, compressed);
            return true;
        }
        catch (FileNotFoundException e2) {
            this.recordError(id, e2);
            return false;
        }
        catch (IOException e3) {
            throw new TransportException(MessageFormat.format(JGitText.get().cannotDownload, id.name()), e3);
        }
    }

    private void verifyAndInsertLooseObject(AnyObjectId id, byte[] compressed) throws IOException {
        ObjectId act;
        ObjectLoader uol;
        try {
            uol = UnpackedObject.parse(compressed, id);
        }
        catch (CorruptObjectException parsingError) {
            FileNotFoundException e2 = new FileNotFoundException(id.name());
            e2.initCause(parsingError);
            throw e2;
        }
        int type = uol.getType();
        byte[] raw = uol.getCachedBytes();
        if (this.objCheck != null) {
            try {
                this.objCheck.check(id, type, raw);
            }
            catch (CorruptObjectException e3) {
                throw new TransportException(MessageFormat.format(JGitText.get().transportExceptionInvalid, Constants.typeString(type), id.name(), e3.getMessage()));
            }
        }
        if (!AnyObjectId.equals(id, act = this.inserter.insert(type, raw))) {
            throw new TransportException(MessageFormat.format(JGitText.get().incorrectHashFor, id.name(), act.name(), Constants.typeString(type), compressed.length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<WalkRemoteObjectDatabase> expandOneAlternate(AnyObjectId id, ProgressMonitor pm) {
        while (!this.noAlternatesYet.isEmpty()) {
            WalkRemoteObjectDatabase wrr = this.noAlternatesYet.removeFirst();
            try {
                pm.beginTask(JGitText.get().listingAlternates, 0);
                Collection<WalkRemoteObjectDatabase> altList = wrr.getAlternates();
                if (altList == null || altList.isEmpty()) continue;
                Collection<WalkRemoteObjectDatabase> collection = altList;
                return collection;
            }
            catch (IOException e2) {
                this.recordError(id, e2);
            }
            finally {
                pm.endTask();
            }
        }
        return null;
    }

    private void markLocalRefsComplete(Set<ObjectId> have) throws TransportException {
        Map<String, Ref> refs;
        try {
            refs = this.local.getRefDatabase().getRefs("");
        }
        catch (IOException e2) {
            throw new TransportException(e2.getMessage(), e2);
        }
        for (Ref r : refs.values()) {
            try {
                this.markLocalObjComplete(this.revWalk.parseAny(r.getObjectId()));
            }
            catch (IOException readError) {
                throw new TransportException(MessageFormat.format(JGitText.get().localRefIsMissingObjects, r.getName()), readError);
            }
        }
        for (ObjectId id : have) {
            try {
                this.markLocalObjComplete(this.revWalk.parseAny(id));
            }
            catch (IOException readError) {
                throw new TransportException(MessageFormat.format(JGitText.get().transportExceptionMissingAssumed, id.name()), readError);
            }
        }
    }

    private void markLocalObjComplete(RevObject obj) throws IOException {
        while (obj.getType() == 4) {
            obj.add(this.COMPLETE);
            obj = ((RevTag)obj).getObject();
            this.revWalk.parseHeaders(obj);
        }
        switch (obj.getType()) {
            case 3: {
                obj.add(this.COMPLETE);
                break;
            }
            case 1: {
                this.pushLocalCommit((RevCommit)obj);
                break;
            }
            case 2: {
                this.markTreeComplete((RevTree)obj);
            }
        }
    }

    private void markLocalCommitsComplete(int until) throws TransportException {
        try {
            block2: while (true) {
                RevCommit c;
                if ((c = this.localCommitQueue.peek()) == null || c.getCommitTime() < until) {
                    return;
                }
                this.localCommitQueue.next();
                this.markTreeComplete(c.getTree());
                RevCommit[] revCommitArray = c.getParents();
                int n = revCommitArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block2;
                    RevCommit p = revCommitArray[n2];
                    this.pushLocalCommit(p);
                    ++n2;
                }
                break;
            }
        }
        catch (IOException err) {
            throw new TransportException(JGitText.get().localObjectsIncomplete, err);
        }
    }

    private void pushLocalCommit(RevCommit p) throws MissingObjectException, IOException {
        if (p.has(this.LOCALLY_SEEN)) {
            return;
        }
        this.revWalk.parseHeaders(p);
        p.add(this.LOCALLY_SEEN);
        p.add(this.COMPLETE);
        p.carry(this.COMPLETE);
        this.localCommitQueue.add(p);
    }

    private void markTreeComplete(RevTree tree) throws IOException {
        if (tree.has(this.COMPLETE)) {
            return;
        }
        tree.add(this.COMPLETE);
        this.treeWalk.reset((AnyObjectId)tree);
        block4: while (this.treeWalk.next()) {
            FileMode mode = this.treeWalk.getFileMode(0);
            int sType = mode.getObjectType();
            switch (sType) {
                case 3: {
                    this.treeWalk.getObjectId(this.idBuffer, 0);
                    this.revWalk.lookupAny(this.idBuffer, sType).add(this.COMPLETE);
                    continue block4;
                }
                case 2: {
                    this.treeWalk.getObjectId(this.idBuffer, 0);
                    RevObject o = this.revWalk.lookupAny(this.idBuffer, sType);
                    if (o.has(this.COMPLETE)) continue block4;
                    o.add(this.COMPLETE);
                    this.treeWalk.enterSubtree();
                    continue block4;
                }
            }
            if (FileMode.GITLINK.equals(mode)) continue;
            this.treeWalk.getObjectId(this.idBuffer, 0);
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().corruptObjectInvalidMode3, mode, this.idBuffer.name(), this.treeWalk.getPathString(), tree.name()));
        }
    }

    private void recordError(AnyObjectId id, Throwable what) {
        ObjectId objId = id.copy();
        List<Throwable> errors = this.fetchErrors.get(objId);
        if (errors == null) {
            errors = new ArrayList<Throwable>(2);
            this.fetchErrors.put(objId, errors);
        }
        errors.add(what);
    }

    private class RemotePack {
        final WalkRemoteObjectDatabase connection;
        final String packName;
        final String idxName;
        File tmpIdx;
        PackIndex index;

        RemotePack(WalkRemoteObjectDatabase c, String pn) {
            this.connection = c;
            this.packName = pn;
            String tn = this.idxName = this.packName.substring(0, this.packName.length() - 5) + ".idx";
            if (tn.startsWith("pack-")) {
                tn = tn.substring(5);
            }
            if (tn.endsWith(".idx")) {
                tn = tn.substring(0, tn.length() - 4);
            }
            if (WalkFetchConnection.this.local.getObjectDatabase() instanceof ObjectDirectory) {
                this.tmpIdx = new File(((ObjectDirectory)WalkFetchConnection.this.local.getObjectDatabase()).getDirectory(), "walk-" + tn + ".walkidx");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void openIndex(ProgressMonitor pm) throws IOException {
            if (this.index != null) {
                return;
            }
            if (this.tmpIdx == null) {
                this.tmpIdx = File.createTempFile("jgit-walk-", ".idx");
            } else if (this.tmpIdx.isFile()) {
                try {
                    this.index = PackIndex.open(this.tmpIdx);
                    return;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            WalkRemoteObjectDatabase.FileStream s = this.connection.open("pack/" + this.idxName);
            pm.beginTask("Get " + this.idxName.substring(0, 12) + "..idx", s.length < 0L ? 0 : (int)(s.length / 1024L));
            try (FileOutputStream fos = new FileOutputStream(this.tmpIdx);){
                int cnt;
                byte[] buf = new byte[2048];
                while (!pm.isCancelled() && (cnt = s.in.read(buf)) >= 0) {
                    fos.write(buf, 0, cnt);
                    pm.update(cnt / 1024);
                }
            }
            catch (IOException err) {
                FileUtils.delete(this.tmpIdx);
                throw err;
            }
            finally {
                s.in.close();
            }
            pm.endTask();
            if (pm.isCancelled()) {
                FileUtils.delete(this.tmpIdx);
                return;
            }
            try {
                this.index = PackIndex.open(this.tmpIdx);
            }
            catch (IOException e2) {
                FileUtils.delete(this.tmpIdx);
                throw e2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void downloadPack(ProgressMonitor monitor) throws IOException {
            String name = "pack/" + this.packName;
            WalkRemoteObjectDatabase.FileStream s = this.connection.open(name);
            try {
                PackParser parser = WalkFetchConnection.this.inserter.newPackParser(s.in);
                parser.setAllowThin(false);
                parser.setObjectChecker(WalkFetchConnection.this.objCheck);
                parser.setLockMessage(WalkFetchConnection.this.lockMessage);
                PackLock lock = parser.parse(monitor);
                if (lock != null) {
                    WalkFetchConnection.this.packLocks.add(lock);
                }
            }
            finally {
                s.in.close();
            }
        }
    }
}

